/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.river.api.security.PermissionGrant;
import org.apache.river.api.security.PermissionGrantBuilder;
import org.apache.river.api.security.PolicyUtils;
import org.apache.river.api.security.SubjectDomain;

class PrincipalGrant
extends PermissionGrant
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final CodeSource nullCS = new CodeSource((URL)null, (Certificate[])null);
    protected final Set<Principal> pals;
    private final int hashCode;

    PrincipalGrant(Principal[] pals, Permission[] perm) {
        super(perm);
        if (pals != null) {
            HashSet<Principal> palCol = new HashSet<Principal>(pals.length);
            palCol.addAll(Arrays.asList(pals));
            this.pals = Collections.unmodifiableSet(palCol);
        } else {
            this.pals = Collections.emptySet();
        }
        int hash = 5;
        hash = 97 * hash + (this.pals != null ? this.pals.hashCode() : 0);
        for (Permission p : this.getPermissions()) {
            if (p instanceof UnresolvedPermission) {
                hash = 97 * hash + p.hashCode();
                continue;
            }
            if (p == null) continue;
            Class<?> c = p.getClass();
            String name = p.getName();
            String actions = p.getActions();
            hash = 97 * hash + (c != null ? c.hashCode() : 0);
            hash = 97 * hash + (name != null ? name.hashCode() : 0);
            hash = 97 * hash + (actions != null ? actions.hashCode() : 0);
        }
        this.hashCode = hash;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.hashCode() != this.hashCode()) {
            return false;
        }
        if (o instanceof PrincipalGrant) {
            PrincipalGrant p = (PrincipalGrant)o;
            if (this.pals.equals(p.pals) && this.getPermissions().equals(p.getPermissions())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(300);
        sb.append("Principals: \n");
        Iterator<Principal> palIt = this.pals.iterator();
        while (palIt.hasNext()) {
            sb.append(palIt.next().toString()).append("\n");
        }
        sb.append("\nPermissions: \n");
        Iterator<Permission> permIt = this.getPermissions().iterator();
        while (permIt.hasNext()) {
            sb.append(permIt.next().toString()).append("\n");
        }
        return sb.toString();
    }

    boolean implies(Principal[] prs) {
        if (this.pals.isEmpty()) {
            return true;
        }
        if (prs == null || prs.length == 0) {
            return false;
        }
        List<Principal> princp = Arrays.asList(prs);
        int matches = 0;
        block0: for (Principal entrypal : this.pals) {
            for (Principal implied : princp) {
                if (!entrypal.equals(implied)) continue;
                ++matches;
                continue block0;
            }
        }
        return matches == this.pals.size();
    }

    @Deprecated
    CodeSource normalizeCodeSource(CodeSource codeSource) {
        if (codeSource == null) {
            return null;
        }
        URI codeSourceURI = null;
        try {
            codeSourceURI = PolicyUtils.normalizeURL(codeSource.getLocation());
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace(System.err);
        }
        CodeSource result = codeSource;
        try {
            if (codeSourceURI != null && codeSourceURI.toURL() != codeSource.getLocation()) {
                CodeSigner[] signers = codeSource.getCodeSigners();
                result = signers == null ? new CodeSource(codeSourceURI.toURL(), codeSource.getCertificates()) : new CodeSource(codeSourceURI.toURL(), signers);
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace(System.err);
        }
        return result;
    }

    @Override
    public boolean implies(ProtectionDomain pd) {
        if (this.pals.isEmpty()) {
            return true;
        }
        if (pd == null) {
            return false;
        }
        Principal[] hasPrincipals = this.getPrincipals(pd);
        return this.implies(hasPrincipals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Principal[] getPrincipals(ProtectionDomain pd) {
        if (pd instanceof SubjectDomain) {
            Set<Principal> principals = ((SubjectDomain)((Object)pd)).getSubject().getPrincipals();
            Principal[] result = null;
            Iterator<Principal> it = null;
            Set<Principal> set = principals;
            synchronized (set) {
                result = new Principal[principals.size()];
                it = principals.iterator();
            }
            boolean retry = true;
            while (retry) {
                try {
                    int i = 0;
                    while (it.hasNext()) {
                        result[i] = it.next();
                        ++i;
                    }
                    return result;
                }
                catch (ConcurrentModificationException e) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(20L);
                        Set<Principal> set2 = principals;
                        synchronized (set2) {
                            result = new Principal[principals.size()];
                            it = principals.iterator();
                        }
                    }
                    catch (InterruptedException ex) {
                        retry = false;
                        Thread.currentThread().interrupt();
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    retry = false;
                    System.err.println("ArrayIndexOutOfBoundsException occured during iteration of Subject Principals");
                    e.printStackTrace(System.err);
                }
            }
        }
        return pd.getPrincipals();
    }

    @Override
    public boolean implies(ClassLoader cl, Principal[] pal) {
        return this.implies(pal);
    }

    @Override
    public boolean implies(CodeSource codeSource, Principal[] pal) {
        return this.implies(pal);
    }

    @Override
    public PermissionGrantBuilder getBuilderTemplate() {
        PermissionGrantBuilder pgb = PermissionGrantBuilder.newBuilder();
        Collection<Permission> perms = this.getPermissions();
        pgb.context(3).principals(this.pals.toArray(new Principal[this.pals.size()])).permissions(perms.toArray(new Permission[perms.size()]));
        return pgb;
    }

    @Override
    public boolean isVoid() {
        return this.getPermissions().isEmpty();
    }

    private Object writeReplace() {
        return this.getBuilderTemplate();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("PermissionGrantBuilder required");
    }
}

