/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.security.Principal;
import org.apache.river.api.security.Messages;

final class UnresolvedPrincipal
implements Principal {
    static final String WILDCARD = "*";
    private final String klass;
    private final String name;

    UnresolvedPrincipal(String klass, String name) {
        if (klass == null || klass.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.91"));
        }
        this.klass = klass;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.klass;
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof UnresolvedPrincipal) {
            UnresolvedPrincipal up = (UnresolvedPrincipal)that;
            return this.klass.equals(up.klass) && (this.name == null ? up.name == null : this.name.equals(up.name));
        }
        if (that instanceof Principal) {
            return this.implies((Principal)that);
        }
        return false;
    }

    public boolean implies(Principal another) {
        return another != null && (WILDCARD.equals(this.klass) || this.klass.equals(another.getClass().getName()) && (WILDCARD.equals(this.name) || (this.name == null ? another.getName() == null : this.name.equals(another.getName()))));
    }

    @Override
    public int hashCode() {
        int hash = 0;
        if (this.name != null) {
            hash ^= this.name.hashCode();
        }
        if (this.klass != null) {
            hash ^= this.klass.hashCode();
        }
        return hash;
    }

    @Override
    public String toString() {
        return "Principal " + this.klass + " \"" + this.name + "\"";
    }
}

