/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.extra.helpers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.id.Uuid;
import net.jini.jeri.BasicInvocationHandler;
import net.jini.jeri.BasicObjectEndpoint;
import net.jini.jeri.Endpoint;
import org.apache.river.extra.helpers.ConfigHelper;
import org.apache.river.extra.helpers.ProxyHelper;

public class ImportHelper
extends ConfigHelper {
    private static final Logger logger = Logger.getLogger(ImportHelper.class.getName());

    public ImportHelper(URL resource) throws ConfigurationException {
        super(resource);
    }

    public ImportHelper(Configuration configuration) {
        super(configuration);
    }

    public <T> T getInstance(Endpoint endpoint, Class<T> cls, String component) throws RemoteException, ConfigurationException {
        Uuid uuid = this.getUuid(component);
        boolean dgc = this.getDgc(component);
        if (uuid == null) {
            throw new ConfigurationException("should specify uuid");
        }
        BasicObjectEndpoint oe = new BasicObjectEndpoint(endpoint, uuid, dgc);
        InvocationConstraints ic = this.getInvocationConstraints(component);
        if (ic == null) {
            ic = InvocationConstraints.EMPTY;
        }
        BasicMethodConstraints serverConstraints = new BasicMethodConstraints(ic);
        BasicInvocationHandler handler = new BasicInvocationHandler(oe, (MethodConstraints)serverConstraints);
        Object inst = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{cls}, (InvocationHandler)handler);
        ProxyHelper ph = this.getProxyHelper(component);
        inst = ph.prepare(inst, component);
        return (T)inst;
    }

    public <T> T getInstance(Endpoint endpoint, Class<T> cls) throws RemoteException, ConfigurationException {
        String component = this.getComponent(cls);
        return this.getInstance(endpoint, cls, component);
    }
}

