#include "IRremote.hpp"     //must copy IRremote library to arduino libraries
#include <Servo.h>
#define plus 24   //clockwise rotation button
#define minus 82  //counter clockwise rotation button

#define IR_RECEIVE_PIN  3 //IR receiver Signal pin connect to Arduino pin D3  
Servo servo;
int val;                //rotation angle
bool cwRotation, ccwRotation;  //the states of rotation

void setup()
{
  Serial.begin(9600);
  IrReceiver.begin(IR_RECEIVE_PIN, DISABLE_LED_FEEDBACK);     
  servo.attach(9);     //servo pin
}

void loop() 
{
  if (IrReceiver.decode()) {
    uint16_t command = IrReceiver.decodedIRData.command;
       IrReceiver.resume();// Receive the next value

    if (command == plus)
    {
      cwRotation = !cwRotation;      //toggle the rotation value
      ccwRotation = false;         //no rotation in this direction
    }

    if (command == minus)
    {
      ccwRotation = !ccwRotation;   //toggle the rotation value
      cwRotation = false;            //no rotation in this direction
    }
  }
  if (cwRotation && (val != 175))  {
    val++;                         //for colockwise button
  }
  if (ccwRotation && (val != 0))  {
    val--;                         //for counter colockwise button
  }
  servo.write(val);
  delay(20);          //General speed
}
