/*  ___   ___  ___  _   _  ___   ___   ____ ___  ____  
 * / _ \ /___)/ _ \| | | |/ _ \ / _ \ / ___) _ \|    \ 
 *| |_| |___ | |_| | |_| | |_| | |_| ( (__| |_| | | | |
 * \___/(___/ \___/ \__  |\___/ \___(_)____)___/|_|_|_|
 *                  (____/ 
 *This example is to test the IR receiver, we modify the 
 *last sketch, when specific buttons are pressed, we will 
 *use the incoming values to print the corrseponding buttons’ 
 *name of the IR control.
 * Tutorial URL http://osoyoo.com/2017/07/20/arduino-lesson-ir-remotecontrol/
 * CopyRight www.osoyoo.com
 */
#include "IRremote.hpp"

#define IR_RECEIVE_PIN 2

void setup()   /*----( SETUP: RUNS ONCE )----*/
{
  Serial.begin(9600);
  Serial.println("IR Receiver Raw Data + Button Decode Test");
  IrReceiver.begin(IR_RECEIVE_PIN, ENABLE_LED_FEEDBACK); 
}/*--(end setup )---*/

void loop()   /*----( LOOP: RUNS CONSTANTLY )----*/
{
  if (IrReceiver.decode()) {
    
    translateIR(); 
    IrReceiver.resume();
  }  
}/* --(end main loop )-- */

/*-----( Declare User-written Functions )-----*/
void translateIR() // takes action based on IR code received
// describing Car MP3 IR codes 
{
  uint16_t command = IrReceiver.decodedIRData.command;
  switch(command)
  {
  case 69:  
    Serial.println(" CH-            "); 
    break;
  case 70:  
    Serial.println(" CH             "); 
    break;
  case 71:  
    Serial.println(" CH+            "); 
    break;
  case 68:  
    Serial.println(" PREV           "); 
    break;
  case 64:  
    Serial.println(" NEXT           "); 
    break;
  case 67:  
    Serial.println(" PLAY/PAUSE     "); 
    break;
  case 7:  
    Serial.println(" VOL-           "); 
    break;
  case 21:  
    Serial.println(" VOL+           "); 
    break;
  case 9:  
    Serial.println(" EQ             "); 
    break;
  case 22:  
    Serial.println(" 0              "); 
    break;
  case 25:  
    Serial.println(" 100+           "); 
    break;
  case 13:  
    Serial.println(" 200+           "); 
    break;
  case 12:  
    Serial.println(" 1              "); 
    break;
  case 24:  
    Serial.println(" 2              "); 
    break;
  case 94:  
    Serial.println(" 3              "); 
    break;
  case 8:  
    Serial.println(" 4              "); 
    break;
  case 28:  
    Serial.println(" 5              "); 
    break;
  case 90:  
    Serial.println(" 6              "); 
    break;
  case 66:  
    Serial.println(" 7              "); 
    break;
  case 82:  
    Serial.println(" 8              "); 
    break;
  case 74:  
    Serial.println(" 9              "); 
    break;
  default: 
    Serial.println(" other button   ");
  }
  delay(100);
} //END translateIR

