/*  ___   ___  ___  _   _  ___   ___   ____ ___  ____  
 * / _ \ /___)/ _ \| | | |/ _ \ / _ \ / ___) _ \|    \ 
 *| |_| |___ | |_| | |_| | |_| | |_| ( (__| |_| | | | |
 * \___/(___/ \___/ \__  |\___/ \___(_)____)___/|_|_|_|
 *                  (____/ 
 *This example is to control the led by IR sensor,when you press the key, 
 *infrared rays will be emitted from the remote control and received by 
 *the infrared receiver, and the LED on the Osoyoo Uno board will light 
 *up. Connect an LED to pin 13 on the Osoyoo Uno board so that you can 
 *see remotely whether the Power  key is pressed down.
 * Tutorial URL http://osoyoo.com/2017/07/20/arduino-lesson-ir-remotecontrol/
 * CopyRight www.osoyoo.com
 */
#include "IRremote.hpp"
#define IR_RECEIVE_PIN 2
const int ledPin = 3;

void setup()
{
  pinMode(ledPin,OUTPUT);//set ledpin as OUTPUT
  Serial.begin(9600);//initialize serial 
  IrReceiver.begin(IR_RECEIVE_PIN, DISABLE_LED_FEEDBACK); 
}
void loop() 
{
  if (IrReceiver.decode()) //if the ir receiver module receiver data
  { uint16_t command = IrReceiver.decodedIRData.command;
  if(command == 69)
  {
    digitalWrite(ledPin,HIGH);//turn on the led
  }
  else
  {
    digitalWrite(ledPin,LOW);//turn off the led
  }
    IrReceiver.resume();
  } 
  delay(100); //delay 100ms
}
