/*  ___   ___  ___  _   _  ___   ___   ____ ___  ____  
 * / _ \ /___)/ _ \| | | |/ _ \ / _ \ / ___) _ \|    \ 
 *| |_| |___ | |_| | |_| | |_| | |_| ( (__| |_| | | | |
 * \___/(___/ \___/ \__  |\___/ \___(_)____)___/|_|_|_|
 *                  (____/ 
 * In this lesson, we will show how to turn on/off an LED by 
 * using an I/O port and a button: click the button to turn on 
 * the LED, and then press this button, the LED will be turned off.
 * Tutorial URLhttp://osoyoo.com/2017/07/02/arduino-lesson-button/
 * CopyRight www.osoyoo.com
 */
#define LED 13 // Set D13 as the LED pin
#define BUTTON 12 //Set D12 as the button pin
//Let's say you have your push button on pin 12
int switchState = 0; // actual read value from pin12
int oldSwitchState = 0; // last read value from pin12
int lightsOn = 0; // is the switch on = 1 or off = 0

void setup() { 
 pinMode(BUTTON, INPUT); // set the push button as input
 pinMode(LED, OUTPUT); // anything you want to control using a switch e.g. a Led
}
void loop() {
 switchState = digitalRead(BUTTON); // read the pushButton State
 if (switchState != oldSwitchState) // catch change
 {
 oldSwitchState = switchState;
 if (switchState == HIGH)
 {
 // toggle
 lightsOn = !lightsOn;
 }
 }
 if(lightsOn)
 {
 digitalWrite(LED, HIGH); // set the LED on
 } else {
 digitalWrite(LED, LOW); // set the LED off
 }
 }

