/*  ___   ___  ___  _   _  ___   ___   ____ ___  ____  
 * / _ \ /___)/ _ \| | | |/ _ \ / _ \ / ___) _ \|    \ 
 *| |_| |___ | |_| | |_| | |_| | |_| ( (__| |_| | | | |
 * \___/(___/ \___/ \__  |\___/ \___(_)____)___/|_|_|_|
 *                  (____/ 
 * This is the Arduino tilt switch module sketch.
 * In this example, we will use a tilt switch module and an 
 * on-board LED that has been attached to pin 13 of the Osoyoo 
 * board to build a simple circuit. Then the tilt switch outputs 
 * low signals and the LED will be on. Otherwise it will be off.
 * Tutorial URL http://osoyoo.com/2017/07/31/arduino-lesson-tilt-sensor-module/
 * CopyRight www.osoyoo.com
 */
const int sigPin = 2; // the number of the tilt switch pin
const int ledPin = 13; // the number of the LED pin
// variables will change:
boolean sigState = 0; // variable for reading the tilt switch status
void setup()
{
  // initialize the LED pin as an output:
  pinMode(ledPin, OUTPUT); 
  // initialize the tilt switch pin as an input:
  pinMode(sigPin, INPUT); 
}
void loop()
{
  // read the state of the tilt switch value:
  sigState = digitalRead(sigPin);
  if (sigState == HIGH)
  { 
    // turn LED on: 
    digitalWrite(ledPin, LOW); 
  } 
  else
  {
    // turn LED off:
    digitalWrite(ledPin, HIGH); 
  }
}
