/*
welcome use KeDeiTFT
*/
#include "KeDei_font.h"


//Word stock


static unsigned char font16_B[95][16]={
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*" ",0*/
			{0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x38,0x38,0x00,0x00},/*"!",1*/
			{0x00,0xD8,0xFC,0x6C,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*""",2*/
			{0x00,0x00,0x00,0x6C,0x6C,0x6C,0xFF,0x36,0x36,0x36,0xFF,0x36,0x36,0x36,0x00,0x00},/*"#",3*/
			{0x00,0x00,0x18,0x3C,0x7E,0x7E,0x1E,0x1C,0x38,0x78,0x78,0x7E,0x7E,0x3C,0x18,0x18},/*"$",4*/
			{0x00,0x00,0x00,0x66,0x6F,0x3F,0x3F,0x3F,0x7E,0xF8,0xFC,0xFC,0xFC,0x66,0x00,0x00},/*"%",5*/
			{0x00,0x00,0x00,0x1C,0x36,0x36,0x36,0x1E,0xFE,0x6F,0x7B,0x33,0xB3,0xFE,0x00,0x00},/*"&",6*/
			{0x00,0x0E,0x0E,0x0C,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"'",7*/
			{0x00,0xC0,0x60,0x30,0x30,0x18,0x18,0x18,0x18,0x18,0x18,0x30,0x30,0x60,0xC0,0x00},/*"(",8*/
			{0x00,0x06,0x0C,0x18,0x18,0x30,0x30,0x30,0x30,0x30,0x30,0x18,0x18,0x0C,0x06,0x00},/*")",9*/
			{0x00,0x00,0x00,0x00,0x18,0x18,0xFF,0x3C,0x3C,0xFF,0x18,0x18,0x00,0x00,0x00,0x00},/*"*",10*/
			{0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18,0x18,0x00,0x00,0x00},/*"+",11*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x0E,0x0C,0x07},/*",",12*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"-",13*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x0E,0x00,0x00},/*".",14*/
			{0x00,0x00,0x80,0xC0,0xC0,0x60,0x60,0x30,0x30,0x18,0x18,0x0C,0x0C,0x06,0x06,0x00},/*"/",15*/
			{0x00,0x00,0x00,0x38,0x6C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x6C,0x38,0x00,0x00},/*"0",16*/
			{0x00,0x00,0x00,0x18,0x1E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00},/*"1",17*/
			{0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x60,0x60,0x30,0x18,0x0C,0xC6,0xFE,0x00,0x00},/*"2",18*/
			{0x00,0x00,0x00,0x7C,0xC6,0xC6,0x60,0x38,0x60,0xC0,0xC0,0xC6,0x66,0x3C,0x00,0x00},/*"3",19*/
			{0x00,0x00,0x00,0x60,0x70,0x78,0x6C,0x6C,0x66,0x66,0xFE,0x60,0x60,0xF8,0x00,0x00},/*"4",20*/
			{0x00,0x00,0x00,0xFE,0x06,0x06,0x06,0x3E,0x6E,0xC0,0xC0,0xC6,0x66,0x3C,0x00,0x00},/*"5",21*/
			{0x00,0x00,0x00,0x78,0x6C,0x06,0x06,0x3E,0x6E,0xC6,0xC6,0xC6,0x6C,0x38,0x00,0x00},/*"6",22*/
			{0x00,0x00,0x00,0xFE,0x66,0x66,0x30,0x30,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00},/*"7",23*/
			{0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x6C,0x38,0x6C,0xC6,0xC6,0xC6,0x7C,0x00,0x00},/*"8",24*/
			{0x00,0x00,0x00,0x38,0x6C,0xC6,0xC6,0xC6,0xEC,0xF8,0xC0,0xC0,0x6C,0x3C,0x00,0x00},/*"9",25*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x00,0x00,0x00,0x00,0x38,0x38,0x00,0x00},/*":",26*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x0C},/*";",27*/
			{0x00,0x00,0x00,0xC0,0x60,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x60,0xC0,0x00,0x00},/*"<",28*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00},/*"=",29*/
			{0x00,0x00,0x00,0x06,0x0C,0x18,0x30,0x60,0xC0,0x60,0x30,0x18,0x0C,0x06,0x00,0x00},/*">",30*/
			{0x00,0x00,0x00,0x7C,0xC6,0xC6,0xCE,0xC0,0x60,0x30,0x30,0x00,0x38,0x38,0x00,0x00},/*"?",31*/
			{0x00,0x00,0x00,0x3C,0x66,0xFE,0xFF,0xFF,0xFF,0xFF,0x7F,0xC6,0x66,0x3C,0x00,0x00},/*"@",32*/
			{0x00,0x00,0x00,0x18,0x18,0x38,0x3C,0x3C,0x6C,0x7C,0x66,0xC6,0xC6,0xEF,0x00,0x00},/*"A",33*/
			{0x00,0x00,0x00,0x3F,0x66,0x66,0x66,0x3E,0x66,0xC6,0xC6,0xC6,0x66,0x3F,0x00,0x00},/*"B",34*/
			{0x00,0x00,0x00,0xFC,0xC6,0xC6,0x03,0x03,0x03,0x03,0x03,0xC6,0x66,0x3C,0x00,0x00},/*"C",35*/
			{0x00,0x00,0x00,0x3F,0x66,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x66,0x3F,0x00,0x00},/*"D",36*/
			{0x00,0x00,0x00,0x7F,0xC6,0x36,0x36,0x3E,0x36,0x36,0x06,0xC6,0xC6,0x7F,0x00,0x00},/*"E",37*/
			{0x00,0x00,0x00,0x7F,0xC6,0x36,0x36,0x3E,0x36,0x36,0x06,0x06,0x06,0x0F,0x00,0x00},/*"F",38*/
			{0x00,0x00,0x00,0x7C,0x66,0x66,0x03,0x03,0x03,0xF3,0x63,0x66,0x66,0x3C,0x00,0x00},/*"G",39*/
			{0x00,0x00,0x00,0xEF,0xC6,0xC6,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0xEF,0x00,0x00},/*"H",40*/
			{0x00,0x00,0x00,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00},/*"I",41*/
			{0x00,0x00,0x00,0xFC,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x33,0x1F},/*"J",42*/
			{0x00,0x00,0x00,0xFF,0x66,0x36,0x1E,0x1E,0x1E,0x36,0x36,0x66,0x66,0xFF,0x00,0x00},/*"K",43*/
			{0x00,0x00,0x00,0x0F,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0xC6,0xFF,0x00,0x00},/*"L",44*/
			{0x00,0x00,0x00,0xFF,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0xFF,0x00,0x00},/*"M",45*/
			{0x00,0x00,0x00,0xE7,0xCE,0xCE,0xDE,0xDE,0xF6,0xF6,0xF6,0xE6,0xE6,0xCF,0x00,0x00},/*"N",46*/
			{0x00,0x00,0x00,0x3C,0x66,0xC3,0xC3,0xC3,0xC3,0xC3,0xC3,0xC3,0x66,0x3C,0x00,0x00},/*"O",47*/
			{0x00,0x00,0x00,0x7F,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x06,0x06,0x06,0x0F,0x00,0x00},/*"P",48*/
			{0x00,0x00,0x00,0x3C,0x66,0xC3,0xC3,0xC3,0xC3,0xC3,0xDF,0xF7,0x76,0x3C,0xE0,0x00},/*"Q",49*/
			{0x00,0x00,0x00,0x7F,0xC6,0xC6,0xC6,0x7E,0x36,0x36,0x66,0x66,0xC6,0xCF,0x00,0x00},/*"R",50*/
			{0x00,0x00,0x00,0xFC,0xC6,0xC6,0x06,0x0C,0x38,0x60,0xC0,0xC6,0xC6,0x7E,0x00,0x00},/*"S",51*/
			{0x00,0x00,0x00,0xFF,0xDB,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00},/*"T",52*/
			{0x00,0x00,0x00,0xEF,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00},/*"U",53*/
			{0x00,0x00,0x00,0xEF,0xC6,0xC6,0x66,0x6C,0x6C,0x3C,0x3C,0x38,0x18,0x18,0x00,0x00},/*"V",54*/
			{0x00,0x00,0x00,0xFF,0xDB,0xDB,0xDB,0xDB,0xFF,0xFF,0x7E,0x66,0x66,0x66,0x00,0x00},/*"W",55*/
			{0x00,0x00,0x00,0xEF,0xC6,0x6C,0x6C,0x38,0x38,0x38,0x6C,0x6C,0xC6,0xEF,0x00,0x00},/*"X",56*/
			{0x00,0x00,0x00,0xFF,0x66,0x66,0x3C,0x3C,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00},/*"Y",57*/
			{0x00,0x00,0x00,0xFE,0x63,0x60,0x30,0x30,0x18,0x0C,0x0C,0xC6,0xC6,0x7F,0x00,0x00},/*"Z",58*/
			{0x00,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x00},/*"[",59*/
			{0x00,0x00,0x06,0x06,0x0C,0x0C,0x18,0x18,0x18,0x30,0x30,0x60,0x60,0x60,0xC0,0xC0},/*"\",60*/
			{0x00,0x3E,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3E,0x00},/*"]",61*/
			{0x00,0x78,0xCC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"^",62*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF},/*"_",63*/
			{0x00,0x0E,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"`",64*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xF8,0xCC,0xC6,0xC6,0xFC,0x00,0x00},/*"a",65*/
			{0x00,0x00,0x00,0x07,0x06,0x06,0x06,0x3E,0x6E,0xC6,0xC6,0xC6,0x6E,0x3E,0x00,0x00},/*"b",66*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0xCC,0x06,0x06,0x06,0xCC,0x78,0x00,0x00},/*"c",67*/
			{0x00,0x00,0x00,0xE0,0xC0,0xC0,0xC0,0xF8,0xCC,0xC6,0xC6,0xC6,0xEC,0xF8,0x00,0x00},/*"d",68*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xFE,0x06,0x06,0xC6,0x7C,0x00,0x00},/*"e",69*/
			{0x00,0x00,0x00,0xF0,0x98,0x18,0x18,0xFE,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00},/*"f",70*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x66,0x66,0x3C,0x06,0x7C,0xC6,0xC6,0x7C},/*"g",71*/
			{0x00,0x00,0x00,0x07,0x06,0x06,0x06,0x7E,0xCE,0xC6,0xC6,0xC6,0xC6,0xEF,0x00,0x00},/*"h",72*/
			{0x00,0x00,0x00,0x1C,0x1C,0x00,0x00,0x1E,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00},/*"i",73*/
			{0x00,0x00,0x00,0x70,0x70,0x00,0x00,0x78,0x60,0x60,0x60,0x60,0x60,0x60,0x66,0x3E},/*"j",74*/
			{0x00,0x00,0x00,0x07,0x06,0x06,0x06,0xF6,0x36,0x1E,0x3E,0x36,0x66,0xFF,0x00,0x00},/*"k",75*/
			{0x00,0x00,0x00,0x1E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00},/*"l",76*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xB6,0xB6,0xB6,0xB6,0xB6,0xFF,0x00,0x00},/*"m",77*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xCE,0xC6,0xC6,0xC6,0xC6,0xEF,0x00,0x00},/*"n",78*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00},/*"o",79*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x6E,0xC6,0xC6,0xC6,0x66,0x3E,0x06,0x0F},/*"p",80*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xCC,0xC6,0xC6,0xC6,0xCC,0xF8,0xC0,0xE0},/*"q",81*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xDC,0x0C,0x0C,0x0C,0x0C,0x3F,0x00,0x00},/*"r",82*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xC6,0x06,0x7C,0xC0,0xC6,0x7E,0x00,0x00},/*"s",83*/
			{0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x18,0x18,0x18,0x70,0x00,0x00},/*"t",84*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE7,0xC6,0xC6,0xC6,0xC6,0xE6,0xFC,0x00,0x00},/*"u",85*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xEF,0xC6,0x6C,0x6C,0x3C,0x18,0x18,0x00,0x00},/*"v",86*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xDB,0xDB,0xFF,0xFF,0x66,0x66,0x00,0x00},/*"w",87*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x6C,0x38,0x38,0x38,0x6C,0xFE,0x00,0x00},/*"x",88*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xEF,0xC6,0x6C,0x6C,0x3C,0x38,0x18,0x18,0x0F},/*"y",89*/
			{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x66,0x30,0x18,0x18,0xCC,0xFE,0x00,0x00},/*"z",90*/
			{0x00,0xC0,0x60,0x60,0x60,0x60,0x60,0x30,0x60,0x60,0x60,0x60,0x60,0x60,0xC0,0x00},/*"{",91*/
			{0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30},/*"|",92*/
			{0x00,0x0E,0x18,0x18,0x18,0x18,0x18,0x30,0x18,0x18,0x18,0x18,0x18,0x18,0x0E,0x00},/*"}",93*/
			{0x1C,0x76,0xC6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"~",94*/
		};


/*****************************************
 *The function name  begin
 *Function   ʼеĳԱ
 *Input   none
 *Output    none
 *Author   KeDei
 *Time   2015/4/21
 ****************************************/
void Font::begin(void)
{
		
		font_color		= 0xf800;
		font_size		= 16;
		txt_x0			= 0;
		txt_y0			= 0;
		txt_x1			= 240;
		txt_y1			= 320;

		now_x			= txt_x0;
		now_y			= txt_y0;
		char_m			= 0;
		char_n			= 0;
}

/*****************************************
 *The function name  set_txt
 *Function   ıı(x0,y0),(x1,y1)
			ıɫΪtxt_b_color
			txt_b_colorΪNULL ʾɫ0x0000Ҳһ ^.^
 *Input   none
 *Output    none
 *Author   KeDei
 *Time   2015/4/21
 ****************************************/
void Font::set_txt(unsigned short x0,unsigned short y0,unsigned short x1,unsigned short y1,unsigned short txt_b_color)
{
	txt_x0			= x0;
	txt_y0			= y0;
	txt_x1			= x1;
	txt_y1			= y1;
	now_x			= x0;
	now_y			= y0;
	txt_backcolor	= txt_b_color;
	//if(txt_b_color != NULL)
		TFT.draw_area(x0,y0,x1,y1,txt_b_color);
	
}

/*****************************************
 *The function name  set_fontcolor
 *Function   ɫΪf_color
 *Input   f_color
 *Output    none
 *Author   KeDei
 *Time   2015/4/21
 ****************************************/
void Font::set_fontcolor(unsigned short f_color)
{
	font_color	= f_color;
}


/*****************************************
 *The function name  clear_txt
 *Function   ǰı
 *Input   color  no used
 *Output    none
 *Author   KeDei
 *Time   2015/4/21
 ****************************************/
void Font::clear_txt(unsigned short color)
{
	TFT.draw_area(txt_x0,txt_y0,txt_x1,txt_y1,txt_backcolor);
}


/*****************************************
 *The function name  lcd_char
 *Function   ʾַ
 *Input   data
 *Output    none
 *Author    KeDei
 *Time    2015/4/21
 ****************************************/
void Font::lcd_char(char _data)
{

	if(now_x > txt_x1-(font_size/2)) 
	{
		now_x =  txt_x0;
		now_y += 16;
	}
	if(now_y > txt_y1-16)
	{
		now_y = txt_y0;
		clear_txt(txt_backcolor);
	}

	char_i=(int)_data-32;

//Serial.println(char_i);
	for(char_m = 0;char_m < 16;char_m++)
	{

		for(char_n = 0; char_n < 8;char_n++)
		{

		   if(font16_B[char_i][char_m]&1<<char_n)
			{
			   TFT.set_area(now_x,now_y,++now_x,now_y);
			   TFT.w_data(font_color>>8);
			   TFT.w_data(font_color);
			}
			else
			{
			  now_x++;
  
			}
		 }
		 now_y++;
		 now_x-=8;
	}
	now_y-=16;
	now_x+= 8+font_interval;
}

/*****************************************
 *The function name  lcd_string
 *Function   ʾַ
 *Input   *str
 *Output    none
 *Author    KeDei
 *Time    2015/4/21
 ****************************************/
void Font::lcd_string(char str[])
{
  char *str_char=str;
  for(;;)
  {
      if(*str_char == '\0')
      {
          now_y+=16;
          now_x = txt_x0;
          return;
      }
      if(*str_char == '\n')
      {
          now_y+=16;
          now_x = txt_x0;
          str_char++ ;
      }
      lcd_char(*str_char++);
  }
}

/*****************************************
 *The function name  lcd_int
 *Function   ʾͱֵ
 *Input   *int value
 *Output    none
 *Author    KeDei
 *Time    2015/4/21
 ****************************************/
void	Font::lcd_int(int value)
{
	itoa(value,buff,10); 
	lcd_string(buff);
}