/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

final class SettingsWindow
extends Window
implements ItemListener {
    private final JCheckBox playPauseBeatBox;
    private final JCheckBox startsWMouthBox;
    private final JCheckBox chooseCheckUpdate;

    private SettingsWindow() {
        JButton launchAbout = SettingsWindow.createButton("About Pac-Man", 65, true, this, "launchAbout");
        JButton checkUpdate = SettingsWindow.createButton("Check for Updates", 85, false, this, "update");
        JButton donate = SettingsWindow.createButton("Donate", 68, true, this, "donate");
        JLabel name = new JLabel("By Langdon Staab 2024");
        JLabel web = new JLabel("www.langdonstaab.ca");
        this.playPauseBeatBox = SettingsWindow.createCheckbox("Play Pause Beat", 80, Settings.playPauseBeat, this);
        this.startsWMouthBox = SettingsWindow.createCheckbox("Pac-Man starts as circle", 77, Settings.startsAsCircle, this);
        this.chooseCheckUpdate = SettingsWindow.createCheckbox("Check for Updates Automatically", 85, Settings.updateOnStart, this);
        JPanel checkPanel = new JPanel(new GridLayout(0, 1));
        checkPanel.add(name);
        checkPanel.add(web);
        checkPanel.add(this.playPauseBeatBox);
        checkPanel.add(this.startsWMouthBox);
        checkPanel.add(this.chooseCheckUpdate);
        checkPanel.add(launchAbout);
        checkPanel.add(checkUpdate);
        checkPanel.add(donate);
        this.add((Component)checkPanel, "Before");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Settings");
        frame.setDefaultCloseOperation(3);
        SettingsWindow newContentPane = new SettingsWindow();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    private static void createAndShowPopout() {
        JFrame frame = new JFrame("Settings");
        SettingsWindow newContentPane = new SettingsWindow();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    private static JCheckBox createCheckbox(String title, int key, boolean selectedByDefault, SettingsWindow SettingsWindow2) {
        JCheckBox checkBox = new JCheckBox(title);
        checkBox.setMnemonic(key);
        checkBox.setSelected(selectedByDefault);
        checkBox.addItemListener(SettingsWindow2);
        return checkBox;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(SettingsWindow::createAndShowGUI);
    }

    public static void create() {
        SwingUtilities.invokeLater(SettingsWindow::createAndShowPopout);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean newVal = false;
        ItemSelectable source = e.getItemSelectable();
        if (e.getStateChange() == 1) {
            newVal = true;
        }
        if (source == this.playPauseBeatBox) {
            Settings.playPauseBeat = newVal;
        } else if (source == this.startsWMouthBox) {
            Settings.startsAsCircle = newVal;
        } else if (source == this.chooseCheckUpdate) {
            Settings.updateOnStart = newVal;
        }
        Settings.save();
    }
}

