/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

final class UpdatePrompt
extends Window {
    private static JFrame frame;

    private UpdatePrompt() {
        JButton donate = UpdatePrompt.createButton("Donate", 68, true, this, "donate");
        JButton yes = UpdatePrompt.createButton("Yes", 89, true, this, "update");
        JButton no = UpdatePrompt.createButton("No", 78, true, this, "exit");
        JLabel name = new JLabel("By Langdon Staab 2024        www.langdonstaab.ca");
        JLabel web = new JLabel("");
        Color blue = new Color(8, 64, 255);
        yes.setBackground(blue);
        JLabel msg1 = new JLabel("A new version of Pac-Man has been released.");
        JLabel msg2 = new JLabel("Would you like to install it?");
        JLabel msg3 = new JLabel("");
        JLabel msg4 = new JLabel("Updates give you bug fixes, new features,");
        JLabel msg5 = new JLabel(" and performance improvements.");
        JPanel infoPanel = new JPanel(new GridLayout(0, 1));
        infoPanel.add(name);
        infoPanel.add(web);
        infoPanel.add(msg1);
        infoPanel.add(msg2);
        infoPanel.add(msg3);
        infoPanel.add(msg4);
        infoPanel.add(msg5);
        infoPanel.add(yes);
        infoPanel.add(no);
        infoPanel.add(donate);
        this.add((Component)infoPanel, "Before");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    private static void createAndShowGUI() {
        if (Settings.useOpenGL) {
            System.setProperty("sun.java2d.opengl", "True");
        }
        frame = new JFrame("Pac-Man AutoUpdate");
        frame.setDefaultCloseOperation(3);
        UpdatePrompt newContentPane = new UpdatePrompt();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    private static void createAndShowPopout() {
        frame = new JFrame("Pac-Man AutoUpdate");
        UpdatePrompt newContentPane = new UpdatePrompt();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        if (Settings.useOpenGL) {
            System.setProperty("sun.java2d.opengl", "True");
        }
        SwingUtilities.invokeLater(UpdatePrompt::createAndShowGUI);
    }

    public static void create() {
        if (Settings.useOpenGL) {
            System.setProperty("sun.java2d.opengl", "True");
        }
        SwingUtilities.invokeLater(UpdatePrompt::createAndShowPopout);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "update": {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.langdonstaab.ca/"));
                    break;
                }
                catch (IOException | URISyntaxException ex) {
                    Error.save(ex);
                    Error.log(ex);
                    throw new RuntimeException(ex);
                }
            }
            case "launchAbout": {
                AboutWindow.open();
                break;
            }
            case "donate": {
                try {
                    Desktop.getDesktop().browse(new URI("https://buymeacoff.ee/langdonstaab"));
                    break;
                }
                catch (IOException | URISyntaxException ex) {
                    Error.save(ex);
                    Error.log(ex);
                    throw new RuntimeException(ex);
                }
            }
            case "exit": {
                frame.dispose();
            }
        }
    }
}

