/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;

final class Settings {
    static final int ghostSpeed = 2;
    static final int pacmanSpeed = 3;
    static final float myVersion = 13.2f;
    static boolean startsAsCircle = true;
    static boolean showGhostWhenStopped = true;
    private static boolean debug = false;
    static String path;
    static boolean playPauseBeat;
    static boolean useClassicHitbox;
    static boolean useOpenGL;
    static boolean updateOnStart;
    static float newVersion;

    Settings() {
    }

    static void load() {
        path = System.getProperty("user.home");
        try {
            DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(path + "/dat")));
            debug = din.readBoolean();
            playPauseBeat = din.readBoolean();
            showGhostWhenStopped = din.readBoolean();
            startsAsCircle = din.readBoolean();
            useClassicHitbox = din.readBoolean();
            updateOnStart = din.readBoolean();
            useOpenGL = din.readBoolean();
        }
        catch (IOException e) {
            System.err.println("An Error occurred while loading.");
            Settings.save();
        }
    }

    static void save() {
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path + "/dat")));
            dos.writeBoolean(debug);
            dos.writeBoolean(playPauseBeat);
            dos.writeBoolean(showGhostWhenStopped);
            dos.writeBoolean(startsAsCircle);
            dos.writeBoolean(useClassicHitbox);
            dos.writeBoolean(updateOnStart);
            dos.writeBoolean(useOpenGL);
            dos.close();
        }
        catch (IOException ee) {
            System.err.println("An Error occurred while saving settings.");
            Error.save(ee);
            Error.log(ee);
        }
    }

    static void getNewVersion() {
        try {
            URI versionF = new URI("https://raw.githubusercontent.com/pacman-admin/pacmancode/newmaster/Pac-Man_VERSION.txt");
            BufferedReader in = new BufferedReader(new InputStreamReader(versionF.toURL().openStream()));
            newVersion = Float.parseFloat(in.readLine());
            in.close();
        }
        catch (IOException e) {
            System.err.println("IOException1!");
            Error.save(e);
            Error.log(e);
        }
        catch (URISyntaxException e) {
            System.err.println("URISyntaxException1!");
            Error.save(e);
            Error.log(e);
        }
    }

    static void updatePath() {
        path = System.getProperty("user.home");
    }

    static {
        playPauseBeat = true;
        useClassicHitbox = false;
        useOpenGL = true;
        updateOnStart = true;
        newVersion = 13.2f;
    }
}

