/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

final class Sound {
    private final Clip clip;

    public Sound(String filename) {
        try (InputStream in = this.getClass().getResourceAsStream(filename);){
            assert (in != null);
            BufferedInputStream bufferedIn = new BufferedInputStream(in);
            try (AudioInputStream audioIn = AudioSystem.getAudioInputStream(bufferedIn);){
                this.clip = AudioSystem.getClip();
                this.clip.open(audioIn);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException("Sound: Malformed URL: \n" + String.valueOf(e));
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException("Sound: Unsupported Audio File: \n" + String.valueOf(e));
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException("Sound: Input/Output Error: \n" + String.valueOf(e));
        }
        catch (LineUnavailableException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException("Sound: Line Unavailable Exception: \n" + String.valueOf(e));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException("Sound: Unspecified Error: \n" + String.valueOf(e));
        }
    }

    public void play() {
        this.clip.setFramePosition(0);
        this.clip.start();
    }

    public void loop() {
        this.clip.loop(-1);
    }

    public void stop() {
        this.clip.stop();
    }

    public boolean isPlaying() {
        return this.clip.getFrameLength() > this.clip.getFramePosition();
    }

    public void rewind() {
        this.clip.setFramePosition(0);
    }
}

