/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

abstract class Window
extends JPanel
implements ActionListener {
    Window() {
        super(new BorderLayout());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Error.save(ex);
            Error.log(ex);
        }
        if (Settings.path == null) {
            Settings.updatePath();
        }
        if (Settings.path.equals("null")) {
            Settings.updatePath();
        }
    }

    static JButton createButton(String title, int key, boolean enabled, Window window, String command) {
        JButton button = new JButton(title);
        button.setMnemonic(key);
        button.setEnabled(enabled);
        button.setActionCommand(command);
        button.addActionListener(window);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "update": {
                Settings.getNewVersion();
                if (!(Settings.newVersion > 13.2f)) break;
                UpdatePrompt.create();
                break;
            }
            case "launchAbout": {
                AboutWindow.open();
                break;
            }
            case "donate": {
                try {
                    Desktop.getDesktop().browse(new URI("https://buymeacoff.ee/langdonstaab"));
                    break;
                }
                catch (IOException | URISyntaxException ex) {
                    Error.save(ex);
                    Error.log(ex);
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

