/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;

public final class pac_man
extends PApplet {
    private static final String TITLE = "Pac-Man 13.2";
    private static final int CELLWIDTH = 32;
    private static final int HALF_CELLWIDTH = 16;
    private static final int pelletWorth = 10;
    private static final int CANVAS_WIDTH = 416;
    private static final int CANVAS_HEIGHT = 416;
    private static final Fruit[] FRUIT_POINTS = new Fruit[]{Fruit.CHERRY, Fruit.STRAWBERRY, Fruit.ORANGE, Fruit.ORANGE, Fruit.APPLE, Fruit.APPLE, Fruit.MELON, Fruit.MELON, Fruit.GALAXIAN, Fruit.GALAXIAN, Fruit.BELL, Fruit.BELL, Fruit.KEY, Fruit.KEY};
    private static final boolean[][] MAP_DESIGN = new boolean[][]{{true, false, true, true, true, true, true, true, true, true, true}, {true, true, true, false, false, false, false, false, false, false, true}, {true, false, true, true, true, true, true, true, true, false, true}, {true, false, true, false, false, false, false, false, true, false, true}, {true, true, true, true, true, true, true, true, true, true, true}, {true, false, true, false, true, false, false, true, false, true, true}, {true, false, true, false, true, false, true, true, false, true, true}, {true, false, true, true, true, true, false, true, false, false, true}, {true, false, false, false, true, false, false, true, false, true, true}, {true, true, true, true, true, true, false, true, false, true, true}, {true, true, false, false, false, true, true, true, false, true, true}};
    static String errorInfo;
    static int prevHighScore;
    private final ArrayList<String> messages = new ArrayList();
    private final Ghost blinky = new Ghost();
    private final Ghost inky = new Ghost();
    private final Ghost pinky = new Ghost();
    private final Pacman pacman = new Pacman();
    private final Cell[][] cells = new Cell[][]{new Cell[13], new Cell[13], new Cell[13], new Cell[13], new Cell[13], new Cell[13], new Cell[13], new Cell[13], new Cell[13], new Cell[13], new Cell[13], new Cell[13], new Cell[13]};
    private final Pellet[] pellet = new Pellet[78];
    private final PImage[] blinky_Up = new PImage[]{null, null};
    private final PImage[] blinky_Down = new PImage[]{null, null};
    private final PImage[] blinky_Left = new PImage[]{null, null};
    private final PImage[] blinky_Right = new PImage[]{null, null};
    private final PImage[] pinky_Up = new PImage[]{null, null};
    private final PImage[] pinky_Down = new PImage[]{null, null};
    private final PImage[] pinky_Left = new PImage[]{null, null};
    private final PImage[] pinky_Right = new PImage[]{null, null};
    private final PImage[] inky_Up = new PImage[]{null, null};
    private final PImage[] inky_Down = new PImage[]{null, null};
    private final PImage[] inky_Left = new PImage[]{null, null};
    private final PImage[] inky_Right = new PImage[]{null, null};
    private final boolean[] keys = new boolean[1000];
    private PFont pxFont;
    private PImage maze_blue;
    private PImage maze_white;
    private int lives = 3;
    private int chompSpeed = 8;
    private boolean playStartSound = true;
    private boolean finishedDelay;
    private boolean first1 = true;
    private boolean lostLife;
    private boolean paused;
    private boolean pelletFirst;
    private boolean runSetup = true;
    private int startMillis;
    private int chomp = 30;
    private int duration;
    private int durationStart;
    private int fruitWorth;
    private int highScore;
    private int level;
    private int livesClaimed;
    private int pelletsEaten;
    private int score;
    private int startFrames;
    private int coordsX;
    private int coordsY;
    private PImage cherry;
    private PImage strawberry;
    private PImage apple;
    private PImage orange;
    private PImage melon;
    private PImage galaxian;
    private PImage bell;
    private PImage keyI;
    private PImage restartB;
    private PImage settingsB;
    private Sound dieS;
    private Sound startSound;
    private Sound dotSound1;
    private Sound dotSound2;
    private Sound fruit;
    private Sound extra_life;
    private Sound pause;
    private Sound pause_beat;
    private PImage pauseButtonImg;

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"pac_man"};
        if (passedArgs != null) {
            PApplet.main(pac_man.concat(appletArgs, passedArgs));
        } else {
            PApplet.main(appletArgs);
        }
    }

    private static boolean hitBoxCollision(int cellX, int cellY, float objectX, float objectY) {
        return objectX > (float)cellX && objectX < (float)(cellX + 32) && objectY > (float)cellY && objectY < (float)(cellY + 32);
    }

    private static double fastDist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    @Override
    public void settings() {
        this.size(416, 416);
    }

    @Override
    public void setup() {
        this.surface.setTitle("Loading...");
        System.out.println("Please wait...");
        this.background(0);
        this.noStroke();
        this.textSize(16.0f);
        this.textAlign(3, 3);
        this.fill(255);
        this.text("Loading...\nBy Langdon Staab\nwww.langdonstaab.ca", 208.0f, 208.0f);
    }

    private void setup2() {
        this.changeAppIcon();
        new LoadingThread();
        this.frameRate(120.0f);
        System.out.println("Loading Game Assets...");
        this.startSound = new Sound("game_start.wav");
        this.dotSound1 = new Sound("dot_1.wav");
        this.dotSound2 = new Sound("dot_2.wav");
        this.pause = new Sound("pause.wav");
        this.pause_beat = new Sound("pause_beat.wav");
        this.dieS = new Sound("death.wav");
        this.fruit = new Sound("fruit.wav");
        this.extra_life = new Sound("extra_life.wav");
        this.cherry = this.loadImage("cherry.png");
        this.settingsB = this.loadImage("settings.png");
        this.restartB = this.loadImage("restart.png");
        this.strawberry = this.loadImage("strawberry.png");
        this.pxFont = this.createFont("minecraft-seven-classic/minecraft-seven-classic.ttf", 8.0f, false);
        this.pauseButtonImg = this.loadImage("pause_button.png");
        this.blinky_Down[0] = this.loadImage("ghost/blinky/down.png");
        this.blinky_Down[1] = this.loadImage("ghost/blinky/down2.png");
        this.blinky_Up[0] = this.loadImage("ghost/blinky/up.png");
        this.blinky_Up[1] = this.loadImage("ghost/blinky/up2.png");
        this.blinky_Left[0] = this.loadImage("ghost/blinky/left.png");
        this.blinky_Left[1] = this.loadImage("ghost/blinky/left2.png");
        this.blinky_Right[0] = this.loadImage("ghost/blinky/right.png");
        this.blinky_Right[1] = this.loadImage("ghost/blinky/right2.png");
        this.inky_Down[0] = this.loadImage("ghost/inky/down.png");
        this.inky_Down[1] = this.loadImage("ghost/inky/down2.png");
        this.inky_Up[0] = this.loadImage("ghost/inky/up.png");
        this.inky_Up[1] = this.loadImage("ghost/inky/up2.png");
        this.inky_Left[0] = this.loadImage("ghost/inky/left.png");
        this.inky_Left[1] = this.loadImage("ghost/inky/left2.png");
        this.inky_Right[0] = this.loadImage("ghost/inky/right.png");
        this.inky_Right[1] = this.loadImage("ghost/inky/right2.png");
        this.pinky_Down[0] = this.loadImage("ghost/pinky/down.png");
        this.pinky_Down[1] = this.loadImage("ghost/pinky/down2.png");
        this.pinky_Up[0] = this.loadImage("ghost/pinky/up.png");
        this.pinky_Up[1] = this.loadImage("ghost/pinky/up2.png");
        this.pinky_Left[0] = this.loadImage("ghost/pinky/left.png");
        this.pinky_Left[1] = this.loadImage("ghost/pinky/left2.png");
        this.pinky_Right[0] = this.loadImage("ghost/pinky/right.png");
        this.pinky_Right[1] = this.loadImage("ghost/pinky/right2.png");
        this.maze_blue = this.loadImage("maze_blue.png");
        this.maze_white = this.loadImage("maze_white.png");
        System.out.println("Initializing...");
        this.createMaze();
        this.surface.setResizable(true);
        this.imageMode(3);
        this.textFont(this.pxFont);
        this.pellet[5].isFruit = true;
        this.surface.setTitle(TITLE);
        System.out.println("Loading Complete!");
    }

    @Override
    public void draw() {
        if (!this.paused) {
            try {
                if (this.runSetup) {
                    this.setup2();
                    this.durationStart = this.millis();
                    this.startMillis = this.millis();
                    this.runSetup = false;
                    this.startFrames = this.frameCount;
                    this.duration = 4500 + this.durationStart;
                    System.out.println(this.millis());
                } else if (this.lives <= 0) {
                    this.background(0);
                    this.fill(255.0f, 0.0f, 0.0f);
                    this.text("GAME OVER", 208.0f, 208.0f);
                    this.text("Click the screen to play again", 208.0f, 248.0f);
                    this.text("By Langdon Staab\nwww.langdonstaab.ca", 208.0f, 288.0f);
                    if (this.mousePressed) {
                        this.restart();
                        this.messages.clear();
                    }
                } else if (this.millis() > 2000 && this.frameCount % 2 == 0) {
                    if (this.millis() < this.duration) {
                        this.pacman.stop();
                        this.pacman.stopped = true;
                        this.finishedDelay = false;
                        this.blinky.halt();
                        this.inky.halt();
                        this.pinky.halt();
                    } else if (!this.finishedDelay) {
                        this.blinky.up();
                        this.inky.up();
                        this.pinky.up();
                        this.finishedDelay = true;
                        this.messages.clear();
                    }
                    this.destroyUselessMessages();
                    if (this.lostLife) {
                        if (this.chomp < 60) {
                            ++this.chomp;
                        }
                        if (this.first1) {
                            this.dieS.play();
                            this.first1 = false;
                            System.gc();
                        }
                        this.pacman.stop();
                        this.blinky.halt();
                        this.inky.halt();
                        this.pinky.halt();
                        if (this.dieS.isPlaying()) {
                            this.chomp += 3;
                        } else {
                            --this.lives;
                            this.blinky.newGame();
                            this.inky.newGame();
                            this.pinky.newGame();
                            this.pacman.x = 48.0f;
                            this.pacman.y = 48.0f;
                            this.first1 = true;
                            this.lostLife = false;
                            this.chomp = 16;
                            this.duration = 2000 + this.millis();
                            this.pacman.stop();
                            this.pacman.stopped = true;
                        }
                    }
                    if (!this.pacman.dir.equals((Object)Dir.STOPPED)) {
                        if (this.chomp > 96) {
                            this.chompSpeed = -this.chompSpeed;
                        }
                        if (this.chomp < 8) {
                            this.chompSpeed = -this.chompSpeed;
                        }
                        this.chomp += this.chompSpeed;
                    }
                    if (this.pelletsEaten < this.pellet.length - 1 && !this.lostLife) {
                        this.pacman.update();
                    }
                    this.blinky.update();
                    this.inky.update();
                    this.pinky.update();
                    this.updateKeys();
                    this.image(this.maze_blue, 208.0f, 208.0f);
                    if (this.pelletsEaten >= this.pellet.length - 1) {
                        this.blinky.halt();
                        this.inky.halt();
                        this.pinky.halt();
                        this.pacman.stop();
                        if (this.millis() - this.durationStart < 250 || this.millis() - this.durationStart < 750 && this.millis() - this.durationStart > 500 || this.millis() - this.durationStart < 1250 && this.millis() - this.durationStart > 1000 || this.millis() - this.durationStart < 1750 && this.millis() - this.durationStart > 1500) {
                            this.image(this.maze_white, 208.0f, 208.0f);
                        }
                        if (this.millis() - this.durationStart >= 2000) {
                            this.pacman.update();
                            this.blinky.up();
                            this.inky.up();
                            this.pinky.up();
                            this.pacman.stopped = true;
                            this.pacman.stop();
                            this.playStartSound = false;
                        }
                    }
                    this.display();
                }
            }
            catch (Exception e) {
                this.paused = true;
                Error.save(e);
                Error.log(e);
            }
        }
    }

    private void display() throws FileNotFoundException {
        this.drawButtons();
        this.showLives();
        this.fill(255.0f, 128.0f, 0.0f);
        for (Pellet value : this.pellet) {
            value.isBEaten();
            value.draw();
        }
        this.drawGhosts();
        this.fill(255);
        float tempFPSVal = Math.max((float)(this.millis() - this.startMillis) / 1000.0f, 1.0f);
        this.text("FPS: " + Math.round((float)(this.frameCount - this.startFrames) / tempFPSVal), 330.0f, 10.0f);
        this.text("HIGH SCORE\n" + this.highScore, 208.0f, 16.0f);
        this.displayMessages();
        this.pacman.show(this.chomp);
    }

    @Override
    public void keyPressed() {
        try {
            this.keys[this.keyCode] = true;
        }
        catch (Exception e) {
            this.messages.clear();
            this.messages.add("Your keyboard may contain keys beyond the standard.");
            this.messages.add("You can probably ignore the error message and popup.");
            Error.log(e);
            Error.save(e);
        }
    }

    @Override
    public void keyReleased() {
        this.keys[this.keyCode] = false;
    }

    private void updateKeys() {
        if (this.keys[37]) {
            this.pacman.left();
        }
        if (this.keys[39]) {
            this.pacman.right();
        }
        if (this.keys[38]) {
            this.pacman.up();
        }
        if (this.keys[40]) {
            this.pacman.down();
        }
        if (this.keys[65]) {
            this.pacman.left();
        }
        if (this.keys[68]) {
            this.pacman.right();
        }
        if (this.keys[87]) {
            this.pacman.up();
        }
        if (this.keys[83]) {
            this.pacman.down();
        }
    }

    private Dir createRDir(int posX, int posY) {
        int tempVar = Math.round(this.random(3.0f));
        Dir possDir = this.makeDir(tempVar);
        while (this.checkGoodDir(possDir, posX, posY)) {
            tempVar = this.makeDirNum();
            possDir = this.makeDir(tempVar);
        }
        return possDir;
    }

    private void changeAppIcon() {
        this.getSurface().setIcon(this.loadImage("icon.png"));
    }

    private void displayMessages() {
        this.fill(0.0f, 255.0f, 50.0f);
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            this.text(this.messages.get(i), 64.0f, (float)(8 + i * 16));
        }
    }

    private void addLife() {
        ++this.lives;
        ++this.livesClaimed;
        this.extra_life.play();
        this.messages.add("Claimed extra life!");
    }

    private void giveLives() {
        if (this.score >= 1000 && this.livesClaimed < 1) {
            this.addLife();
        } else if (this.score >= 2000 && this.livesClaimed < 2) {
            this.addLife();
        } else if (this.score >= 5000 && this.livesClaimed < 3) {
            this.addLife();
        } else if (this.score >= 10000 && this.livesClaimed < 4) {
            this.addLife();
        } else if (this.score >= 20000 && this.livesClaimed < 5) {
            this.addLife();
        } else if (this.score >= 50000 && this.livesClaimed < 6) {
            this.addLife();
        } else if (this.score >= 100000 && this.livesClaimed < 7) {
            this.addLife();
        } else if (this.score >= 200000 && this.livesClaimed < 8) {
            this.addLife();
        } else if (this.score >= 500000 && this.livesClaimed < 9) {
            this.addLife();
        } else if (this.score >= 1000000 && this.livesClaimed < 10) {
            this.addLife();
        }
    }

    private int createPosition(boolean dirIsX) {
        if (dirIsX) {
            return (int)this.random(3.0f, 12.0f) * 32 + 16;
        }
        return (int)this.random(1.0f, 12.0f) * 32 + 16;
    }

    private boolean checkGoodDir(Dir dir, int posX, int posY) {
        boolean goodDir = true;
        switch (dir) {
            case UP: {
                if (posY - 1 < 0) break;
                goodDir = this.cells[posX][posY - 1].open;
                break;
            }
            case DOWN: {
                if (posY + 1 > this.height / 32) break;
                goodDir = this.cells[posX][posY + 1].open;
                break;
            }
            case RIGHT: {
                if (posX + 1 > this.width / 32) break;
                goodDir = this.cells[posX + 1][posY].open;
                break;
            }
            case LEFT: {
                if (posX - 1 < 0) break;
                goodDir = this.cells[posX - 1][posY].open;
            }
        }
        return !goodDir;
    }

    private Dir makeDir(int Var) {
        return switch (Var) {
            case 0 -> Dir.UP;
            case 1 -> Dir.DOWN;
            case 2 -> Dir.RIGHT;
            case 3 -> Dir.LEFT;
            default -> Dir.STOPPED;
        };
    }

    private int makeDirNum() {
        float tempDirNum = this.random(-0.1f, 4.0f);
        int dirNum = pac_man.floor(tempDirNum);
        dirNum = pac_man.constrain(dirNum, 0, 3);
        return dirNum;
    }

    private void createMaze() {
        int cellCount = 0;
        for (int i = 0; i < MAP_DESIGN[1].length + 2; ++i) {
            for (int j = 0; j < MAP_DESIGN[1].length + 2; ++j) {
                if (i > 0 && j > 0 && i <= MAP_DESIGN[1].length && j <= MAP_DESIGN[1].length) {
                    this.cells[j][i] = new Cell(MAP_DESIGN[i - 1][j - 1]);
                    if (!MAP_DESIGN[i - 1][j - 1] || j <= 1 && i <= 1) continue;
                    this.pellet[cellCount] = new Pellet(j * 32 + 16, i * 32 + 16);
                    ++cellCount;
                    continue;
                }
                this.cells[j][i] = new Cell(false);
            }
        }
    }

    private void destroyUselessMessages() {
        while (this.messages.size() > 6) {
            this.messages.removeFirst();
        }
        if (this.millis() % 25 == 0 && this.millis() - this.startMillis > 500 && !this.messages.isEmpty()) {
            this.messages.removeFirst();
        }
        if (this.messages.size() > 4) {
            this.messages.removeFirst();
        }
    }

    private void showLives() {
        this.fill(255.0f, 202.0f, 0.0f);
        for (int x = 1; x < this.lives; ++x) {
            this.arc(25 * x, 400.0f, 20.0f, 20.0f, 0.13866667f, 6.1436696f);
        }
    }

    private void increaseHighScore() throws FileNotFoundException {
        if (prevHighScore > this.highScore) {
            this.highScore = prevHighScore;
        }
        if (this.score > this.highScore) {
            this.highScore = this.score;
        }
        if (this.highScore > prevHighScore) {
            PrintWriter out = new PrintWriter(Settings.path + "/highscore.txt");
            out.println(pac_man.str(this.highScore));
            out.close();
        }
    }

    private void restart() {
        this.messages.clear();
        this.blinky.newGame();
        this.inky.newGame();
        this.pinky.newGame();
        this.lives = 3;
        this.lostLife = false;
        this.level = 0;
        this.playStartSound = true;
        this.pelletsEaten = 0;
        this.pacman.update();
        this.pacman.x = 48.0f;
        this.pacman.y = 48.0f;
        this.score = 0;
        this.determineFruitType();
        for (Pellet value : this.pellet) {
            value.update();
        }
        this.durationStart = this.millis();
        this.duration = 4500 + this.millis();
    }

    private void restartButton() {
        int x = 128;
        int y = 384;
        if (pac_man.hitBoxCollision(x, y, this.mouseX, this.mouseY)) {
            this.restart();
        }
    }

    private void pauseButton() {
        int x = 160;
        int y = 384;
        if (pac_man.hitBoxCollision(x, y, this.mouseX, this.mouseY)) {
            if (this.paused) {
                this.pause_beat.stop();
            } else {
                this.pause.play();
                if (Settings.playPauseBeat) {
                    this.pause_beat.rewind();
                    this.pause_beat.loop();
                }
            }
            this.paused = !this.paused;
        }
    }

    private void pauseBeatOffButton() {
        int x = 96;
        int y = 384;
        if (pac_man.hitBoxCollision(x, y, this.mouseX, this.mouseY)) {
            SettingsWindow.create();
        }
    }

    private void drawButtons() {
        this.image(this.settingsB, 112.0f, 400.0f);
        this.image(this.restartB, 144.0f, 400.0f);
        this.image(this.pauseButtonImg, 176.0f, 400.0f);
    }

    private void determineFruitType() {
        if (this.level == 1) {
            new LazySpriteLoader();
        }
        this.pellet[5].fruitType = this.level < FRUIT_POINTS.length ? FRUIT_POINTS[this.level] : FRUIT_POINTS[FRUIT_POINTS.length - 1];
    }

    @Override
    public void mouseClicked() {
        this.pauseBeatOffButton();
        this.restartButton();
        this.pauseButton();
    }

    private void drawGhosts() {
        if (!this.blinky.dir.equals((Object)Dir.STOPPED) || Settings.showGhostWhenStopped) {
            if ((this.frameCount - this.startFrames) % 100 < 45) {
                switch (this.blinky.dir) {
                    case UP: {
                        this.image(this.blinky_Up[0], this.blinky.x, this.blinky.y);
                        break;
                    }
                    case DOWN: {
                        this.image(this.blinky_Down[0], this.blinky.x, this.blinky.y);
                        break;
                    }
                    case RIGHT: {
                        this.image(this.blinky_Right[0], this.blinky.x, this.blinky.y);
                        break;
                    }
                    case LEFT: {
                        this.image(this.blinky_Left[0], this.blinky.x, this.blinky.y);
                    }
                }
            } else {
                switch (this.blinky.dir) {
                    case UP: {
                        this.image(this.blinky_Up[1], this.blinky.x, this.blinky.y);
                        break;
                    }
                    case DOWN: {
                        this.image(this.blinky_Down[1], this.blinky.x, this.blinky.y);
                        break;
                    }
                    case RIGHT: {
                        this.image(this.blinky_Right[1], this.blinky.x, this.blinky.y);
                        break;
                    }
                    case LEFT: {
                        this.image(this.blinky_Left[1], this.blinky.x, this.blinky.y);
                    }
                }
            }
        }
        if (!this.inky.dir.equals((Object)Dir.STOPPED) || Settings.showGhostWhenStopped) {
            if ((this.frameCount - this.startFrames) % 100 < 45) {
                switch (this.inky.dir) {
                    case UP: {
                        this.image(this.inky_Up[0], this.inky.x, this.inky.y);
                        break;
                    }
                    case DOWN: {
                        this.image(this.inky_Down[0], this.inky.x, this.inky.y);
                        break;
                    }
                    case RIGHT: {
                        this.image(this.inky_Right[0], this.inky.x, this.inky.y);
                        break;
                    }
                    case LEFT: {
                        this.image(this.inky_Left[0], this.inky.x, this.inky.y);
                    }
                }
            } else {
                switch (this.inky.dir) {
                    case UP: {
                        this.image(this.inky_Up[1], this.inky.x, this.inky.y);
                        break;
                    }
                    case DOWN: {
                        this.image(this.inky_Down[1], this.inky.x, this.inky.y);
                        break;
                    }
                    case RIGHT: {
                        this.image(this.inky_Right[1], this.inky.x, this.inky.y);
                        break;
                    }
                    case LEFT: {
                        this.image(this.inky_Left[1], this.inky.x, this.inky.y);
                    }
                }
            }
        }
        if (!this.pinky.dir.equals((Object)Dir.STOPPED) || Settings.showGhostWhenStopped) {
            if ((this.frameCount - this.startFrames) % 100 < 45) {
                switch (this.pinky.dir) {
                    case UP: {
                        this.image(this.pinky_Up[0], this.pinky.x, this.pinky.y);
                        break;
                    }
                    case DOWN: {
                        this.image(this.pinky_Down[0], this.pinky.x, this.pinky.y);
                        break;
                    }
                    case RIGHT: {
                        this.image(this.pinky_Right[0], this.pinky.x, this.pinky.y);
                        break;
                    }
                    case LEFT: {
                        this.image(this.pinky_Left[0], this.pinky.x, this.pinky.y);
                    }
                }
            } else {
                switch (this.pinky.dir) {
                    case UP: {
                        this.image(this.pinky_Up[1], this.pinky.x, this.pinky.y);
                        break;
                    }
                    case DOWN: {
                        this.image(this.pinky_Down[1], this.pinky.x, this.pinky.y);
                        break;
                    }
                    case RIGHT: {
                        this.image(this.pinky_Right[1], this.pinky.x, this.pinky.y);
                        break;
                    }
                    case LEFT: {
                        this.image(this.pinky_Left[1], this.pinky.x, this.pinky.y);
                    }
                }
            }
        }
    }

    static {
        prevHighScore = 0;
    }

    private final class Ghost {
        private int coordsX;
        private int coordsY;
        private int x;
        private int y;
        private Dir dir;

        private Ghost() {
            this.x = pac_man.this.createPosition(true);
            this.y = pac_man.this.createPosition(false);
            this.dir = Dir.UP;
        }

        private void updateCoords() {
            float a = 3.0f;
            float b = 1.0f;
            float offsetY = 0.0f;
            float offsetX = 0.0f;
            switch (this.dir) {
                case UP: {
                    offsetY += 11.666667f;
                    break;
                }
                case DOWN: {
                    offsetY -= 11.666667f;
                    break;
                }
                case RIGHT: {
                    offsetX -= 11.666667f;
                    break;
                }
                case LEFT: {
                    offsetX += 11.666667f;
                }
            }
            this.coordsX = Math.round(((float)this.x + offsetX) / 32.0f + 0.5f) - 1;
            this.coordsY = Math.round(((float)this.y + offsetY) / 32.0f + 0.5f) - 1;
        }

        private void update() {
            this.updateCoords();
            switch (this.dir) {
                case UP: {
                    if (this.coordsY - 1 >= 0 && pac_man.this.cells[this.coordsX][this.coordsY - 1].open) {
                        this.x = this.coordsX * 32 + 16;
                        this.y -= 2;
                        break;
                    }
                    this.dir = pac_man.this.createRDir(this.coordsX, this.coordsY);
                    break;
                }
                case DOWN: {
                    if (this.coordsY + 1 <= pac_man.this.height / 32 && pac_man.this.cells[this.coordsX][this.coordsY + 1].open) {
                        this.x = this.coordsX * 32 + 16;
                        this.y += 2;
                        break;
                    }
                    this.dir = pac_man.this.createRDir(this.coordsX, this.coordsY);
                    break;
                }
                case RIGHT: {
                    if (this.coordsX + 1 <= pac_man.this.width / 32 && pac_man.this.cells[this.coordsX + 1][this.coordsY].open) {
                        this.y = this.coordsY * 32 + 16;
                        this.x += 2;
                        break;
                    }
                    this.dir = pac_man.this.createRDir(this.coordsX, this.coordsY);
                    break;
                }
                case LEFT: {
                    if (this.coordsX - 1 >= 0 && pac_man.this.cells[this.coordsX - 1][this.coordsY].open) {
                        this.y = this.coordsY * 32 + 16;
                        this.x -= 2;
                        break;
                    }
                    this.dir = pac_man.this.createRDir(this.coordsX, this.coordsY);
                }
            }
            if (pac_man.fastDist(this.x, this.y, pac_man.this.pacman.x, pac_man.this.pacman.y) < 16.0 && this.x >= 64) {
                pac_man.this.lostLife = true;
            }
        }

        private void up() {
            this.dir = Dir.UP;
        }

        private void halt() {
            this.dir = Dir.STOPPED;
        }

        private void newGame() {
            this.x = pac_man.this.createPosition(true);
            this.y = pac_man.this.createPosition(false);
            this.updateCoords();
            while (!pac_man.this.cells[this.coordsX][this.coordsY].open || this.x > 384 || this.x < 32 || this.y > 384 || this.y < 32) {
                this.x = pac_man.this.createPosition(true);
                this.y = pac_man.this.createPosition(false);
                pac_man.this.messages.add("Adjustment in Progress...");
                this.updateCoords();
            }
        }
    }

    final class Pacman {
        static final float size = 30.0f;
        float x = 48.0f;
        float y = 48.0f;
        private boolean stopped = true;
        private Dir nextDir = Dir.STOPPED;
        private Dir dir = Dir.STOPPED;
        private Dir lastDir = Dir.STOPPED;

        Pacman() {
        }

        private void show(int mouthSize) {
            if (this.stopped && Settings.startsAsCircle) {
                mouthSize = 0;
                if (pac_man.this.playStartSound) {
                    pac_man.this.startSound.play();
                    pac_man.this.playStartSound = false;
                }
            }
            float mouthOpenTop = PApplet.map(mouthSize, 0.0f, 60.0f, 0.0f, 0.52f);
            float mouthOpenBottom = PApplet.map(mouthSize, 0.0f, 60.0f, (float)Math.PI * 2, 5.76f);
            pac_man.this.fill(255.0f, 255.0f, 0.0f);
            pac_man.this.translate(this.x, this.y);
            switch (this.lastDir) {
                case UP: {
                    pac_man.this.rotate(4.712389f);
                    break;
                }
                case DOWN: {
                    pac_man.this.rotate(1.5707964f);
                    break;
                }
                case LEFT: {
                    pac_man.this.rotate((float)Math.PI);
                }
            }
            pac_man.this.arc(0.0f, 0.0f, 30.0f, 30.0f, mouthOpenTop, mouthOpenBottom);
        }

        private void update() {
            if (Settings.useClassicHitbox) {
                float offsetX = 0.2f;
                float offsetY = 0.1f;
                float a = 3.0f;
                float b = 1.0f;
                switch (this.dir) {
                    case UP: {
                        offsetY += 32.0f / a + b;
                        break;
                    }
                    case DOWN: {
                        offsetY -= 32.0f / a + b;
                        break;
                    }
                    case RIGHT: {
                        offsetX -= 32.0f / a + b;
                        break;
                    }
                    case LEFT: {
                        offsetX += 32.0f / a + b;
                    }
                }
                pac_man.this.coordsX = PApplet.round((this.x + offsetX) / 32.0f + 0.5f) - 1;
                pac_man.this.coordsY = PApplet.round((this.y + offsetY) / 32.0f + 0.5f) - 1;
            } else {
                pac_man.this.coordsX = Math.round(this.x / 32.0f + 0.5f) - 1;
                pac_man.this.coordsY = Math.round(this.y / 32.0f + 0.5f) - 1;
            }
            if (pac_man.this.pelletsEaten >= pac_man.this.pellet.length - 1) {
                for (Pellet value : pac_man.this.pellet) {
                    value.update();
                }
                pac_man.this.coordsX = 1;
                pac_man.this.coordsY = 1;
                this.x = 48.0f;
                this.y = 48.0f;
                this.dir = Dir.STOPPED;
                this.nextDir = Dir.STOPPED;
                pac_man.this.pelletsEaten = 0;
            }
            switch (this.nextDir) {
                case UP: {
                    if (!pac_man.this.cells[pac_man.this.coordsX][pac_man.this.coordsY - 1].open) break;
                    this.dir = this.nextDir;
                    this.x = pac_man.this.coordsX * 32 + 16;
                    break;
                }
                case DOWN: {
                    if (!pac_man.this.cells[pac_man.this.coordsX][pac_man.this.coordsY + 1].open) break;
                    this.dir = this.nextDir;
                    this.x = pac_man.this.coordsX * 32 + 16;
                    break;
                }
                case RIGHT: {
                    if (!pac_man.this.cells[pac_man.this.coordsX + 1][pac_man.this.coordsY].open) break;
                    this.dir = this.nextDir;
                    this.y = pac_man.this.coordsY * 32 + 16;
                    break;
                }
                case LEFT: {
                    if (!pac_man.this.cells[pac_man.this.coordsX - 1][pac_man.this.coordsY].open) break;
                    this.dir = this.nextDir;
                    this.y = pac_man.this.coordsY * 32 + 16;
                }
            }
            if (Settings.useClassicHitbox) {
                switch (this.dir) {
                    case UP: {
                        if (pac_man.this.cells[PApplet.parseInt((float)((float)pac_man.this.coordsX))][PApplet.parseInt((float)((float)pac_man.this.coordsY)) - 1].open) {
                            this.y -= 3.0f;
                            this.stopped = false;
                            if (this.x < (float)(pac_man.this.coordsX * 32 + 16)) {
                                this.x += 1.0f;
                            }
                            if (this.x > (float)(pac_man.this.coordsX * 32 + 16)) {
                                this.x -= 1.0f;
                            }
                            this.lastDir = Dir.UP;
                            break;
                        }
                        this.dir = this.nextDir;
                        this.nextDir = Dir.STOPPED;
                        break;
                    }
                    case DOWN: {
                        if (pac_man.this.cells[PApplet.parseInt((float)((float)pac_man.this.coordsX))][PApplet.parseInt((float)((float)pac_man.this.coordsY)) + 1].open) {
                            this.y += 3.0f;
                            this.stopped = false;
                            if (this.x < (float)(pac_man.this.coordsX * 32 + 16)) {
                                this.x += 1.0f;
                            }
                            if (this.x > (float)(pac_man.this.coordsX * 32 + 16)) {
                                this.x -= 1.0f;
                            }
                            this.lastDir = Dir.DOWN;
                            break;
                        }
                        this.dir = this.nextDir;
                        this.nextDir = Dir.STOPPED;
                        break;
                    }
                    case RIGHT: {
                        if (pac_man.this.cells[PApplet.parseInt((float)((float)pac_man.this.coordsX)) + 1][PApplet.parseInt((float)((float)pac_man.this.coordsY))].open) {
                            this.x += 3.0f;
                            this.stopped = false;
                            if (this.y < (float)(pac_man.this.coordsY * 32 + 16)) {
                                this.y += 1.0f;
                            }
                            if (this.y > (float)(pac_man.this.coordsY * 32 + 16)) {
                                this.y -= 1.0f;
                            }
                            this.lastDir = Dir.RIGHT;
                            break;
                        }
                        this.dir = this.nextDir;
                        this.nextDir = Dir.STOPPED;
                        break;
                    }
                    case LEFT: {
                        if (pac_man.this.cells[PApplet.parseInt((float)((float)pac_man.this.coordsX)) - 1][PApplet.parseInt((float)((float)pac_man.this.coordsY))].open) {
                            this.x -= 3.0f;
                            this.stopped = false;
                            if (this.y < (float)(pac_man.this.coordsY * 32 + 16)) {
                                this.y += 1.0f;
                            }
                            if (this.y > (float)(pac_man.this.coordsY * 32 + 16)) {
                                this.y -= 1.0f;
                            }
                            this.lastDir = Dir.LEFT;
                            break;
                        }
                        this.dir = this.nextDir;
                        this.nextDir = Dir.STOPPED;
                        break;
                    }
                    case STOPPED: {
                        if (this.x < (float)(pac_man.this.coordsX * 32 + 16)) {
                            this.x += 1.0f;
                        }
                        if (this.x > (float)(pac_man.this.coordsX * 32 + 16)) {
                            this.x -= 1.0f;
                        }
                        if (this.y < (float)(pac_man.this.coordsY * 32 + 16)) {
                            this.y += 1.0f;
                        }
                        if (!(this.y > (float)(pac_man.this.coordsY * 32 + 16))) break;
                        this.y -= 1.0f;
                    }
                }
            } else {
                int stopBuffer = 2;
                switch (this.dir) {
                    case UP: {
                        if (pac_man.this.cells[pac_man.this.coordsX][pac_man.this.coordsY - 1].open) {
                            this.y -= 3.0f;
                            this.stopped = false;
                            if (this.x < (float)(pac_man.this.coordsX * 32 + 16)) {
                                this.x += 3.0f;
                            }
                            if (this.x > (float)(pac_man.this.coordsX * 32 + 16)) {
                                this.x -= 3.0f;
                            }
                            this.lastDir = Dir.UP;
                            break;
                        }
                        if (this.y <= (float)(pac_man.this.coordsY * 32 + 16 + stopBuffer)) {
                            this.dir = this.nextDir;
                            this.nextDir = Dir.STOPPED;
                            break;
                        }
                        this.y -= 3.0f;
                        break;
                    }
                    case DOWN: {
                        if (pac_man.this.cells[pac_man.this.coordsX][pac_man.this.coordsY + 1].open) {
                            this.y += 3.0f;
                            this.stopped = false;
                            if (this.x < (float)(pac_man.this.coordsX * 32 + 16)) {
                                this.x += 3.0f;
                            }
                            if (this.x > (float)(pac_man.this.coordsX * 32 + 16)) {
                                this.x -= 3.0f;
                            }
                            this.lastDir = Dir.DOWN;
                            break;
                        }
                        if (this.y >= (float)(pac_man.this.coordsY * 32 + 16 - stopBuffer)) {
                            this.dir = this.nextDir;
                            this.nextDir = Dir.STOPPED;
                            break;
                        }
                        this.y += 3.0f;
                        break;
                    }
                    case RIGHT: {
                        if (pac_man.this.cells[pac_man.this.coordsX + 1][pac_man.this.coordsY].open) {
                            this.x += 3.0f;
                            this.stopped = false;
                            if (this.y < (float)(pac_man.this.coordsY * 32 + 16)) {
                                this.y += 3.0f;
                            }
                            if (this.y > (float)(pac_man.this.coordsY * 32 + 16)) {
                                this.y -= 3.0f;
                            }
                            this.lastDir = Dir.RIGHT;
                            break;
                        }
                        if (this.x >= (float)(pac_man.this.coordsX * 32 + 16 - stopBuffer)) {
                            this.dir = this.nextDir;
                            this.nextDir = Dir.STOPPED;
                            break;
                        }
                        this.x += 3.0f;
                        break;
                    }
                    case LEFT: {
                        if (pac_man.this.cells[pac_man.this.coordsX - 1][pac_man.this.coordsY].open) {
                            this.x -= 3.0f;
                            this.stopped = false;
                            if (this.y < (float)(pac_man.this.coordsY * 32 + 16)) {
                                this.y += 3.0f;
                            }
                            if (this.y > (float)(pac_man.this.coordsY * 32 + 16)) {
                                this.y -= 3.0f;
                            }
                            this.lastDir = Dir.LEFT;
                            break;
                        }
                        if (this.x <= (float)(pac_man.this.coordsX * 32 + 16 + stopBuffer)) {
                            this.dir = this.nextDir;
                            this.nextDir = Dir.STOPPED;
                            break;
                        }
                        this.x -= 3.0f;
                        break;
                    }
                    case STOPPED: {
                        if (this.x < (float)(pac_man.this.coordsX * 32 + 16)) {
                            this.x += 3.0f;
                        }
                        if (this.x > (float)(pac_man.this.coordsX * 32 + 16)) {
                            this.x -= 3.0f;
                        }
                        if (this.y < (float)(pac_man.this.coordsY * 32 + 16)) {
                            this.y += 3.0f;
                        }
                        if (!(this.y > (float)(pac_man.this.coordsY * 32 + 16))) break;
                        this.y -= 3.0f;
                    }
                }
            }
            if (this.x > 400.0f) {
                this.x = 47.0f;
            }
            if (this.y > 400.0f) {
                this.y = 47.0f;
            }
            pac_man.this.coordsX = Math.round(this.x / 32.0f + 0.5f) - 1;
            pac_man.this.coordsY = Math.round(this.y / 32.0f + 0.5f) - 1;
        }

        private void up() {
            pac_man.this.coordsX = Math.round(this.x / 32.0f + 0.5f) - 1;
            pac_man.this.coordsY = Math.round(this.y / 32.0f + 0.5f) - 1;
            if (pac_man.this.cells[pac_man.this.coordsX][pac_man.this.coordsY - 1].open) {
                this.dir = Dir.UP;
                this.nextDir = Dir.UP;
                if (this.x < (float)(pac_man.this.coordsX * 32 + 16)) {
                    this.x += 3.0f;
                }
                if (this.x > (float)(pac_man.this.coordsX * 32 + 16)) {
                    this.x -= 3.0f;
                }
            } else {
                this.nextDir = Dir.UP;
            }
        }

        private void down() {
            pac_man.this.coordsX = Math.round(this.x / 32.0f + 0.5f) - 1;
            pac_man.this.coordsY = Math.round(this.y / 32.0f + 0.5f) - 1;
            if (pac_man.this.cells[pac_man.this.coordsX][pac_man.this.coordsY + 1].open) {
                this.dir = Dir.DOWN;
                this.nextDir = Dir.DOWN;
                if (this.x < (float)(pac_man.this.coordsX * 32 + 16)) {
                    this.x += 3.0f;
                }
                if (this.x > (float)(pac_man.this.coordsX * 32 + 16)) {
                    this.x -= 3.0f;
                }
            } else {
                this.nextDir = Dir.DOWN;
            }
        }

        private void right() {
            pac_man.this.coordsX = Math.round(this.x / 32.0f + 0.5f) - 1;
            pac_man.this.coordsY = Math.round(this.y / 32.0f + 0.5f) - 1;
            if (pac_man.this.cells[pac_man.this.coordsX + 1][pac_man.this.coordsY].open) {
                this.dir = Dir.RIGHT;
                this.nextDir = Dir.RIGHT;
                if (this.y < (float)(pac_man.this.coordsY * 32 + 16)) {
                    this.y += 3.0f;
                }
                if (this.y > (float)(pac_man.this.coordsY * 32 + 16)) {
                    this.y -= 3.0f;
                }
            } else {
                this.nextDir = Dir.RIGHT;
            }
        }

        private void left() {
            pac_man.this.coordsX = Math.round(this.x / 32.0f + 0.5f) - 1;
            pac_man.this.coordsY = Math.round(this.y / 32.0f + 0.5f) - 1;
            if (pac_man.this.cells[pac_man.this.coordsX - 1][pac_man.this.coordsY].open) {
                this.dir = Dir.LEFT;
                this.nextDir = Dir.LEFT;
                if (this.y < (float)(pac_man.this.coordsY * 32 + 16)) {
                    this.y += 3.0f;
                }
                if (this.y > (float)(pac_man.this.coordsY * 32 + 16)) {
                    this.y -= 3.0f;
                }
            } else {
                this.nextDir = Dir.LEFT;
            }
        }

        private void stop() {
            this.dir = Dir.STOPPED;
            this.stopped = false;
            this.nextDir = Dir.STOPPED;
        }
    }

    final class Pellet {
        private final int x;
        private final int y;
        private boolean eaten = false;
        private boolean isFruit = false;
        private Fruit fruitType = Fruit.CHERRY;

        private Pellet(int x1, int y1) {
            this.x = x1;
            this.y = y1;
        }

        void update() {
            this.eaten = false;
            if (this.isFruit) {
                pac_man.this.fruitWorth = 100;
            }
        }

        private void isBEaten() throws FileNotFoundException {
            if (!this.eaten && pac_man.fastDist(this.x, this.y, pac_man.this.pacman.x, pac_man.this.pacman.y) < 7.75) {
                if (this.isFruit) {
                    switch (this.fruitType) {
                        case CHERRY: {
                            pac_man.this.fruitWorth = 100;
                            break;
                        }
                        case STRAWBERRY: {
                            pac_man.this.fruitWorth = 300;
                            break;
                        }
                        case ORANGE: {
                            pac_man.this.fruitWorth = 500;
                            break;
                        }
                        case APPLE: {
                            pac_man.this.fruitWorth = 700;
                            break;
                        }
                        case MELON: {
                            pac_man.this.fruitWorth = 1000;
                            break;
                        }
                        case GALAXIAN: {
                            pac_man.this.fruitWorth = 2000;
                            break;
                        }
                        case BELL: {
                            pac_man.this.fruitWorth = 3000;
                            break;
                        }
                        case KEY: {
                            pac_man.this.fruitWorth = 5000;
                        }
                    }
                    pac_man.this.score += pac_man.this.fruitWorth;
                    pac_man.this.fruit.play();
                } else {
                    if (!pac_man.this.pelletFirst) {
                        pac_man.this.dotSound2.play();
                        pac_man.this.pelletFirst = true;
                    } else {
                        pac_man.this.dotSound1.play();
                        pac_man.this.pelletFirst = false;
                    }
                    pac_man.this.score += 10;
                    ++pac_man.this.pelletsEaten;
                }
                this.eaten = true;
                pac_man.this.giveLives();
                pac_man.this.messages.add("Your score is:" + PApplet.str(pac_man.this.score));
                pac_man.this.increaseHighScore();
                if (pac_man.this.pelletsEaten >= pac_man.this.pellet.length - 1 && !pac_man.this.lostLife) {
                    ++pac_man.this.level;
                    pac_man.this.determineFruitType();
                    pac_man.this.durationStart = pac_man.this.millis();
                    pac_man.this.duration = 2000 + pac_man.this.millis();
                    System.gc();
                }
            }
        }

        private void draw() {
            if (!this.eaten) {
                if (this.isFruit) {
                    switch (this.fruitType) {
                        case STRAWBERRY: {
                            pac_man.this.image(pac_man.this.strawberry, this.x, this.y);
                            break;
                        }
                        case ORANGE: {
                            pac_man.this.image(pac_man.this.orange, this.x, this.y);
                            break;
                        }
                        case APPLE: {
                            pac_man.this.image(pac_man.this.apple, this.x, this.y);
                            break;
                        }
                        case MELON: {
                            pac_man.this.image(pac_man.this.melon, this.x, this.y);
                            break;
                        }
                        case GALAXIAN: {
                            pac_man.this.image(pac_man.this.galaxian, this.x, this.y);
                            break;
                        }
                        case BELL: {
                            pac_man.this.image(pac_man.this.bell, this.x, this.y);
                            break;
                        }
                        case KEY: {
                            pac_man.this.image(pac_man.this.keyI, this.x, this.y);
                            break;
                        }
                        default: {
                            pac_man.this.image(pac_man.this.cherry, this.x, this.y);
                            break;
                        }
                    }
                } else {
                    pac_man.this.ellipse(this.x, this.y, 16.0f, 16.0f);
                }
            }
        }
    }

    private final class LazySpriteLoader
    extends Thread {
        LazySpriteLoader() {
            this.start();
        }

        @Override
        public void run() {
            pac_man.this.messages.add("Loading more fruit sprites...");
            pac_man.this.orange = pac_man.this.loadImage("orange.png");
            pac_man.this.apple = pac_man.this.loadImage("apple.png");
            pac_man.this.melon = pac_man.this.loadImage("melon.png");
            pac_man.this.galaxian = pac_man.this.loadImage("galaxian.png");
            pac_man.this.bell = pac_man.this.loadImage("bell.png");
            pac_man.this.keyI = pac_man.this.loadImage("key.png");
            pac_man.this.messages.add("All fruit sprites loaded successfully.");
        }
    }
}

