# -*- coding: utf-8 -*-

import re
import json
import time
import urlparse
import requests
import pickle
import sys
import urllib
import resolveurl as urlresolver
import xbmc
import xbmcgui
import xbmcaddon
import xbmcplugin
from bs4 import BeautifulSoup
from urlparse import parse_qsl
from datetime import date, datetime

YOUR_API_KEY = "AIzaSyBaBjcr1jYE5Eoqni-xpWwGYv3XkfgSNFE"
BLOG_ID = "7403402541563312508"

headers = {
    'Accept-Encoding': 'gzip, deflate',
    'Accept-Language': 'en-US',
    'X-Requested-With': 'blogger.com',
    'Connection': 'keep-alive',
    'Accept': 'application/json, text/plain, */*',
    'User-Agent': 'Mozilla/5.0 (Linux; U; Android 8.0.0; Nexus 5X Build/OPP3.170518.006) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/39.0.0.0 Safari/537.36 EmbeddedBrowser TVPSportMobileApp'
}

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.meczreplay')
resources = xbmc.translatePath(addon.getAddonInfo('path') + '/resources/')

_addon = xbmcaddon.Addon()
_icon = _addon.getAddonInfo('icon')


def build_url(query):
    return base_url + '?' + urllib.urlencode(query)


def build_page_url(BLOG_ID, YOUR_API_KEY, pageToken):
    pageCount = '6'
    if pageToken == "":
        return "https://www.googleapis.com/blogger/v3/blogs/" + BLOG_ID + "/posts?key=" + YOUR_API_KEY + '&maxResults=' + pageCount
    else:
        return "https://www.googleapis.com/blogger/v3/blogs/" + BLOG_ID + "/posts?key=" + YOUR_API_KEY + "&pageToken=" + pageToken + '&maxResults=' + pageCount


def get_item(BLOG_ID, YOUR_API_KEY, pageToken):
    links = []

    streams = requests.get(build_page_url(BLOG_ID, YOUR_API_KEY, pageToken),
                           headers=headers,
                           verify=False
                           ).json()
    if 'nextPageToken' in streams:
        nextPageToken = streams["nextPageToken"]
    else:
        nextPageToken = ""

    items = streams['items']
    for item in items:
        soup = BeautifulSoup(item["content"], "html.parser")
        title = str(soup.strong).replace(
            '</strong>', '').replace('<strong>', '')
        image = soup.a['href']

        soup.findAll("div", {"class": "stylelistrow"})
        data = str(soup).replace('<div class=\"separator\" style=\"clear: both; text-align: center;\">',
                                 '').replace('</div>', '').replace('\n',
                                                                   '').replace('<div dir=\"ltr\" style=\"text-align: left;\" trbidi=\"on\">', '')
        table = filter(None, re.split('<br/>|<b>|</b>|<br>|\n', str(data)))

        for line in table:
            if "blogspot.com" not in line:
                try:
                    name = line.split('<a href="')[0].replace(':', '')
                    link = line.split('<a href="')[1].split('"')[0]
                    links.append({"title": title, "image": image,
                                  "name": name, "link": link})
                except:
                    pass
    return links, nextPageToken


def resolve_url(url):
    duration = 7500
    message = "Cannot Play URL"
    stream_url = urlresolver.HostedMediaFile(url=url).resolve()
    if not stream_url:
        dialog = xbmcgui.Dialog()
        dialog.notification("URL Resolver Error", message,
                            xbmcgui.NOTIFICATION_INFO, duration)
        return False
    else:
        return stream_url


def play_video(path):
    play_item = xbmcgui.ListItem(path=path)
    vid_url = play_item.getfilename()
    stream_url = resolve_url(vid_url)
    if stream_url:
        play_item.setPath(stream_url)
    xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)


def home():
    data, nextPageToken = get_item(BLOG_ID, YOUR_API_KEY, "")
    for i in data:
        video_play_url = i['link']
        print(video_play_url)
        url = build_url({'mode': 'play', 'playlink': video_play_url})
        li = xbmcgui.ListItem(
            i['title'] + " " + i['name'], iconImage=i['image'])
        li.setProperty('IsPlayable', 'true')
        xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li)
    list_item = xbmcgui.ListItem('NASTĘPNA STRONA  >>')
    list_item.setProperty("IsPlayable", 'False')
    image = resources + 'transparent.png'
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image})
    xbmcplugin.addDirectoryItem(
        handle=addon_handle,
        url=build_url({'mode': 'next_page', 'nextPageToken': nextPageToken}),
        listitem=list_item,
        isFolder=True)

    xbmcplugin.endOfDirectory(addon_handle)


def next_page():
    prevPageToken = params.get('nextPageToken', '0')
    data, nextPageToken = get_item(BLOG_ID, YOUR_API_KEY, prevPageToken)
    for i in data:
        video_play_url = i['link']
        print(video_play_url)
        url = build_url({'mode': 'play', 'playlink': video_play_url})

        li = xbmcgui.ListItem(
            i['title'] + " " + i['name'], iconImage=i['image'])
        li.setProperty('IsPlayable', 'true')
        xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li)

    if nextPageToken != '':
        list_item = xbmcgui.ListItem('NASTĘPNA STRONA  >>')
        list_item.setProperty("IsPlayable", 'False')
        image = resources + 'transparent.png'
        list_item.setArt({'thumb': image, 'poster': image, 'banner': image})
        xbmcplugin.addDirectoryItem(
            handle=addon_handle,
            url=build_url(
                {'mode': 'next_page', 'nextPageToken': nextPageToken}),
            listitem=list_item,
            isFolder=True)

    xbmcplugin.endOfDirectory(addon_handle)


if __name__ == '__main__':
    mode = params.get('mode', None)
    if not mode:
        home()
    elif mode == 'next_page':
        next_page()
    elif mode == 'play':
        play_video(params['playlink'])
