######################################################################
# Author: Info2-Team
# MatNr: 012345678
# Description: Reference solution
# Comments: -
######################################################################

from .sensor import Sensor


class City:
    possible_colors = ['red', 'blue', 'gray', 'darkred', 'lightred', 'orange',
                       'beige', 'green', 'darkgreen', 'lightgreen', 'darkblue',
                       'lightblue', 'purple', 'darkpurple', 'pink', 'cadetblue',
                       'lightgray', 'black']

    def __init__(self, name, coords, population, country, colorcode):
        self._name = name
        self._coords = coords
        self._population = population
        self._country = country
        self.colorcode = colorcode
        self._sensors = []

    @property
    def name(self):
        return self._name

    @property
    def coords(self):
        return self._coords

    @property
    def population(self):
        return self._population

    @property
    def country(self):
        return self._country

    @property
    def sensors(self):
        return self._sensors

    @property
    def colorcode(self):
        return self._colorcode

    @colorcode.setter
    def colorcode(self, colorcode):
        if not colorcode in self.possible_colors:
            raise TypeError(f"colorcode needs to be a string, the following are possible: {self.possible_colors}")

        self._colorcode = colorcode

    def add_sensor(self, new_sensor):
        if not isinstance(new_sensor, Sensor):
            raise TypeError("New sensor needs to be of class Sensor")
        self._sensors.append(new_sensor)
