######################################################################
# Author: Info2-Team
# MatNr: 012345678
# Description: Reference solution
# Comments: -
######################################################################

from sensormap import read_cities, parse_sensors, create_map

city_list = read_cities("worldcities.csv", countries=["germany", "austria"])

parse_sensors("sensors_ass_2_small.csv", city_list)
for city in city_list:
    if city.sensors:
        print(f"{city.name}: {len(city.sensors)}")


create_map(city_list, "map_info.html")

cities_stuttgart_graz = [city for city in city_list if city.name in ("Stuttgart", "Graz")]
create_map(cities_stuttgart_graz, "map_plots.html", plot_sensor_values=True, smooth="15d")
