######################################################################
# Author: Info2-Team
# MatNr: 012345678
# Description: Reference solution
# Comments: -
######################################################################

from math import acos, cos, radians, sin


class Coordinates:
    def __init__(self, lat, lon):
        self.lat = lat
        self.lon = lon

    @property
    def lat(self):
        return self._lat

    @lat.setter
    def lat(self, lat):
        try:
            lat = float(lat)
        except:
            raise TypeError(f"Latitude has to be convertible to float, is {type(lat)} with value {lat}!")
        if not -90 < lat < 90:
            raise ValueError(f"Latitude has to be between -90° and 90°!, is {lat}")
        self._lat = lat

    @property
    def lon(self):
        return self._lon

    @lon.setter
    def lon(self, lon):
        try:
            lon = float(lon)
        except:
            raise TypeError(f"Longitude has to be convertible to float, is {type(lon)} with value {lon}!")
        if not -180 < lon < 180:
            raise ValueError(f"Longitude has to be between -180° and 180°!, is {lon}")
        self._lon = lon

    @classmethod
    def distance(cls, coord_1, coord_2):
        lat_1, lon_1, lat_2, lon_2 = (radians(x) for x in [coord_1.lat, coord_1.lon, coord_2.lat, coord_2.lon])
        return 6371 * acos(sin(lat_1) * sin(lat_2) + cos(lat_1) * cos(lat_2) * cos(lon_2 - lon_1))
