// Import Dragon Service Worker Logging
importScripts('./lib/logging/service-worker.bundle.js');

// Import Tatkal Proxy Background Module
importScripts('./src/popup/modules/proxy-background.js');

// Initialize logger for the background script
const logger = self.DragonServiceWorkerLogging.createLogger(
    'background-service-worker',
    true
);

// Log service worker startup
logger.info('🚀 Extension Tatkal Background Service Worker started', {
    timestamp: new Date().toISOString(),
    version: '1.6.9',
});

// Initialize the modular proxy background handler
const proxyHandler =
    self.TatkalProxyBackground.initializeProxyBackground(logger);
self.TatkalProxyBackground.setupProxyAuthListener();

// PROXY LOGIC START - NOW USING MODULAR SYSTEM
// Proxy functions are now handled by the TatkalProxyBackground module
// This maintains compatibility while using the new modular architecture

function applyProxySettings() {
    // Delegate to the modular proxy background handler
    return self.TatkalProxyBackground.applyProxySettings();
}

async function testProxyConnectivity(proxy) {
    // Delegate to the modular proxy background handler
    return await self.TatkalProxyBackground.testProxyConnectivity(proxy);
}

// Apply proxy on startup
logger.info('🔄 Applying proxy settings on startup using modular system');
applyProxySettings();
// PROXY LOGIC END
let tabDetails;
let status_updates = {};
function getMsg(_0x233f19, _0x25d1fa) {
    return {
        msg: {
            type: _0x233f19,
            data: _0x25d1fa,
        },
        sender: 'popup',
        id: 'irctc',
    };
}
chrome.runtime.onMessage.addListener((_0x5ba10a, _0x150c1a, _0x159d56) => {
    // Handle the new proxy check message
    if (_0x5ba10a.action === 'checkProxyConnectivity') {
        logger.info('🌐 Received proxy connectivity check request', {
            proxyHost: `${_0x5ba10a.proxy.ip}:${_0x5ba10a.proxy.port}`,
        });
        testProxyConnectivity(_0x5ba10a.proxy).then(result => {
            _0x159d56(result); // Send back success/failure message
        });
        return true; // Indicates that the response will be sent asynchronously
    }
    if (_0x5ba10a.action === 'updateProxy') {
        logger.info('🔄 Received proxy update request');
        applyProxySettings();
        _0x159d56({
            status: 'Proxy settings updated.',
        });
        return true;
    }

    // Handle modular proxy test message from proxy-manager
    if (_0x5ba10a.id === 'irctc' && _0x5ba10a.msg?.type === 'test_proxy') {
        logger.info('🧪 Received modular proxy test request', {
            proxyConfig: _0x5ba10a.msg.data,
        });

        const testId = 'test_' + Date.now();

        // Convert proxy config format for compatibility
        const proxyForTest = {
            ip: _0x5ba10a.msg.data.proxyIp,
            port: _0x5ba10a.msg.data.proxyPort,
            user: _0x5ba10a.msg.data.proxyUsername,
            pass: _0x5ba10a.msg.data.proxyPassword,
        };

        // Start async test and store results
        self.TatkalProxyBackground.testProxyConnectivity(proxyForTest)
            .then(result => {
                chrome.storage.local.set({
                    [testId]: {
                        status: 'completed',
                        result: result,
                    },
                });
                logger.info('✅ Proxy test completed and stored', {
                    testId,
                    success: result.success,
                });
            })
            .catch(error => {
                chrome.storage.local.set({
                    [testId]: {
                        status: 'completed',
                        result: {
                            success: false,
                            message: error.message,
                        },
                    },
                });
                logger.error('❌ Proxy test failed and stored', {
                    testId,
                    error: error.message,
                });
            });

        // Return test ID immediately for polling
        _0x159d56({ testId });
        return true;
    }

    if ('irctc' !== _0x5ba10a.id) {
        _0x159d56('Invalid Id');
        return true;
    }
    let _0x60722f = _0x5ba10a.msg.type;
    let _0x5740ae = _0x5ba10a.msg.data;
    if ('activate_script' === _0x60722f) {
        if (_0x5740ae.fare_limit?.['bookInPopup']) {
            chrome.windows.create(
                {
                    url: 'https://www.irctc.co.in/nget/train-search',
                    type: 'popup',
                    width: 0x200,
                    height: 0x338,
                },
                _0x2b778a => {
                    if (chrome.runtime.lastError) {
                        console.error(
                            '[background_script.js] Error creating window:',
                            chrome.runtime.lastError.message
                        );
                        _0x159d56(
                            'Error creating window: ' +
                                chrome.runtime.lastError.message
                        );
                        return;
                    }
                    if (
                        _0x2b778a &&
                        _0x2b778a.tabs &&
                        _0x2b778a.tabs.length > 0x0
                    ) {
                        tabDetails = _0x2b778a.tabs[0x0];
                        chrome.scripting.executeScript(
                            {
                                target: {
                                    tabId: tabDetails.id,
                                },
                                files: [
                                    'lib/logging/index.bundle.js',
                                    'lib/ocr/index.bundle.js',
                                    'src/content/modules/booking-timer.js',
                                    'src/content/modules/congratulation-handler.js',
                                    './content_script.js',
                                ],
                            },
                            () => {
                                if (chrome.runtime.lastError) {
                                    console.error(
                                        '[background_script.2A42.js] Error injecting script into window:',
                                        chrome.runtime.lastError.message
                                    );
                                    _0x159d56(
                                        'Error injecting script: ' +
                                            chrome.runtime.lastError.message
                                    );
                                } else {
                                    console.log(
                                        '[background_script.js] Script activated in new window, tab ID:',
                                        tabDetails.id
                                    );
                                    _0x159d56('Script activated in new window');
                                }
                            }
                        );
                    } else {
                        console.error(
                            '[background_script.js] Failed to create popup window or get its tab details.'
                        );
                        _0x159d56('Failed to activate script in popup window.');
                    }
                }
            );
        } else {
            chrome.tabs.create(
                {
                    url: 'https://www.irctc.co.in/nget/train-search',
                },
                _0x3504da => {
                    if (chrome.runtime.lastError) {
                        console.error(
                            '[background_script.js] Error creating tab:',
                            chrome.runtime.lastError.message
                        );
                        _0x159d56(
                            'Error creating tab: ' +
                                chrome.runtime.lastError.message
                        );
                        return;
                    }
                    tabDetails = _0x3504da;
                    chrome.scripting.executeScript(
                        {
                            target: {
                                tabId: tabDetails.id,
                            },
                            files: [
                                'lib/logging/index.bundle.js',
                                'lib/ocr/index.bundle.js',
                                'src/content/modules/booking-timer.js',
                                'src/content/modules/congratulation-handler.js',
                                './content_script.js',
                            ],
                        },
                        () => {
                            if (chrome.runtime.lastError) {
                                console.error(
                                    '[background_script.js] Error injecting script into tab:',
                                    chrome.runtime.lastError.message
                                );
                                _0x159d56(
                                    'Error injecting script: ' +
                                        chrome.runtime.lastError.message
                                );
                            } else {
                                console.log(
                                    '[background_script.js] Script activated in new tab, tab ID:',
                                    tabDetails.id
                                );
                                _0x159d56('Script activated in new tab');
                            }
                        }
                    );
                }
            );
        }
        return true;
    } else {
        if ('status_update' === _0x60722f) {
            const _0x974a5 = _0x150c1a.tab?.['id'] || 'popup_or_unknown';
            status_updates[_0x974a5] = status_updates[_0x974a5] || [];
            status_updates[_0x974a5].push({
                sender: _0x150c1a,
                data: _0x5740ae,
            });
            _0x159d56('Status received');
        } else {
            _0x159d56('Something went wrong with message type');
        }
    }
    return true;
});
chrome.tabs.onUpdated.addListener((_0x3394e1, _0x50c397, _0x3e5349) => {
    if (_0x50c397?.['status'] !== 'complete' || !_0x3e5349.url) {
        return;
    }
    const _0x323f74 = _0x3e5349.url;
    let _0x569a18 = null;
    let _0x4e4a95 = null;
    let _0x30d261 = false;
    if (tabDetails && _0x3394e1 === tabDetails.id) {
        _0x4e4a95 = tabDetails.id;
        console.log(
            '[background_script.js] Main tab (' +
                _0x4e4a95 +
                ') updated: ' +
                _0x323f74
        );
        if (_0x323f74.includes('booking/train-list')) {
            _0x569a18 = 'selectJourney';
            _0x30d261 = true;
        } else {
            if (_0x323f74.includes('booking/psgninput')) {
                _0x569a18 = 'fillPassengerDetails';
                _0x30d261 = true;
            } else {
                if (_0x323f74.includes('booking/reviewBooking')) {
                    _0x569a18 = 'reviewBooking';
                    _0x30d261 = true;
                } else if (_0x323f74.includes('payment/bkgPaymentOptions')) {
                    console.log(
                        '[background_script.js] Payment options page detected on main tab by URL:',
                        _0x323f74
                    );
                    _0x569a18 = 'bkgPaymentOptions';
                    _0x30d261 = true;
                }
            }
        }
    }
    if (_0x30d261 && _0x569a18 && _0x4e4a95) {
        console.log(
            '[background_script.js] Sending (main flow) ' +
                _0x569a18 +
                ' to tab ' +
                _0x4e4a95 +
                ' for URL: ' +
                _0x323f74
        );
        chrome.tabs
            .sendMessage(_0x4e4a95, {
                msg: {
                    type: _0x569a18,
                    data: null,
                },
                sender: 'popup',
                id: 'irctc',
            })
            .then(_0xa686a9 =>
                console.log(
                    '[background_script.js] (Main flow) ' +
                        _0x569a18 +
                        ' message acknowledged by tab ' +
                        _0x4e4a95 +
                        ':',
                    _0xa686a9
                )
            )
            ['catch'](_0x4eceb3 =>
                console.warn(
                    '[background_script.js] (Main flow) Error sending ' +
                        _0x569a18 +
                        ' to tab ' +
                        _0x4e4a95 +
                        ':',
                    _0x4eceb3.message
                )
            );
    }
    if (
        _0x323f74.startsWith('https://www.irctc.co.in/') &&
        (_0x323f74.includes('booking/train-ticket') ||
            _0x323f74.includes('eticket') ||
            _0x323f74.includes('booking-confirm'))
    ) {
        console.log(
            '[background_script.js] PNR page detected on tab ' +
                _0x3394e1 +
                ': ' +
                _0x323f74 +
                '.'
        );
        chrome.scripting.executeScript(
            {
                target: {
                    tabId: _0x3394e1,
                },
                files: [
                    'lib/logging/index.bundle.js',
                    'lib/ocr/index.bundle.js',
                    'src/content/modules/booking-timer.js',
                    'src/content/modules/congratulation-handler.js',
                    './content_script.js',
                ],
            },
            _0x2aff61 => {
                if (chrome.runtime.lastError) {
                    console.warn(
                        '[background_script.js] executeScript on PNR tab ' +
                            _0x3394e1 +
                            ' had an issue (might be ok if already injected): ' +
                            chrome.runtime.lastError.message
                    );
                } else {
                    console.log(
                        '[background_script.js] Content script ensured on PNR tab ' +
                            _0x3394e1 +
                            '.'
                    );
                }
                setTimeout(() => {
                    console.log(
                        '[background_script.js] Sending showPnrAnimation to tab ' +
                            _0x3394e1
                    );
                    chrome.tabs
                        .sendMessage(_0x3394e1, {
                            msg: {
                                type: 'showPnrAnimation',
                                data: null,
                            },
                            sender: 'popup',
                            id: 'irctc',
                        })
                        .then(_0x218a6d =>
                            console.log(
                                '[background_script.js] showPnrAnimation message acknowledged by tab ' +
                                    _0x3394e1 +
                                    ':',
                                _0x218a6d
                            )
                        )
                        ['catch'](_0x2654b4 =>
                            console.warn(
                                '[background_script.js] Error sending showPnrAnimation to tab ' +
                                    _0x3394e1 +
                                    ' (content script might not be listening, or tab closed):',
                                _0x2654b4.message
                            )
                        );
                }, 0xfa);
            }
        );
    }
});
