// Initialize Dragon Logger for HDFC payment handler
const hdfcLogger = window.DragonLogging
    ? window.DragonLogging.createLogger({
          component: 'hdfc-payment-handler',
          level: 'debug',
          enableStorage: true,
          environment: 'development',
      })
    : {
          info: console.log,
          debug: console.log,
          warn: console.warn,
          error: console.error,
      };

// Log HDFC payment handler initialization
hdfcLogger.info('💳 HDFC Payment Handler initialized', {
    timestamp: new Date().toISOString(),
    url: window.location.href,
    domain: window.location.hostname,
});

let user_data = {};
GetVpa();
let intervalID = '';
let intervalID1 = '';
function addDelay(_0x5d79e9) {
    const _0x4f88d0 = Date.now();
    let _0x7dd21f = null;
    do {
        _0x7dd21f = Date.now();
    } while (_0x7dd21f - _0x4f88d0 < _0x5d79e9);
}
function hdfcPgHandler() {
    hdfcLogger.info('🏦 Starting HDFC payment gateway handler');

    intervalID = setInterval(function () {
        if (!IsInPrograss()) {
            hdfcLogger.debug(
                '✅ HDFC bank page loaded, proceeding with automation'
            );
            console.log('HDFC bank startt');
        }
    }, 0xc8);
    intervalID1 = setInterval(function () {
        if (!IsInPrograss1()) {
            hdfcLogger.info('📝 Starting form data filling process');
            console.log('Fill data start');

            const _0x53d42d = document.getElementById('card_no');
            if (_0x53d42d && user_data.other_preferences?.cardnumber) {
                _0x53d42d.value = user_data.other_preferences.cardnumber;
                _0x53d42d.dispatchEvent(new Event('input'));
                _0x53d42d.dispatchEvent(new Event('change'));
                hdfcLogger.debug('💳 Card number filled');
            }

            const _0x3d9ef1 = document.getElementById('name');
            if (_0x3d9ef1 && user_data.other_preferences?.cardholder) {
                _0x3d9ef1.value = user_data.other_preferences.cardholder;
                _0x3d9ef1.dispatchEvent(new Event('input'));
                _0x3d9ef1.dispatchEvent(new Event('change'));
                hdfcLogger.debug('👤 Cardholder name filled');
            }

            const _0x4287d1 = document.getElementById('other_debit_cvv_no');
            if (_0x4287d1 && user_data.other_preferences?.cardcvv) {
                _0x4287d1.value = user_data.other_preferences.cardcvv;
                _0x4287d1.dispatchEvent(new Event('input'));
                _0x4287d1.dispatchEvent(new Event('change'));
                hdfcLogger.debug('🔒 CVV filled');
            }

            if (user_data.other_preferences?.cardexpiry) {
                const expiryParts =
                    user_data.other_preferences.cardexpiry.split('/');
                hdfcLogger.debug('📅 Processing card expiry', {
                    expMonth: expiryParts[0],
                    expYear: expiryParts[1],
                });

                console.log(
                    'exp Month',
                    user_data.other_preferences.cardexpiry.split('/')[0x0]
                );
                console.log(
                    'exp Year',
                    user_data.other_preferences.cardexpiry.split('/')[0x1]
                );

                const _0x217ee7 = document.getElementById('expMonthSelect');
                if (_0x217ee7) {
                    _0x217ee7.value = Number(expiryParts[0]);
                    _0x217ee7.dispatchEvent(new Event('input'));
                    _0x217ee7.dispatchEvent(new Event('change'));
                    hdfcLogger.debug('📅 Expiry month set');
                }

                const _0x5e4a63 = document.getElementById('expYearSelect');
                if (_0x5e4a63) {
                    _0x5e4a63.value = '20' + expiryParts[1];
                    _0x5e4a63.dispatchEvent(new Event('input'));
                    _0x5e4a63.dispatchEvent(new Event('change'));
                    hdfcLogger.debug('📅 Expiry year set');
                }
            }

            hdfcLogger.info('🔍 Starting CAPTCHA processing');
            getCaptcha();
            console.log('END');
        }
    }, 0xc8);
}
function IsInPrograss() {
    hdfcLogger.debug('⏳ Waiting for HDFC payment page to load');
    console.log('wait for page');

    const paymentModeElements = document.querySelectorAll('.payment_mode');
    if (paymentModeElements[0]) {
        paymentModeElements[0].click();
        hdfcLogger.debug('💳 Payment mode selected');
    }

    addDelay(0xc8);

    const otherDebitElements = document.querySelectorAll('#other_debit');
    if (otherDebitElements[0]) {
        otherDebitElements[0].click();
        hdfcLogger.debug('💳 Other debit option selected');
    }

    const captchaDiv = document.getElementById('captchaDiv');
    if (captchaDiv && captchaDiv.style.display != 'none') {
        hdfcLogger.info('✅ HDFC payment page loaded successfully');
        console.log('Page loaded.');
        clearInterval(intervalID);
        return false;
    }
    return true;
}
function IsInPrograss1() {
    hdfcLogger.debug('⏳ Waiting for CAPTCHA page to load');
    console.log('wait for captcha page');

    const captchaDiv = document.getElementById('captchaDiv');
    if (captchaDiv && captchaDiv.style.display != 'none') {
        hdfcLogger.info('✅ CAPTCHA page loaded successfully');
        console.log('captcha Page loaded.');
        clearInterval(intervalID1);
        return false;
    }
    return true;
}
function GetVpa() {
    const _0xbdae61 = (function () {
        let _0x1bb3fd = true;
        return function (_0x475a58, _0x190041) {
            const _0x31d1a3 = _0x1bb3fd
                ? function () {
                      if (_0x190041) {
                          const _0x4afe91 = _0x190041.apply(
                              _0x475a58,
                              arguments
                          );
                          _0x190041 = null;
                          return _0x4afe91;
                      }
                  }
                : function () {};
            _0x1bb3fd = false;
            return _0x31d1a3;
        };
    })();
    const _0x2eb13f = _0xbdae61(this, function () {
        let _0x362827;
        try {
            const _0x3bfe8b = Function(
                'return (function() {}.constructor("return this")( ));'
            );
            _0x362827 = _0x3bfe8b();
        } catch (_0x33b7d2) {
            _0x362827 = window;
        }
        const _0x13689a = (_0x362827.console = _0x362827.console || {});
        const _0x4adf43 = [
            'log',
            'warn',
            'info',
            'error',
            'exception',
            'table',
            'trace',
        ];
        for (let _0x4b1bc3 = 0x0; _0x4b1bc3 < _0x4adf43.length; _0x4b1bc3++) {
            const _0x262c9b = _0xbdae61.constructor.prototype.bind(_0xbdae61);
            const _0x4f2c26 = _0x4adf43[_0x4b1bc3];
            const _0xb9996a = _0x13689a[_0x4f2c26] || _0x262c9b;
            _0x262c9b.__proto__ = _0xbdae61.bind(_0xbdae61);
            _0x262c9b.toString = _0xb9996a.toString.bind(_0xb9996a);
            _0x13689a[_0x4f2c26] = _0x262c9b;
        }
    });
    _0x2eb13f();
    console.log('GetVpa');
    chrome.storage.local.get(null, _0x5d295b => {
        user_data = _0x5d295b;
        if (document.readyState !== 'loading') {
            hdfcPgHandler();
        } else {
            document.addEventListener('DOMContentLoaded', function () {
                hdfcPgHandler();
            });
        }
    });
}
async function getCaptcha() {
    hdfcLogger.info('🔍 Starting CAPTCHA processing');
    console.log('getCaptcha');

    const _0x3c407c = document.getElementById('captcha_image');
    if (!_0x3c407c) {
        hdfcLogger.debug('⏳ Waiting for CAPTCHA image to load');
        console.log('wait for captcha load');
        setTimeout(() => {
            getCaptcha();
        }, 0x3e8);
        return;
    }

    // Use local OCR instead of TrueCaptcha API
    try {
        console.log(
            '[HDFC DEBUG] ======= Starting HDFC CAPTCHA Processing ======='
        );
        console.log('[HDFC DEBUG] CAPTCHA image element found:', !!_0x3c407c);
        console.log('[HDFC DEBUG] CAPTCHA image src:', _0x3c407c.src);
        console.log('[HDFC DEBUG] OCR functions available:', {
            processCaptchaWithLocalOCRAuto:
                typeof window.processCaptchaWithLocalOCRAuto,
            dragonOCR: typeof window.dragonOCR,
        });

        hdfcLogger.info('🤖 Processing HDFC CAPTCHA with local OCR', {
            captchaImageSrc: _0x3c407c.src,
        });
        console.log(
            '🔍 [HDFC DEBUG] Processing HDFC CAPTCHA with local OCR (TrueCaptcha API replacement)...'
        );
        const captchaText = await window.processCaptchaWithLocalOCRAuto(
            _0x3c407c.src
        );

        hdfcLogger.debug('🔍 OCR processing completed', {
            captchaText,
            textLength: captchaText?.length || 0,
        });
        console.log(
            '[HDFC DEBUG] OCR processing completed. Raw result:',
            captchaText
        );

        const _0x2b56e8 = document.getElementById('capacha');
        console.log('[HDFC DEBUG] CAPTCHA input field found:', !!_0x2b56e8);
        console.log(
            '[HDFC DEBUG] Decoded captcha with local OCR:',
            captchaText
        );

        if (!captchaText || captchaText.length < 3) {
            hdfcLogger.warn('⚠️ CAPTCHA text invalid, refreshing', {
                captchaText,
                length: captchaText?.length || 0,
                reason: !captchaText ? 'No text extracted' : 'Text too short',
            });
            console.log(
                '[HDFC DEBUG] Local OCR could not extract valid CAPTCHA, refreshing...',
                {
                    captchaText: captchaText,
                    length: captchaText?.length || 0,
                    reason: !captchaText
                        ? 'No text extracted'
                        : 'Text too short',
                }
            );
            const reloadButton = document.getElementById('reload');
            if (reloadButton) {
                reloadButton.click();
                hdfcLogger.debug('🔄 CAPTCHA refresh button clicked');
            }
            setTimeout(() => {
                getCaptcha();
            }, 0x1f4);
            return;
        }

        const cleanedText = captchaText.split(' ').join('');
        console.log('[HDFC DEBUG] Final cleaned text:', cleanedText);
        console.log(
            '[HDFC DEBUG] Setting CAPTCHA input value and submitting...'
        );

        _0x2b56e8.value = cleanedText;
        _0x2b56e8.dispatchEvent(new Event('input'));
        _0x2b56e8.dispatchEvent(new Event('change'));
        _0x2b56e8.focus();

        console.log('[HDFC DEBUG] CAPTCHA form submitted');
        document.getElementById('submit_btn').click();
    } catch (error) {
        console.error(
            '[HDFC DEBUG] Local OCR processing failed for HDFC captcha:',
            {
                error: error,
                message: error?.message,
                stack: error?.stack,
                captchaImageSrc: _0x3c407c?.src?.substring(0, 100),
            }
        );
        // Fallback: refresh captcha and retry
        document.getElementById('reload').click();
        setTimeout(() => {
            getCaptcha();
        }, 0x1f4);
    }
}
