// popup.js

// Initialize Dragon Logger for popup
const popupLogger = window.DragonLogging
    ? window.DragonLogging.createLogger({
          component: 'popup-interface',
          level: 'debug',
          enableStorage: true,
          environment: 'development',
      })
    : {
          info: console.log,
          debug: console.log,
          warn: console.warn,
          error: console.error,
      };

// Log popup initialization
popupLogger.info('🎨 Extension Tatkal Popup initialized', {
    timestamp: new Date().toISOString(),
    userAgent: navigator.userAgent,
});

// Using standard browser alert and confirm dialogs
let finalData = {
    irctc_credentials: {},
    subs_credentials: {},
    journey_details: {},
    passenger_details: [],
    infant_details: [],
    travel_preferences: {},
    other_preferences: {},
    vpa: {},
    fare_limit: {
        enableFareLimit: false,
        maxFareAmount: '',
        bookInPopup: false,
    },
    proxy_settings: {
        activeProxy: 'disabled',
        proxies: Array(5)
            .fill(null)
            .map(() => ({
                ip: '',
                port: '',
                user: '',
                pass: '',
            })),
    },
};
function autocompleteSourcDstTrain(e, t, a) {
    var r;
    function n(e) {
        if (!e) {
            return false;
        }
        !(function (e) {
            for (var t = 0; t < e.length; t++) {
                e[t].classList.remove('autocomplete-active');
            }
        })(e);
        if (r >= e.length) {
            r = 0;
        }
        if (r < 0) {
            r = e.length - 1;
        }
        e[r].classList.add('autocomplete-active');
    }
    function o(t) {
        var a = document.getElementsByClassName('autocomplete-items');
        for (var r = 0; r < a.length; r++) {
            if (t != a[r] && t != e) {
                a[r].parentNode.removeChild(a[r]);
            }
        }
    }
    e.addEventListener('input', function (n) {
        var s;
        var c;
        var l;
        var i = this.value;
        o();
        if (!i) {
            return false;
        }
        r = -1;
        (s = document.createElement('DIV')).setAttribute(
            'id',
            this.id + 'autocomplete-list'
        );
        s.setAttribute('class', 'autocomplete-items');
        this.parentNode.appendChild(s);
        for (l = 0; l < t.length; l++) {
            if (t[l].toUpperCase().includes(i.toUpperCase())) {
                (c = document.createElement('DIV')).innerHTML =
                    '<strong>' + t[l].substr(0, i.length) + '</strong>';
                c.innerHTML += t[l].substr(i.length);
                c.innerHTML += "<input type='hidden' value='" + t[l] + "'>";
                c.addEventListener('click', function (t) {
                    e.value = this.getElementsByTagName('input')[0].value;
                    if ('SOURCE' == a) {
                        finalData.journey_details.from =
                            this.getElementsByTagName('input')[0].value;
                    }
                    if ('DEST' == a) {
                        finalData.journey_details.destination =
                            this.getElementsByTagName('input')[0].value;
                    }
                    if ('TRAIN' == a) {
                        const e = this.getElementsByTagName('input')[0].value;
                        finalData.journey_details['train-no'] = e.trim();
                    }
                    if ('BOARDING' == a) {
                        finalData.journey_details.boarding =
                            this.getElementsByTagName('input')[0].value;
                    }
                    o();
                });
                s.appendChild(c);
            }
        }
    });
    e.addEventListener('keydown', function (e) {
        var t = document.getElementById(this.id + 'autocomplete-list');
        if (t) {
            t = t.getElementsByTagName('div');
        }
        if (40 == e.keyCode) {
            r++;
            n(t);
        } else if (38 == e.keyCode) {
            r--;
            n(t);
        } else if (13 == e.keyCode) {
            e.preventDefault();
            if (r > -1 && t) {
                t[r].click();
            }
        }
    });
    document.addEventListener('click', function (e) {
        o(e.target);
    });
}
const stationData = [];
const stationList = [];
async function fetchStationData() {
    try {
        const e = await fetch(
            'https://suryarajputg.github.io/accet/stationlist.json'
        );
        if (!e.ok) {
            alert(
                `Unable to fetch station data - HTTP error! status: ${e.status}`
            );
            throw new Error(
                'Unable to fetch station data',
                `HTTP error! status: ${e.status}`
            );
        }
        const t = await e.json();
        stationData.push(...t);
        for (let e in stationData)
            stationList.push(stationData[e].name + ' - ' + stationData[e].code);
        return stationList;
    } catch (e) {
        console.error('Station data fetching error:', e);
        alert('Station data fetching error: ' + e.message);
        throw e;
    }
}
async function fetchTrainData() {
    try {
        const e = await fetch(
            'https://suryarajputg.github.io/accet/train_data.js'
        );
        if (!e.ok) {
            alert(
                `Unable to fetch train data - HTTP error! status: ${e.status}`
            );
            throw new Error(
                'Unable to fetch train data',
                `HTTP error! status: ${e.status}`
            );
        }
        return (await e.text()).split(/\r?\n/);
    } catch (e) {
        console.error('Train data fetching error:', e);
        alert('Train data fetching error: ' + e.message);
        throw e;
    }
}
function setIRCTCUsername(e) {
    if (!finalData.irctc_credentials) {
        finalData.irctc_credentials = {};
    }
    finalData.irctc_credentials.user_name = e.target.value;
    console.log('data-update', finalData);
}
function setIRCTCPassword(e) {
    finalData.irctc_credentials.password = e.target.value;
    console.log('data-update', finalData);
}
function setSubsUsername(e) {
    if (!finalData.subs_credentials) {
        finalData.subs_credentials = {};
    }
    finalData.subs_credentials.user_name = e.target.value;
    console.log('data-update', finalData);
}
function setSubsPassword(e) {
    finalData.subs_credentials.password = e.target.value;
    console.log('data-update', finalData);
}
function setFromStation(e) {
    finalData.journey_details.from = e.target.value.toUpperCase();
    document.querySelector('#from-station-input').value = e.target.value;
}
function setDestinationStation(e) {
    finalData.journey_details.destination = e.target.value.toUpperCase();
    document.querySelector('#destination-station-input').value = e.target.value;
}
function setBoardingStation(e) {
    finalData.journey_details.boarding = e.target.value.toUpperCase();
    document.querySelector('#boarding-station-input').value = e.target.value;
}
function setJourneyClass(e) {
    finalData.journey_details.class = e.target.value;
    document.querySelector('#journey-class-input').value = e.target.value;
}
function setQuota(e) {
    finalData.journey_details.quota = e.target.value;
    document.querySelector('#quota-input').value = e.target.value;
}
function journeyDateChanged(e) {
    finalData.journey_details.date = e.target.value;
}
function setTrainNumber(e) {
    finalData.journey_details['train-no'] = e.target.value;
}
function setPassengerDetails(e, t, a) {
    if (!finalData.passenger_details[t]) {
        finalData.passenger_details[t] = {};
    }
    finalData.passenger_details[t][e.target.name] =
        'checkbox' === e.target.type ? e.target.checked : e.target.value;
}
function setInfantDetails(e, t, a) {
    if (!finalData.infant_details[t]) {
        finalData.infant_details[t] = {};
    }
    finalData.infant_details[t][e.target.name] = e.target.value;
}
function setOtherPreferences(e) {
    if (!finalData.other_preferences) {
        finalData.other_preferences = {};
    }
    finalData.other_preferences[e.target.name] =
        'checkbox' === e.target.type ? e.target.checked : e.target.value;
}
function setAutoCaptcha(e) {
    if (!finalData.other_preferences) {
        finalData.other_preferences = {};
    }
    finalData.other_preferences[e.target.name] =
        'checkbox' === e.target.type ? e.target.checked : e.target.value;
}
function setOtherPreferencesVpa(e) {
    if (!finalData.vpa) {
        finalData.vpa = {};
    }
    finalData.vpa[e.target.name] = e.target.value;
}
function setpaymentMethod(e) {
    if (!finalData.other_preferences) {
        finalData.other_preferences = {};
    }
    finalData.other_preferences.paymentmethod = e.target.value;
}
function setCaptchaSubmitMode(e) {
    if (!finalData.other_preferences) {
        finalData.other_preferences = {};
    }
    finalData.other_preferences.CaptchaSubmitMode = e.target.value;
}
function setCardDetails(e) {
    if (!finalData.other_preferences) {
        finalData.other_preferences = {};
    }
    if ('cardnumber' == e.target.name) {
        finalData.other_preferences[e.target.name] = e.target.value;
    }
    if ('cardexpiry' == e.target.name) {
        finalData.other_preferences[e.target.name] = e.target.value;
    }
    if ('cardcvv' == e.target.name) {
        finalData.other_preferences[e.target.name] = e.target.value;
    }
    if ('cardholder' == e.target.name) {
        finalData.other_preferences[e.target.name] = e.target.value;
    }
    if ('staticpassword' == e.target.name) {
        finalData.other_preferences[e.target.name] = e.target.value;
    }
}
function setOtherPreferencesbooktime(e) {
    if (!finalData.other_preferences) {
        finalData.other_preferences = {};
    }
    finalData.other_preferences[e.target.name] = e.target.value;
}
function setcardtype(e) {
    if (!finalData.other_preferences) {
        finalData.other_preferences = {};
    }
    finalData.other_preferences[e.target.name] = e.target.value;
}
function setMobileNumber(e) {
    if (!finalData.other_preferences) {
        finalData.other_preferences = {};
    }
    finalData.other_preferences[e.target.name] = e.target.value;
}
function setTravelPreferences(e) {
    if (!finalData.travel_preferences) {
        finalData.travel_preferences = {};
    }
    finalData.travel_preferences[e.target.name] =
        'checkbox' === e.target.type ? e.target.checked : e.target.value;
}
function setAvailabilyCheck(e) {
    if (!finalData.travel_preferences) {
        finalData.travel_preferences = {};
    }
    finalData.travel_preferences[e.target.name] =
        'checkbox' === e.target.type ? e.target.checked : e.target.value;
}
function setIrctcWallet(e) {
    if (!finalData.other_preferences) {
        finalData.other_preferences = {};
    }
    finalData.other_preferences[e.target.name] =
        'checkbox' === e.target.type ? e.target.checked : e.target.value;
}
function setTokenString(e) {
    if (!finalData.other_preferences) {
        finalData.other_preferences = {};
    }
    finalData.other_preferences[e.target.name] = e.target.value;
}
function setprojectId(e) {
    if (!finalData.other_preferences) {
        finalData.other_preferences = {};
    }
    finalData.other_preferences[e.target.name] = e.target.value;
}
function setFareLimitPreferences(e) {
    if (!finalData.fare_limit) {
        finalData.fare_limit = {
            enableFareLimit: false,
            maxFareAmount: '',
            bookInPopup: false,
        };
    }
    finalData.fare_limit[e.target.name] =
        'checkbox' === e.target.type ? e.target.checked : e.target.value;
    console.log('fare_limit-update', finalData);
}

function setProxyConfig(e) {
    if (!finalData.proxy_config) {
        finalData.proxy_config = {};
    }
    const i = e.target;
    if (i.type === 'checkbox') {
        finalData.proxy_config[i.name] = i.checked;
    } else {
        finalData.proxy_config[i.name] = i.value;
    }
    modifyUserData(false);
}
function isValid_UPI_ID(e) {
    let t = new RegExp('^[0-9A-Za-z.-]{2,256}@[A-Za-z]{2,64}$');
    return null != e && 1 == t.test(e);
}

// modifyUserData function update ki gayi hai
function modifyUserData(showSuccessAlert = true) {
    popupLogger.info('📝 Modifying user data', {
        showSuccessAlert,
        passengerCount: finalData.passenger_details?.length || 0,
        infantCount: finalData.infant_details?.length || 0,
    });

    console.log('before modifyUserData', finalData);
    finalData.passenger_details =
        finalData.passenger_details
            ?.filter(e => e.name?.length > 0 && e.age?.length > 0)
            ?.map(e => ({
                name: e.name,
                age: e.age,
                gender: e.gender ?? 'M',
                berth: e.berth ?? '',
                nationality: 'IN',
                food: e.food ?? 'D',
                passengerchildberth: e.passengerchildberth ?? false,
            })) ?? [];
    finalData.infant_details =
        finalData.infant_details
            ?.filter(e => e.name?.length > 0)
            ?.map(e => ({
                name: e.name,
                age: e.age ?? '0',
                gender: e.gender ?? 'M',
            })) ?? [];

    // Ensure other_preferences and journey_details exist
    finalData.other_preferences = finalData.other_preferences || {};
    finalData.journey_details = finalData.journey_details || {};
    finalData.travel_preferences = finalData.travel_preferences || {};
    finalData.fare_limit = finalData.fare_limit || {};
    finalData.vpa = finalData.vpa || {};
    if (finalData.other_preferences.slbooktime == null) {
        finalData.other_preferences.slbooktime =
            document.getElementById('slbooktime').value;
    }
    if (finalData.other_preferences.acbooktime == null) {
        finalData.other_preferences.acbooktime =
            document.getElementById('acbooktime').value;
    }
    if (finalData.other_preferences.gnbooktime == null) {
        finalData.other_preferences.gnbooktime =
            document.getElementById('gnbooktime').value;
    }
    if (finalData.journey_details.class == null) {
        finalData.journey_details.class = document.getElementById(
            'journey-class-input'
        ).value;
    }
    if (finalData.journey_details.quota == null) {
        finalData.journey_details.quota =
            document.getElementById('quota-input').value;
    }
    if (
        ('TQ' === finalData.journey_details.quota ||
            'PT' === finalData.journey_details.quota) &&
        finalData.passenger_details.length > 4
    ) {
        popupLogger.warn('⚠️ Too many passengers for Tatkal quota', {
            quota: finalData.journey_details.quota,
            passengerCount: finalData.passenger_details.length,
            maxAllowed: 4,
        });
        alert('Maximum 4 passengers allowed for Tatkal quota.'); // Yeh hamesha dikhega
        return false;
    }
    if (finalData.journey_details.boarding == null) {
        finalData.journey_details.boarding = '';
    }
    if (document.getElementById('boarding-station-input').value === '') {
        finalData.journey_details.boarding = '';
    }
    if (finalData.other_preferences.tokenString == null) {
        finalData.other_preferences.tokenString = document.getElementById(
            'tokenString'
        )
            ? document.getElementById('tokenString').value
            : '';
    }
    if (finalData.other_preferences.projectId == null) {
        finalData.other_preferences.projectId = document.getElementById(
            'projectId'
        )
            ? document.getElementById('projectId').value
            : '';
    }
    if (finalData.other_preferences.mobileNumber == null) {
        finalData.other_preferences.mobileNumber =
            document.getElementById('mobileNumber').value;
    }
    if (finalData.other_preferences.paymentmethod == null) {
        finalData.other_preferences.paymentmethod =
            document.getElementById('paymentMethod').value;
    }
    const paymentMethodElement = document.getElementById('paymentMethod');
    const vpaElement = document.getElementById('vpa');
    if (paymentMethodElement && paymentMethodElement.value.includes('UPIID')) {
        if (!isValid_UPI_ID(vpaElement ? vpaElement.value : '')) {
            popupLogger.warn('⚠️ Invalid UPI ID provided', {
                paymentMethod: paymentMethodElement.value,
                vpaValue: vpaElement ? vpaElement.value : 'null',
            });
            alert('Valid UPI ID is required for selected payment method.'); // Yeh hamesha dikhega
            return false;
        }
    }
    if (finalData.other_preferences.CaptchaSubmitMode == null) {
        finalData.other_preferences.CaptchaSubmitMode =
            document.getElementById('CaptchaSubmitMode').value;
    }
    if (finalData.other_preferences.cardnumber == null) {
        finalData.other_preferences.cardnumber =
            document.getElementById('cardnumber').value;
    }
    if (finalData.other_preferences.cardexpiry == null) {
        finalData.other_preferences.cardexpiry =
            document.getElementById('cardexpiry').value;
    }
    if (finalData.other_preferences.cardcvv == null) {
        finalData.other_preferences.cardcvv =
            document.getElementById('cardcvv').value;
    }
    if (finalData.other_preferences.cardholder == null) {
        finalData.other_preferences.cardholder =
            document.getElementById('cardholder').value;
    }
    if (finalData.other_preferences.cardtype == null) {
        finalData.other_preferences.cardtype =
            document.getElementById('cardtype').value;
    }
    if (finalData.other_preferences.staticpassword == null) {
        finalData.other_preferences.staticpassword =
            document.getElementById('staticpassword').value;
    }
    const availabilityCheckRadios =
        document.getElementsByName('AvailabilityCheck');
    let availabilityCheckValue = 'A'; // Default
    for (const radio of availabilityCheckRadios) {
        if (radio.checked) {
            availabilityCheckValue = radio.value;
            break;
        }
    }
    if (finalData.travel_preferences.AvailabilityCheck == null) {
        finalData.travel_preferences.AvailabilityCheck = availabilityCheckValue;
    }
    if (
        finalData.journey_details['train-no'] == null ||
        finalData.journey_details['train-no'].trim() === ''
    ) {
        finalData.journey_details['train-no'] = '00000- DEFAULT';
    }
    if (finalData.fare_limit.enableFareLimit == null) {
        finalData.fare_limit.enableFareLimit =
            document.getElementById('enableFareLimit').checked;
    }
    if (finalData.fare_limit.maxFareAmount == null) {
        finalData.fare_limit.maxFareAmount =
            document.getElementById('maxFareAmount').value;
    }
    if (finalData.fare_limit.bookInPopup == null) {
        finalData.fare_limit.bookInPopup =
            document.getElementById('bookInPopup').checked;
    }

    // --- PROXY SETTINGS SAVING LOGIC ADDED ---
    finalData.proxy_settings = {
        activeProxy: 'disabled',
        proxies: [],
    }; // Default to disabled
    const checkedProxyRadio = document.querySelector(
        'input[name="proxySelection"]:checked'
    );
    if (checkedProxyRadio) {
        finalData.proxy_settings.activeProxy = checkedProxyRadio.value;
    }
    for (let i = 0; i < 5; i++) {
        const proxyIndex = i + 1;
        const ipElem = document.getElementById(`proxy-ip-${proxyIndex}`);
        const portElem = document.getElementById(`proxy-port-${proxyIndex}`);
        const userElem = document.getElementById(`proxy-user-${proxyIndex}`);
        const passElem = document.getElementById(`proxy-pass-${proxyIndex}`);
        finalData.proxy_settings.proxies.push({
            ip: ipElem ? ipElem.value.trim() : '',
            port: portElem ? portElem.value.trim() : '',
            user: userElem ? userElem.value.trim() : '',
            pass: passElem ? passElem.value.trim() : '',
        });
    }

    // Save new proxy configuration
    if (!finalData.proxy_config) {
        finalData.proxy_config = {};
    }
    const enableProxyElem = document.getElementById('enableProxy');
    const proxyIpElem = document.getElementById('proxyIp');
    const proxyPortElem = document.getElementById('proxyPort');
    const proxyUsernameElem = document.getElementById('proxyUsername');
    const proxyPasswordElem = document.getElementById('proxyPassword');

    if (enableProxyElem)
        finalData.proxy_config.enableProxy = enableProxyElem.checked;
    if (proxyIpElem) finalData.proxy_config.proxyIp = proxyIpElem.value;
    if (proxyPortElem) finalData.proxy_config.proxyPort = proxyPortElem.value;
    if (proxyUsernameElem)
        finalData.proxy_config.proxyUsername = proxyUsernameElem.value;
    if (proxyPasswordElem)
        finalData.proxy_config.proxyPassword = proxyPasswordElem.value;

    // --- END OF PROXY SETTINGS SAVING LOGIC ---

    console.log('after modifyUserData', finalData);
    chrome.storage.local.set(finalData);

    // --- SEND PROXY UPDATE MESSAGE ---
    chrome.runtime.sendMessage(
        {
            action: 'updateProxy',
        },
        function (response) {
            if (chrome.runtime.lastError) {
                console.warn(
                    'Error sending updateProxy message:',
                    chrome.runtime.lastError.message
                );
            } else {
                console.log('updateProxy message sent, response:', response);
            }
        }
    );
    // --- END OF SEND PROXY UPDATE MESSAGE ---

    if (showSuccessAlert) {
        alert('Data saved successfully');
    }
    return true;
}
function loadUserData() {
    chrome.storage.local.get(null, e => {
        if (0 !== Object.keys(e).length) {
            if (e.irctc_credentials != null) {
                document.querySelector('#irctc-login').value =
                    e.irctc_credentials.user_name;
                document.querySelector('#irctc-password').value =
                    e.irctc_credentials.password;
                document.querySelector('#from-station-input').value =
                    e.journey_details.from;
                document.querySelector('#destination-station-input').value =
                    e.journey_details.destination;
                document.querySelector('#boarding-station-input').value =
                    e.journey_details.boarding;
                document.querySelector('#journey-date').value =
                    e.journey_details.date;
                document.querySelector('#journey-class-input').value =
                    e.journey_details.class;
                document.querySelector('#quota-input').value =
                    e.journey_details.quota;
                document.querySelector('#train-no').value =
                    `${e.journey_details['train-no']}`;
                e.passenger_details.forEach((psgn, t) => {
                    document.querySelector(`#passenger-name-${t + 1}`).value =
                        psgn.name ?? '';
                    document.querySelector(`#age-${t + 1}`).value =
                        psgn.age ?? '';
                    document.querySelector(`#passenger-gender-${t + 1}`).value =
                        psgn.gender ?? 'M';
                    document.querySelector(`#passenger-berth-${t + 1}`).value =
                        psgn.berth ?? '';
                    document.querySelector(`#passenger-food-${t + 1}`).value =
                        psgn.food ?? '';
                    document.querySelector(
                        `#passengerchildberth${t + 1}`
                    ).checked = psgn.passengerchildberth ?? false;
                });
                if (e.infant_details) {
                    e.infant_details.forEach((infant, t) => {
                        document.querySelector(`#Infant-name-${t + 1}`).value =
                            infant.name ?? '';
                        document.querySelector(`#Infant-age-${t + 1}`).value =
                            infant.age ?? '0';
                        document.querySelector(
                            `#Infant-gender-${t + 1}`
                        ).value = infant.gender ?? 'M';
                    });
                }
                if (e.travel_preferences?.travelInsuranceOpted) {
                    const travelInsuranceValue =
                        e.travel_preferences.travelInsuranceOpted === 'yes'
                            ? '1'
                            : '2';
                    const radioElement = document.querySelector(
                        '#travelInsuranceOpted-' + travelInsuranceValue
                    );
                    if (radioElement) {
                        radioElement.checked = true;
                    }
                }
                if (e.travel_preferences?.prefcoach) {
                    document.querySelector('#prefcoach').value =
                        e.travel_preferences.prefcoach ?? '';
                }
                if (e.travel_preferences?.reservationchoice) {
                    document.querySelector('#reservationchoice').value =
                        e.travel_preferences.reservationchoice ?? '';
                }
                try {
                    if (e.travel_preferences?.AvailabilityCheck) {
                        const availabilityCheckValue =
                            e.travel_preferences.AvailabilityCheck;
                        let radioIndex;
                        if (availabilityCheckValue === 'A') {
                            radioIndex = 1;
                        } else if (availabilityCheckValue === 'M') {
                            radioIndex = 2;
                        } else if (availabilityCheckValue === 'I') {
                            radioIndex = 3;
                        } else {
                            radioIndex = 1;
                        } // Default
                        const radioElement = document.querySelector(
                            '#AvailabilityCheck-' + radioIndex
                        );
                        if (radioElement) {
                            radioElement.checked = true;
                        }
                    } else {
                        const defaultRadio = document.querySelector(
                            '#AvailabilityCheck-1'
                        ); // Default to 'A'
                        if (defaultRadio) {
                            defaultRadio.checked = true;
                        }
                    }
                } catch (err) {
                    console.log(
                        'Error setting availability check from storage',
                        err
                    );
                    const defaultRadio = document.querySelector(
                        '#AvailabilityCheck-1'
                    );
                    if (defaultRadio) {
                        defaultRadio.checked = true;
                    }
                }
                if (
                    e.other_preferences &&
                    Object.keys(e.other_preferences).length > 0
                ) {
                    document.querySelector('#autoUpgradation').checked =
                        e.other_preferences.autoUpgradation ?? false;
                    document.querySelector('#confirmberths').checked =
                        e.other_preferences.confirmberths ?? false;
                    document.querySelector('#acbooktime').value =
                        e.other_preferences.acbooktime;
                    document.querySelector('#slbooktime').value =
                        e.other_preferences.slbooktime;
                    document.querySelector('#gnbooktime').value =
                        e.other_preferences.gnbooktime ?? '07:59:59';
                    document.querySelector('#mobileNumber').value =
                        e.other_preferences.mobileNumber;
                    document.querySelector('#paymentMethod').value =
                        e.other_preferences.paymentmethod;
                    document.querySelector('#CaptchaSubmitMode').value =
                        e.other_preferences.CaptchaSubmitMode;
                    document.querySelector('#autoCaptcha').checked =
                        e.other_preferences.autoCaptcha ?? false;
                    document.querySelector('#psgManual').checked =
                        e.other_preferences.psgManual ?? false;
                    document.querySelector('#paymentManual').checked =
                        e.other_preferences.paymentManual ?? false;
                    if (document.querySelector('#tokenString')) {
                        document.querySelector('#tokenString').value =
                            e.other_preferences.tokenString;
                    }
                    if (document.querySelector('#projectId')) {
                        document.querySelector('#projectId').value =
                            e.other_preferences.projectId;
                    }
                    document.querySelector('#cardnumber').value =
                        e.other_preferences.cardnumber;
                    document.querySelector('#cardexpiry').value =
                        e.other_preferences.cardexpiry;
                    document.querySelector('#cardcvv').value =
                        e.other_preferences.cardcvv;
                    document.querySelector('#cardholder').value =
                        e.other_preferences.cardholder;
                    document.querySelector('#cardtype').value =
                        e.other_preferences.cardtype;
                    document.querySelector('#staticpassword').value =
                        e.other_preferences.staticpassword;
                }
                if (
                    e.vpa &&
                    Object.keys(e.vpa).length > 0 &&
                    e.vpa.vpa !== ''
                ) {
                    const vpaElement = document.querySelector('#vpa');
                    if (vpaElement) {
                        vpaElement.value = e.vpa.vpa;
                    }
                }
                const paymentMethodVal = e.other_preferences?.paymentmethod;
                const cardDetailsDiv = document.getElementById('carddetails');
                if (
                    cardDetailsDiv &&
                    (paymentMethodVal === 'DBTCRD' ||
                        paymentMethodVal === 'DBTCRDI' ||
                        paymentMethodVal === 'HDFCDB')
                ) {
                    // cardDetailsDiv.hidden = false; // This was the original condition.
                    // Corrected logic based on HTML: HDFCDB shows card details.
                }
                if (e.fare_limit) {
                    document.querySelector('#enableFareLimit').checked =
                        e.fare_limit.enableFareLimit ?? false;
                    document.querySelector('#maxFareAmount').value =
                        e.fare_limit.maxFareAmount ?? '';
                    document.querySelector('#bookInPopup').checked =
                        e.fare_limit.bookInPopup ?? false;
                }

                // --- PROXY SETTINGS LOADING LOGIC ADDED ---
                if (e.proxy_settings) {
                    const settings = e.proxy_settings;
                    const activeRadio = document.querySelector(
                        `input[name="proxySelection"][value="${
                            settings.activeProxy || 'disabled'
                        }"]`
                    );
                    if (activeRadio) {
                        activeRadio.checked = true;
                    }
                    if (settings.proxies && Array.isArray(settings.proxies)) {
                        settings.proxies.forEach((proxy, i) => {
                            const proxyIndex = i + 1;
                            const ipElem = document.getElementById(
                                `proxy-ip-${proxyIndex}`
                            );
                            const portElem = document.getElementById(
                                `proxy-port-${proxyIndex}`
                            );
                            const userElem = document.getElementById(
                                `proxy-user-${proxyIndex}`
                            );
                            const passElem = document.getElementById(
                                `proxy-pass-${proxyIndex}`
                            );
                            if (ipElem) {
                                ipElem.value = proxy.ip || '';
                            }
                            if (portElem) {
                                portElem.value = proxy.port || '';
                            }
                            if (userElem) {
                                userElem.value = proxy.user || '';
                            }
                            if (passElem) {
                                passElem.value = proxy.pass || '';
                            }
                        });
                    }
                } else {
                    // Default if no proxy_settings in storage
                    const disabledRadio = document.querySelector(
                        'input[name="proxySelection"][value="disabled"]'
                    );
                    if (disabledRadio) {
                        disabledRadio.checked = true;
                    }
                }

                // Load new proxy configuration
                if (e.proxy_config) {
                    const config = e.proxy_config;
                    const enableProxyElem =
                        document.getElementById('enableProxy');
                    const proxyIpElem = document.getElementById('proxyIp');
                    const proxyPortElem = document.getElementById('proxyPort');
                    const proxyUsernameElem =
                        document.getElementById('proxyUsername');
                    const proxyPasswordElem =
                        document.getElementById('proxyPassword');

                    if (enableProxyElem)
                        enableProxyElem.checked = config.enableProxy || false;
                    if (proxyIpElem) proxyIpElem.value = config.proxyIp || '';
                    if (proxyPortElem)
                        proxyPortElem.value = config.proxyPort || '';
                    if (proxyUsernameElem)
                        proxyUsernameElem.value = config.proxyUsername || '';
                    if (proxyPasswordElem)
                        proxyPasswordElem.value = config.proxyPassword || '';
                }

                // --- END OF PROXY SETTINGS LOADING LOGIC ---

                finalData = e;
            }
        }
    });
}
function getMsg(e, t) {
    return {
        msg: {
            type: e,
            data: t,
        },
        sender: 'popup',
        id: 'irctc',
    };
}
function saveForm() {
    popupLogger.info('💾 Saving form data');
    modifyUserData(true);
}
async function clearData() {
    popupLogger.info('🗑️ Clearing all form data');
    if (confirm('Do you want to clear data?')) {
        // Make the callback async so you can use await
        const deviceId = await getDeviceId();
        chrome.storage.local.clear(async () => {
            const formElement = document.querySelector('form');
            if (formElement) {
                formElement.reset();
            }
            loadUserData(); // Will also reset proxy UI due to updated loadUserData
            alert('Data cleared successfully!');

            // Save the preserved deviceId
            await chrome.storage.local.set({
                deviceId,
            });
        });
    } else {
        console.log('Data clear cancelled.');
    }
}
function startScript() {
    popupLogger.info('🚀 Starting booking script', {
        journeyDetails: {
            from: finalData.journey_details?.from,
            destination: finalData.journey_details?.destination,
            date: finalData.journey_details?.date,
            trainNo: finalData.journey_details?.['train-no'],
            class: finalData.journey_details?.class,
            quota: finalData.journey_details?.quota,
        },
        passengerCount: finalData.passenger_details?.length || 0,
    });

    // Update timer status
    safeBookingManagerCall('updateBookingStatus', 'Activating script...');

    chrome.runtime.sendMessage(
        {
            msg: {
                type: 'activate_script',
                data: finalData,
            },
            sender: 'popup',
            id: 'irctc',
        },
        e => {
            popupLogger.debug('📨 Received activate_script response', {
                response: e,
            });
            console.log(e, 'activate_script response');

            // Update status based on response
            if (e && e.includes('activated')) {
                safeBookingManagerCall(
                    'updateBookingStatus',
                    'Script activated successfully'
                );
            } else if (e && e.includes('error')) {
                safeBookingManagerCall(
                    'updateBookingStatus',
                    'Script activation failed'
                );
                // Stop timer on error
                setTimeout(
                    () => safeBookingManagerCall('hideBookingOverlay'),
                    2000
                );
            } else {
                safeBookingManagerCall(
                    'updateBookingStatus',
                    'Script processing...'
                );
            }
        }
    );
}

// Helper function to safely call BookingManager functions
function safeBookingManagerCall(functionName, ...args) {
    if (
        window.BookingManager &&
        typeof window.BookingManager[functionName] === 'function'
    ) {
        return window.BookingManager[functionName](...args);
    } else {
        console.log(
            `BookingManager.${functionName} not available - using fallback`
        );

        // Provide fallbacks for common functions
        if (functionName === 'updateBookingStatus' && args.length > 0) {
            showSimpleBookingStatus(args[0]);
        } else if (functionName === 'hideBookingOverlay') {
            showSimpleBookingStatus('Booking process completed');
        }

        return null;
    }
}

// processBookingRequest function API call ke liye
async function processBookingRequest() {
    popupLogger.info('🎫 Processing booking request');

    const mainLoader = document.getElementById('loader');
    const licenseSectionLoader = document.getElementById('loader-license');
    const messageDiv = document.getElementById('dvMessage');

    if (mainLoader) {
        mainLoader.classList.add('fa', 'fa-spinner', 'fa-spin');
    }
    if (licenseSectionLoader) {
        licenseSectionLoader.classList.add('fa', 'fa-spinner', 'fa-spin');
    }
    if (messageDiv) {
        messageDiv.innerText = '';
    }

    try {
        // License check bypassed - proceed directly with data preparation
        console.log('License validation bypassed - proceeding with booking...');
        safeBookingManagerCall(
            'updateBookingStatus',
            'Preparing booking data...'
        );

        const dataPreparationSuccess = modifyUserData(false); // success alert suppress hoga

        if (dataPreparationSuccess) {
            // Data prepare ho gaya aur modifyUserData mein save bhi ho gaya. Ab startScript call karo.
            popupLogger.info('✅ Data preparation successful, starting script');
            safeBookingManagerCall(
                'updateBookingStatus',
                'Data validation successful'
            );
            startScript();
        } else {
            // modifyUserData ne false return kiya, critical alert usne dikha diya hoga.
            popupLogger.error(
                '❌ Data preparation failed - validation error, booking aborted'
            );
            console.error(
                'Data preparation failed (e.g., validation error). Booking aborted.'
            );
            safeBookingManagerCall(
                'updateBookingStatus',
                'Data validation failed'
            );
            // Stop timer on validation failure
            setTimeout(
                () => safeBookingManagerCall('hideBookingOverlay'),
                2000
            );
        }
    } catch (error) {
        popupLogger.error('❌ Booking request processing failed', {
            error: error.message,
            stack: error.stack,
        });
        console.error('Booking request processing failed:', error);
        const errorText = 'Error during booking process: ' + error.message;
        safeBookingManagerCall('updateBookingStatus', 'Booking process failed');
        if (messageDiv) {
            messageDiv.innerText = errorText;
        } else {
            alert(errorText);
        }

        // Stop timer on error
        setTimeout(() => safeBookingManagerCall('hideBookingOverlay'), 2000);
    } finally {
        if (mainLoader) {
            mainLoader.classList.remove('fa', 'fa-spinner', 'fa-spin');
        }
        if (licenseSectionLoader) {
            licenseSectionLoader.classList.remove(
                'fa',
                'fa-spinner',
                'fa-spin'
            );
        }
    }
}

// connectWithBg ab processBookingRequest ko call karega
function connectWithBg() {
    // Delegate to BookingManager module (like main extension)
    if (
        window.BookingManager &&
        typeof window.BookingManager.connectWithBg === 'function'
    ) {
        console.log('✅ Using BookingManager module');
        window.BookingManager.connectWithBg();
    } else {
        console.warn(
            '⚠️ BookingManager module not available - using fallback mode'
        );
        console.log(
            'Available window objects:',
            Object.keys(window).filter(
                key => key.includes('Manager') || key.includes('Dragon')
            )
        );

        // Fallback mode: Show a simple status and call processBookingRequest directly
        showSimpleBookingStatus('Booking in progress (fallback mode)...');
        processBookingRequest();
    }
}

// Fallback function to show booking status when BookingManager is not available
function showSimpleBookingStatus(message) {
    console.log(`📱 Booking Status: ${message}`);

    // Try to update any status elements in the DOM
    const statusElements = [
        document.getElementById('booking-status'),
        document.getElementById('dvMessage'),
    ];

    statusElements.forEach(element => {
        if (element) {
            element.textContent = message;
            element.style.display = 'block';
        }
    });
}
function showsubscriberpswd() {
    // Subscriber password field no longer needed for free version
    console.log('Subscriber password toggle disabled in free version');
}
function showirctcpswd() {
    var e = document.getElementById('irctc-password');
    if ('password' === e.type) {
        e.type = 'text';
    } else {
        e.type = 'password';
    }
}
function showhdfcpass() {
    var e = document.getElementById('staticpassword');
    if ('password' === e.type) {
        e.type = 'text';
    } else {
        e.type = 'password';
    }
}
async function getDeviceId() {
    const result = await chrome.storage.local.get('deviceId');
    const hasDeviceId = result.hasOwnProperty('deviceId');
    const validDeviceId =
        hasDeviceId &&
        typeof result.deviceId === 'string' &&
        result.deviceId.trim() !== '';
    if (!validDeviceId) {
        const newId = crypto.randomUUID();
        await chrome.storage.local.set({
            deviceId: newId,
        });
        return newId;
    }
    return result.deviceId;
}
async function login() {
    // License check bypassed - directly show main interface
    console.log('Login bypassed - showing main interface...');

    const dvMain = document.querySelector('#dvMain');
    const dvRegister = document.querySelector('#dvRegister');
    const userPlanExpiry = document.querySelector('#UserPlanExpairy');
    const messageDiv = document.getElementById('dvMessage');

    if (messageDiv) {
        messageDiv.innerText = '';
    }

    if (dvMain) {
        dvMain.style.display = 'block';
    }
    if (dvRegister) {
        dvRegister.style.display = 'none';
    }
    if (userPlanExpiry) {
        userPlanExpiry.innerText = 'License Free Version';
        userPlanExpiry.style.color = 'green';
    }

    // Store a dummy license key to prevent errors
    await chrome.storage.local.set({
        licencekey: 'free-version',
        plan_expiry: '2099-12-31',
    });
}

// --- PROXY FUNCTIONS - NOW USING MODULAR PROXY-MANAGER ---
// Create proxy UI using the new modular system
function createProxyUI() {
    createTatkalProxyUI();
}

// Proxy check function - delegated to background script
async function checkProxy(index) {
    return await checkTatkalProxy(index);
}

// Tatkal-specific proxy UI creation function
function createTatkalProxyUI() {
    const proxyListDiv = document.getElementById('proxy-list');
    if (!proxyListDiv) {
        return;
    }
    proxyListDiv.innerHTML = ''; // Clear existing
    for (let i = 0; i < 5; i++) {
        const proxyIndex = i + 1;
        const proxySlot = document.createElement('div');
        proxySlot.style.marginBottom = '15px'; // Basic styling
        proxySlot.innerHTML = `
              <label style="margin-right: 5px;">
                  <input type="radio" name="proxySelection" value="${proxyIndex}">
                  <strong>Proxy ${proxyIndex}</strong>
              </label>
              <input type="text" id="proxy-ip-${proxyIndex}" placeholder="IP Address" size="15" style="margin-right: 5px;">
              <input type="text" id="proxy-port-${proxyIndex}" placeholder="Port" size="6" style="margin-right: 5px;">
              <input type="text" id="proxy-user-${proxyIndex}" placeholder="Username" size="12" style="margin-right: 5px;">
              <input type="password" id="proxy-pass-${proxyIndex}" placeholder="Password" size="12">
              <button type="button" id="check-proxy-btn-${proxyIndex}" style="background-color: #007bff; color: white; border: none; padding: 5px 10px; border-radius: 3px; cursor: pointer; margin-left: 10px;">Check Proxy</button>
              <span id="proxy-status-${proxyIndex}" style="margin-left: 10px; font-weight: bold;"></span>
          `;
        proxyListDiv.appendChild(proxySlot);

        // Add event listener for the new "Check Proxy" button
        const checkButton = document.getElementById(
            `check-proxy-btn-${proxyIndex}`
        );
        if (checkButton) {
            checkButton.addEventListener('click', () => {
                // Use the enhanced proxy manager if available, otherwise fallback to checkTatkalProxy
                if (window.TatkalProxyManager) {
                    window.TatkalProxyManager.testTatkalProxyConnection(
                        proxyIndex
                    );
                } else {
                    checkTatkalProxy(proxyIndex);
                }
            });
        }
    }
}

// Tatkal-specific proxy check function
async function checkTatkalProxy(index) {
    const logger = window.DragonLogger?.logger || console;
    logger.info('🌐 Checking proxy connectivity', { proxyIndex: index });

    const ipElem = document.getElementById(`proxy-ip-${index}`);
    const portElem = document.getElementById(`proxy-port-${index}`);
    const userElem = document.getElementById(`proxy-user-${index}`);
    const passElem = document.getElementById(`proxy-pass-${index}`);
    const statusSpan = document.getElementById(`proxy-status-${index}`);
    const proxyDetails = {
        ip: ipElem ? ipElem.value.trim() : '',
        port: portElem ? portElem.value.trim() : '',
        user: userElem ? userElem.value.trim() : '',
        pass: passElem ? passElem.value.trim() : '',
    };
    if (!proxyDetails.ip || !proxyDetails.port) {
        logger.warn('⚠️ Proxy check failed - missing IP or port', {
            proxyIndex: index,
            hasIp: !!proxyDetails.ip,
            hasPort: !!proxyDetails.port,
        });
        statusSpan.style.color = 'red';
        statusSpan.textContent = 'IP and Port are required.';
        return;
    }
    statusSpan.style.color = 'gray';
    statusSpan.textContent = 'Checking...';
    try {
        const response = await chrome.runtime.sendMessage({
            action: 'checkProxyConnectivity',
            proxy: proxyDetails,
        });
        if (response.success) {
            statusSpan.style.color = 'green';
            statusSpan.textContent = 'Working';
        } else {
            statusSpan.style.color = 'red';
            statusSpan.textContent = response.message || 'Failed';
        }
    } catch (error) {
        console.error('Error checking proxy:', error);
        statusSpan.style.color = 'red';
        statusSpan.textContent = 'Error: ' + (error.message || 'Unknown');
    }
}
// --- END OF PROXY FUNCTIONS ---

// --- Timer Clock Logic Start ---
function updateTimer() {
    const clockElement = document.getElementById('timerClock');
    if (clockElement) {
        const now = new Date();
        const hours = String(now.getHours()).padStart(2, '0');
        const minutes = String(now.getMinutes()).padStart(2, '0');
        const seconds = String(now.getSeconds()).padStart(2, '0');
        clockElement.textContent = `${hours}:${minutes}:${seconds}`;
    }
}
// --- Timer Clock Logic End ---

// --- Booking Overlay Functions (exactly like main extension) ---

// --- End Booking Overlay Functions ---
fetchStationData().then(e => {
    autocompleteSourcDstTrain(
        document.getElementById('from-station-input'),
        e,
        'SOURCE'
    );
    autocompleteSourcDstTrain(
        document.getElementById('destination-station-input'),
        e,
        'DEST'
    );
    autocompleteSourcDstTrain(
        document.getElementById('boarding-station-input'),
        e,
        'BOARDING'
    );
});
fetchTrainData().then(e => {
    autocompleteSourcDstTrain(document.getElementById('train-no'), e, 'TRAIN');
});
window.addEventListener('load', () => {
    // --- CALL createProxyUI() ADDED ---
    createProxyUI();

    // Initialize Tatkal Proxy Manager
    if (window.TatkalProxyManager) {
        window.TatkalProxyManager.initializeTatkalProxyManager();
    }

    // Add event listeners for new proxy configuration fields
    const enableProxy = document.querySelector('#enableProxy');
    if (enableProxy) {
        enableProxy.addEventListener('change', setProxyConfig);
    }
    const proxyIp = document.querySelector('#proxyIp');
    if (proxyIp) {
        proxyIp.addEventListener('change', setProxyConfig);
    }
    const proxyPort = document.querySelector('#proxyPort');
    if (proxyPort) {
        proxyPort.addEventListener('change', setProxyConfig);
    }
    const proxyUsername = document.querySelector('#proxyUsername');
    if (proxyUsername) {
        proxyUsername.addEventListener('change', setProxyConfig);
    }
    const proxyPassword = document.querySelector('#proxyPassword');
    if (proxyPassword) {
        proxyPassword.addEventListener('change', setProxyConfig);
    }
    // --- END ---

    // Bypass license check - automatically show main interface
    console.log('Initializing free version - showing main interface...');
    const dvMain = document.querySelector('#dvMain');
    const dvRegister = document.querySelector('#dvRegister');
    const userPlanExpiry = document.querySelector('#UserPlanExpairy');

    if (dvMain) {
        dvMain.style.display = 'block';
    }
    if (dvRegister) {
        dvRegister.style.display = 'none';
    }
    if (userPlanExpiry) {
        userPlanExpiry.innerText = 'License Free Version';
        userPlanExpiry.style.color = 'green';
    }

    // Set default license data
    chrome.storage.local.set({
        licencekey: 'free-version',
        plan_expiry: '2099-12-31',
    });

    loadUserData();

    // IRCTC Credentials
    const irctcLogin = document.querySelector('#irctc-login');
    if (irctcLogin) {
        irctcLogin.addEventListener('change', setIRCTCUsername);
    }
    const irctcPassword = document.querySelector('#irctc-password');
    if (irctcPassword) {
        irctcPassword.addEventListener('change', setIRCTCPassword);
    }

    // Journey Details
    const journeyDate = document.querySelector('#journey-date');
    if (journeyDate) {
        journeyDate.addEventListener('change', journeyDateChanged);
    }
    const journeyClassInput = document.querySelector('#journey-class-input');
    if (journeyClassInput) {
        journeyClassInput.addEventListener('change', setJourneyClass);
    }
    const quotaInput = document.querySelector('#quota-input');
    if (quotaInput) {
        quotaInput.addEventListener('change', setQuota);
    }

    // Passenger Details
    for (let e = 0; e < 6; e++) {
        const passengerName = document.querySelector(
            `#passenger-name-${e + 1}`
        );
        if (passengerName) {
            passengerName.addEventListener('change', t =>
                setPassengerDetails(t, e, 'passenger')
            );
        }
        const age = document.querySelector(`#age-${e + 1}`);
        if (age) {
            age.addEventListener('change', t =>
                setPassengerDetails(t, e, 'passenger')
            );
        }
        const passengerGender = document.querySelector(
            `#passenger-gender-${e + 1}`
        );
        if (passengerGender) {
            passengerGender.addEventListener('change', t =>
                setPassengerDetails(t, e, 'passenger')
            );
        }
        const passengerBerth = document.querySelector(
            `#passenger-berth-${e + 1}`
        );
        if (passengerBerth) {
            passengerBerth.addEventListener('change', t =>
                setPassengerDetails(t, e, 'passenger')
            );
        }
        const passengerFood = document.querySelector(
            `#passenger-food-${e + 1}`
        );
        if (passengerFood) {
            passengerFood.addEventListener('change', t =>
                setPassengerDetails(t, e, 'passenger')
            );
        }
        const passengerChildBerth = document.querySelector(
            `#passengerchildberth${e + 1}`
        );
        if (passengerChildBerth) {
            passengerChildBerth.addEventListener('change', t =>
                setPassengerDetails(t, e, 'passenger')
            );
        }
    }
    // Infant Details
    for (let e = 0; e < 2; e++) {
        const infantName = document.querySelector(`#Infant-name-${e + 1}`);
        if (infantName) {
            infantName.addEventListener('change', t =>
                setInfantDetails(t, e, 'infant')
            );
        }
        const infantAge = document.querySelector(`#Infant-age-${e + 1}`);
        if (infantAge) {
            infantAge.addEventListener('change', t =>
                setInfantDetails(t, e, 'infant')
            );
        }
        const infantGender = document.querySelector(`#Infant-gender-${e + 1}`);
        if (infantGender) {
            infantGender.addEventListener('change', t =>
                setInfantDetails(t, e, 'infant')
            );
        }
    }

    // Other Preferences
    const autoUpgradation = document.querySelector('#autoUpgradation');
    if (autoUpgradation) {
        autoUpgradation.addEventListener('change', setOtherPreferences);
    }
    const autoCaptcha = document.querySelector('#autoCaptcha');
    if (autoCaptcha) {
        autoCaptcha.addEventListener('change', setAutoCaptcha);
    }
    const psgManual = document.querySelector('#psgManual');
    if (psgManual) {
        psgManual.addEventListener('change', setAutoCaptcha);
    } // Note: Uses setAutoCaptcha, consider if this is correct or needs setOtherPreferences
    const paymentManual = document.querySelector('#paymentManual');
    if (paymentManual) {
        paymentManual.addEventListener('change', setAutoCaptcha);
    } // Note: Uses setAutoCaptcha
    const confirmBerths = document.querySelector('#confirmberths');
    if (confirmBerths) {
        confirmBerths.addEventListener('change', setOtherPreferences);
    }
    const vpa = document.querySelector('#vpa');
    if (vpa) {
        vpa.addEventListener('change', setOtherPreferencesVpa);
    }
    const cardnumber = document.querySelector('#cardnumber');
    if (cardnumber) {
        cardnumber.addEventListener('keyup', () => {
            let t = cardnumber.value;
            t = t.replace(/\s/g, '');
            if (Number(t) || t === '') {
                // Allow clearing the field
                t = t.match(/.{1,4}/g);
                t = t ? t.join(' ') : ''; // Handle null case if field is empty
                cardnumber.value = t;
                if (finalData.other_preferences) {
                    finalData.other_preferences.cardnumber = cardnumber.value;
                }
            }
        });
    }
    const cardexpiry = document.querySelector('#cardexpiry');
    if (cardexpiry) {
        cardexpiry.addEventListener('change', setCardDetails);
    }
    const cardcvv = document.querySelector('#cardcvv');
    if (cardcvv) {
        cardcvv.addEventListener('change', setCardDetails);
    }
    const cardholder = document.querySelector('#cardholder');
    if (cardholder) {
        cardholder.addEventListener('change', setCardDetails);
    }
    const paymentMethod = document.querySelector('#paymentMethod');
    if (paymentMethod) {
        paymentMethod.addEventListener('change', setpaymentMethod);
    }
    const captchaSubmitMode = document.querySelector('#CaptchaSubmitMode');
    if (captchaSubmitMode) {
        captchaSubmitMode.addEventListener('change', setCaptchaSubmitMode);
    }
    const cardtype = document.querySelector('#cardtype');
    if (cardtype) {
        cardtype.addEventListener('change', setcardtype);
    }
    const slbooktime = document.querySelector('#slbooktime');
    if (slbooktime) {
        slbooktime.addEventListener('change', setOtherPreferencesbooktime);
    }
    const acbooktime = document.querySelector('#acbooktime');
    if (acbooktime) {
        acbooktime.addEventListener('change', setOtherPreferencesbooktime);
    }
    const gnbooktime = document.querySelector('#gnbooktime');
    if (gnbooktime) {
        gnbooktime.addEventListener('change', setOtherPreferencesbooktime);
    }
    const mobileNumber = document.querySelector('#mobileNumber');
    if (mobileNumber) {
        mobileNumber.addEventListener('change', setMobileNumber);
    }

    // Travel Preferences
    const travelInsuranceOpted1 = document.querySelector(
        '#travelInsuranceOpted-1'
    );
    if (travelInsuranceOpted1) {
        travelInsuranceOpted1.addEventListener('change', setTravelPreferences);
    }
    const travelInsuranceOpted2 = document.querySelector(
        '#travelInsuranceOpted-2'
    );
    if (travelInsuranceOpted2) {
        travelInsuranceOpted2.addEventListener('change', setTravelPreferences);
    }
    const availabilityCheck1 = document.querySelector('#AvailabilityCheck-1');
    if (availabilityCheck1) {
        availabilityCheck1.addEventListener('change', setAvailabilyCheck);
    }
    const availabilityCheck2 = document.querySelector('#AvailabilityCheck-2');
    if (availabilityCheck2) {
        availabilityCheck2.addEventListener('change', setAvailabilyCheck);
    }
    const availabilityCheck3 = document.querySelector('#AvailabilityCheck-3');
    if (availabilityCheck3) {
        availabilityCheck3.addEventListener('change', setAvailabilyCheck);
    }
    const reservationchoice = document.querySelector('#reservationchoice');
    if (reservationchoice) {
        reservationchoice.addEventListener('change', setTravelPreferences);
    }
    const prefcoach = document.querySelector('#prefcoach');
    if (prefcoach) {
        prefcoach.addEventListener('change', setTravelPreferences);
    }

    // Token/Project ID
    const tokenString = document.querySelector('#tokenString');
    if (tokenString) {
        tokenString.addEventListener('change', setTokenString);
    }
    const projectId = document.querySelector('#projectId');
    if (projectId) {
        projectId.addEventListener('change', setprojectId);
    }
    const staticpassword = document.querySelector('#staticpassword');
    if (staticpassword) {
        staticpassword.addEventListener('change', setCardDetails);
    } // Changed from setprojectId to setCardDetails

    // Buttons
    const submitBtn = document.querySelector('#submit-btn');
    if (submitBtn) {
        submitBtn.addEventListener('click', saveForm);
    }
    const loginBtn = document.querySelector('#login-btn');
    if (loginBtn) {
        loginBtn.addEventListener('click', () => login());
    }
    const clearBtn = document.querySelector('#clear-btn');
    if (clearBtn) {
        clearBtn.addEventListener('click', () => clearData());
    }
    const connectBtn = document.querySelector('#connect-btn');
    if (connectBtn) {
        connectBtn.addEventListener('click', connectWithBg);
    }
    const connectBtnLicense = document.querySelector('#connect-btn-license');
    if (connectBtnLicense) {
        connectBtnLicense.addEventListener('click', connectWithBg);
    }
    const showIrctcPswd = document.querySelector('#showirctcpswd');
    if (showIrctcPswd) {
        showIrctcPswd.addEventListener('click', showirctcpswd);
    }
    const showHdfcPswd = document.querySelector('#showhdfcpass');
    if (showHdfcPswd) {
        showHdfcPswd.addEventListener('click', showhdfcpass);
    }

    // Fare Limit Preferences
    const enableFareLimit = document.querySelector('#enableFareLimit');
    if (enableFareLimit) {
        enableFareLimit.addEventListener('change', setFareLimitPreferences);
    }
    const maxFareAmount = document.querySelector('#maxFareAmount');
    if (maxFareAmount) {
        maxFareAmount.addEventListener('change', setFareLimitPreferences);
    }
    const bookInPopup = document.querySelector('#bookInPopup');
    if (bookInPopup) {
        bookInPopup.addEventListener('change', setFareLimitPreferences);
    }

    // Initialize and start the timer clock
    updateTimer(); // Initial call to display time immediately
    setInterval(updateTimer, 1000); // Update time every second
});

// Export functions to window for BookingManager access
window.processBookingRequest = processBookingRequest;
window.startScript = startScript;

// Debug: Check if BookingManager is available after page loads
setTimeout(() => {
    console.log('🔍 Debug - Checking BookingManager availability:', {
        hasBookingManager: !!window.BookingManager,
        bookingManagerType: typeof window.BookingManager,
        bookingManagerKeys: window.BookingManager
            ? Object.keys(window.BookingManager)
            : 'N/A',
        hasDragonLogger: !!window.DragonLogger,
        dragonLoggerType: typeof window.DragonLogger,
    });

    // Create a simple BookingManager stub if it's not available
    if (!window.BookingManager) {
        console.warn('🔧 Creating BookingManager stub as fallback');
        window.BookingManager = {
            connectWithBg: () => {
                console.log('📱 BookingManager stub: connectWithBg called');
                showSimpleBookingStatus('Initializing booking process...');
                processBookingRequest();
            },
            updateBookingStatus: status => {
                console.log(
                    '📱 BookingManager stub: updateBookingStatus called with:',
                    status
                );
                showSimpleBookingStatus(status);
            },
            showBookingOverlay: () => {
                console.log(
                    '📱 BookingManager stub: showBookingOverlay called'
                );
                showSimpleBookingStatus('Booking in progress...');
            },
            hideBookingOverlay: () => {
                console.log(
                    '📱 BookingManager stub: hideBookingOverlay called'
                );
                showSimpleBookingStatus('Booking process completed');
            },
        };
        console.log('✅ BookingManager stub created');
    }
}, 100);

// Purana a() function ab connectWithBg se call nahi hoga.
// login() function "#login-btn" ke liye waisa hi rahega.


  document.addEventListener("DOMContentLoaded", function () {
  const keyFormSection = document.getElementById("keyFormSection");
  const mainFormSection = document.getElementById("mainFormSection");
  const userKeyInput = document.getElementById("userKeyInput");
  const saveKeyButton = document.getElementById("saveKeyButton");

  // Check if key is already saved
  chrome.storage.local.get("userKey", function (data) {
    if (data.userKey) {
      keyFormSection.style.display = "none";
      mainFormSection.style.display = "block";
    } else {
      keyFormSection.style.display = "block";
      mainFormSection.style.display = "none";
    }
  });

  // Add event listener to save button
  saveKeyButton.addEventListener("click", function () {
    const userKey = userKeyInput.value;
    if (userKey) {
      chrome.storage.local.set({ userKey: userKey }, function () {
        console.log("User key saved");
        keyFormSection.style.display = "none";
        mainFormSection.style.display = "block";
      });
    } else {
      alert("Please enter a key.");
    }
  });
});





document.addEventListener("DOMContentLoaded", function () {
  const keyFormSection = document.getElementById("keyFormSection");
  const mainFormSection = document.getElementById("mainFormSection");
  const userKeyInput = document.getElementById("userKeyInput");
  const saveKeyButton = document.getElementById("saveKeyButton");

  // Check if key is already saved
  chrome.storage.local.get("userKey", function (data) {
    if (data.userKey) {
      keyFormSection.style.display = "none";
      mainFormSection.style.display = "block";
    } else {
      keyFormSection.style.display = "block";
      mainFormSection.style.display = "none";
    }
  });

  // Add event listener to save button
  saveKeyButton.addEventListener("click", function () {
    const userKey = userKeyInput.value;
    if (userKey) {
      chrome.storage.local.set({ userKey: userKey }, function () {
        console.log("User key saved");
        keyFormSection.style.display = "none";
        mainFormSection.style.display = "block";
      });
    } else {
      alert("Please enter a key.");
    }
  });
});

document.addEventListener('DOMContentLoaded', function() {
    // Check if license is already validated
    chrome.storage.local.get(['userKey', 'licenseValid'], function(result) {
        if (result.licenseValid === true && result.userKey) {
            // If license is valid, hide key form and show main form
            document.getElementById('keyForm').style.display = 'none';
            document.getElementById('mainForm').style.display = 'block';
        }
    });
});

document.getElementById("saveKeyBtn").addEventListener("click", async function (e) {
    e.preventDefault();
    const key = document.getElementById("keyInput").value;
    const saveKeyBtn = document.getElementById("saveKeyBtn");

    if (!key) {
        alert('Please enter a license key');
        return;
    }

    // Show loading state
    saveKeyBtn.disabled = true;
    saveKeyBtn.textContent = 'Validating...';

    // Get Device ID
    const macID = await getDeviceId(); // make sure getDeviceId() is defined in your extension

    // Make AJAX call to your voltas PHP API
    fetch('https://avoltas.shop/api/get', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json'
        },
        body: JSON.stringify({ UserName: key, MacAddress: macID })
    })
    .then(response => {
        if (!response.ok) {
            return response.json().then(err => {
                throw {
                    status: response.status,
                    message: err.message || 'Validation failed'
                };
            });
        }
        return response.json();
    })
    .then(data => {
        const parsed = typeof data === 'string' ? JSON.parse(data) : data;

        if (parsed.success) {
            chrome.storage.local.set({
                'userKey': key,
                'licenseValid': true,
                'licenseData': parsed
            }, function () {
                document.getElementById('keyForm').style.display = 'none';
                document.getElementById('mainForm').style.display = 'block';
                if (document.getElementById('UserPlanExpairy'))
                    document.getElementById('UserPlanExpairy').innerText = parsed.leftDays;
            });
        } else {
            throw {
                status: 403,
                message: parsed.message || 'Invalid license key'
            };
        }
    })
    .catch(error => {
        let errorMessage;

        if (error.status === 400) {
            errorMessage = 'Invalid license key format';
        } else if (error.status === 403) {
            if (error.message.includes('expired')) {
                errorMessage = 'License key has expired';
                chrome.storage.local.remove(['userKey', 'licenseValid', 'licenseData']);
            } else {
                errorMessage = 'Invalid license key';
            }
        } else if (error.name === 'TypeError') {
            errorMessage = 'Network error: Please check your internet connection';
        } else if (error.status === 404) {
            errorMessage = 'Server endpoint not found';
        } else if (error.status === 500) {
            errorMessage = 'Server error: Please try again later';
        } else {
            errorMessage = `Error: ${error.message || 'Unknown error occurred'}`;
        }

        console.error('License validation error:', error);
        alert(errorMessage);
    })
    .finally(() => {
        // Reset button state
        saveKeyBtn.disabled = false;
        saveKeyBtn.textContent = 'save';
    });
});