// HDFC Secure page handler (works in main window or popup/iframe)

let user_data = {};
GetVpa();

function GetVpa() {
    console.log("GetVpa");
    chrome.storage.local.get(null, (result) => {
        user_data = result;
        // If page is already loaded, call immediately; otherwise wait for DOMContentLoaded
        if (document.readyState !== "loading") {
            fillCardDatasecurehdfc();
        } else {
            document.addEventListener("DOMContentLoaded", fillCardDatasecurehdfc);
        }
    });
}

function fillCardDatasecurehdfc() {
    // Try every 500ms until the submitBtn2 appears and gets filled
    const intervalId = setInterval(() => {
        const submitBtn = document.getElementById("submitBtn2");
        if (!submitBtn) return;

        // Check for staticpassword in stored user_data
        if (user_data.other_preferences && user_data.other_preferences.staticpassword) {
            const pwd = user_data.other_preferences.staticpassword.trim();
            if (pwd.length > 0) {
                // Click on the “Static Password” tab under .auth-tab
                const authTabs = document.getElementsByClassName("auth-tab");
                if (authTabs.length > 0) {
                    const tabItems = authTabs[0].getElementsByTagName("li");
                    if (tabItems.length > 1) {
                        const anchor = tabItems[1].getElementsByTagName("a")[0];
                        if (anchor) anchor.click();
                    }
                }

                // Make sure submitBtn is visible in viewport
                const rect = submitBtn.getBoundingClientRect();
                if (rect.top > 0) {
                    const staticPwdInput = document.getElementById("staticPassword");
                    if (staticPwdInput) {
                        staticPwdInput.value = pwd;
                    }

                    // After 750ms, optionally auto-click submitBtn2
                    setTimeout(() => {
                        chrome.storage.sync.get(["submitBtn2autoClickEnabled"], (res) => {
                            if (res.submitBtn2autoClickEnabled) {
                                try {
                                    submitBtn.click();
                                } catch (e) {
                                    console.error("Click failed:", e);
                                }
                            }
                        });
                    }, 750);

                    clearInterval(intervalId);
                }
            }
        }
    }, 500);
}
