# -*- coding: utf-8 -*-
import libmediathek3 as libMediathek
import resources.lib.jsonparser as jsonParser


if libMediathek.getSetting('lang') == '0':
	provider = 'hbsard'
else:
	provider = 'hbszdf'
	jsonParser.setChannelZDF()
	
def translation(id):
	return libMediathek.getTranslation(id,'plugin.video.worldcup18_de')
def main():
	l = []
	l.append({'_name':translation(30100), 'mode':'listVideos', '_type': 'dir', 'url':'https://hbsard.deltatre.net/hbs/api/cup/fifawc/season/2018/videos/videolist'})
	l.append({'_name':translation(30101), 'mode':'listMatchesToday', '_type': 'dir', 'url':'https://hbsard.deltatre.net/hbs/api/cup/fifawc/season/2018/todaymatches?timezoneoffset=2'})
	l.append({'_name':translation(30102), 'mode':'listMatchDates', '_type': 'dir'})
	return l
	
def listMatchDates():
	return jsonParser.parseMatchDates()
	
def listMatches():
	return jsonParser.parseMatches(params['url'])
	
def listMatchesToday():
	return jsonParser.parseMatchesToday(params['url'])
	
def listMatch():
	return jsonParser.parseMatch(params['url'])
		
def listVideos():
	return jsonParser.parseVideos(params['url'])
	
def listMulti():
	return jsonParser.grepMulti(params['matchId'],params['kindId'])
	
def play():
	return jsonParser.getVideoUrl(params['vId'],params['kindId'])


modes = {
'main': main,
'listMatchDates': listMatchDates,
'listMatches': listMatches,
'listMatchesToday': listMatchesToday,
'listMatch': listMatch,
'listVideos': listVideos,
'listMulti': listMulti,
'play': play
}	

def list():	
	global params
	params = libMediathek.get_params()
	
	mode = params.get('mode','main')
	if mode == 'play':
		libMediathek.play(play())
	else:
		l = modes.get(mode)()
		libMediathek.addEntries(l)
		libMediathek.endOfDirectory()
list()