# -*- coding: utf-8 -*-
import json
import re
import libmediathek3 as libMediathek

fanart = libMediathek.fanart

base = 'https://hbsard.deltatre.net'
baseAPI = base + '/hbs/api/cup/fifawc/season/2018'
baseDivauni = 'https://hbsard.deltatre.net/divauni/ARD'
channel = 'hbsard'
def setChannelZDF():
	global base
	global baseAPI
	global baseDivauni
	global channel
	base = 'https://hbszdf.deltatre.net'
	baseAPI = base + '/hbs/api/cup/fifawc/season/2018'
	baseDivauni = 'https://hbszdf.deltatre.net/divauni/ZDF'
	channel = 'hbs'


def parseMatchDates():
	response = libMediathek.getUrl(baseAPI+'/dates?timezoneoffset=2')
	j = json.loads(response)
	l = []
	for item in j['modules']['dates']['list']:
		d = {}
		d['_name'] = item
		d['_type'] = 'dir'
		d['url'] = baseAPI + '/date/' + item + '/matches?timezoneoffset=2'
		d['mode'] = 'listMatches'
		l.append(d)
	return l
	

def parseMatches(url):
	response = libMediathek.getUrl(url)
	j = json.loads(response)
	return _grepMatches(j['modules']['matches'])
	
def parseMatchesToday(url):
	response = libMediathek.getUrl(url)
	j = json.loads(response)
	return _grepMatches(j['modules']['todaymatches'])

def _grepMatches(items):
	l = []
	for item in items:
		d = {}
		d['_name'] = item['homeTeam']['name']
		d['_name'] += ' - '
		d['_name'] += item['awayTeam']['name']
		d['_plot'] = item['roundName']
		d['_thumb'] = item['homeTeam']['logo']
		d['_type'] = 'dir'
		d['matchId'] = str(item['matchId'])
		d['url'] = baseAPI+'/match/'+str(item['matchId'])+'/matchinfo'
		d['mode'] = 'listMatch'
		l.append(d)
	return l
	
	
#def parseMatch(matchId):
#	url = baseAPI+'/match/'+matchId+'/matchinfo'
def parseMatch(url):
	response = libMediathek.getUrl(url)
	j = json.loads(response)
	return _grepVideos(j['modules']['matchInfo']['videos'])

def parseVideos(url):
	response = libMediathek.getUrl(url)
	j = json.loads(response)
	return _grepVideos(j['modules']['videos'])
	
def _grepVideos(items):
	l = []
	for item in items:
		libMediathek.log(str(item))
		#libMediathek.log(str(item['kindId']))
		libMediathek.log(str(item['mId']))
		d = {}
		d['_name'] = item['title']
		d['_plot'] = item['desc']
		d['_thumb'] = item['thumbSmall']
		d['kindId'] = str(item['kindId'])
		if item['kindId'] == 111 or item['kindId'] == 112:
			d['matchId'] = str(item['mId'])
			d['_type'] = 'dir'
			d['mode'] = 'listMulti'
		else:
			d['vId'] = str(item['vId'])
			d['_type'] = 'video'
			d['mode'] = 'play'
		l.append(d)
	return l
	
def grepMulti(matchId,kindId):
	#https://hbsard.deltatre.net/divauni/ARD/fe/video/multistreammrssfeed/108549.xml
	#response = libMediathek.getUrl(base+'/divauni/ARD/fe/video/multistreammrssfeed/'+matchId+'.xml')
	response = libMediathek.getUrl(baseDivauni+'/fe/video/multistreammrssfeed/'+matchId+'.xml')
	items = re.compile('<item>(.+?)</item>', re.DOTALL).findall(response)
	l = []
	for item in items:
		#libMediathek.log(str(item))
		d = {}
		d['_name'] = re.compile('<title>(.+?)</title>', re.DOTALL).findall(item)[0].replace('<![CDATA[','').replace(']]>','')
		d['_plot'] = re.compile('<description>(.+?)</description>', re.DOTALL).findall(item)[0].replace('<![CDATA[','').replace(']]>','')
		d['_thumb'] = re.compile('<videoThumbnail url="(.+?)"', re.DOTALL).findall(item)[0].replace('<![CDATA[','').replace(']]>','')
		d['vId'] = re.compile('<id>(.+?)</id>', re.DOTALL).findall(item)[0].replace('<![CDATA[','').replace(']]>','')
		d['_type'] = 'video'
		d['kindId'] = kindId
		d['mode'] = 'play'
		l.append(d)
	return l
	
def getVideoUrl(vId,kindId):
	libMediathek.log('kindId')
	libMediathek.log(kindId)
	#/videos/video/{videoid}
	d = {}
	d['media'] = []
	#response = libMediathek.getUrl('https://hbsard.deltatre.net/divauni/ARD/fe/video/videodata/'+vId+'.xml')
	response = libMediathek.getUrl(baseDivauni+'/fe/video/videodata/'+vId+'.xml')
	uri = re.compile('<uri>(.+?)</uri>', re.DOTALL).findall(response)[0]
	videoId = re.compile('<videoId>(.+?)</videoId>', re.DOTALL).findall(response)[0]
	assetState = re.compile('<assetState>(.+?)</assetState>', re.DOTALL).findall(response)[0]
	
	#p = json.dumps({  "Type": 1,  "User": "",  "VideoId": "8ec30092-668e-45af-aca5-fa12ae977073",  "VideoSource": "https://fwc2018-vod-ard.akamaized.net/C1E34D4836218E7E8CDE8D4F7DA82497/C1E34D4836218E7E8CDE8D4F7DA82497.m3u8",  "VideoKind": "",  "AssetState": "3",  "PlayerType": "HTML5",  "VideoSourceFormat": "HLS",  "VideoSourceName": "HLS",  "DRMType": "",  "AuthType": "",  "ContentKeyData": "",  "Other": "8ec30092-668e-45af-aca5-fa12ae977073"})
	h = {'Host':channel+'.deltatre.net','content-type':'application/json','referer':base+'/components/divahtml5/divaplayer.html'}
	p = json.dumps({'VideoSource': uri, 'VideoId': videoId, 'Other': videoId, 'AssetState': assetState, 'VideoSourceFormat':'DASH', 'VideoSourceName':'DASH', "PlayerType": "HTML5",  "DRMType": "",  "AuthType": "",  "ContentKeyData": "","Type": 1,  "User": "",  "VideoKind": "",  })
	
	#response = libMediathek.getUrl(base+'/api/api-akamai/tokenize',headers=h,post=p)
	response = libMediathek.getUrl('https://'+channel+'.deltatre.net'+'/api/api-akamai/tokenize',headers=h,post=p)
	#libMediathek.log(response)
	
	j = json.loads(response)
	#"ContentUrl": "<![CDATA[https://fwc2018-vod-ard.akamaized.net/8CB4141242E8EB45839B4E863E6B79B9/8CB4141242E8EB45839B4E863E6B79B9.m3u8]]>?hdnea=exp=1529106395~acl=/*~hmac=f313fa205aa715f3204cfd694730bc7cecdbadf24f79fac8de606bb9e325bdbb",
	if kindId == '111':
		d['media'].append({'url':j['ContentUrl'].replace('<![CDATA[','').replace(']]>',''), 'type': 'video', 'stream':'HLS'})
	else:
		d['media'].append({'url':j['ContentUrl'].replace('<![CDATA[','').replace(']]>',''), 'type': 'video', 'stream':'mp4'})
	return d
