package ru.compscicenter.java2012.multithreading2.demo1;

import java.util.concurrent.atomic.AtomicInteger;

public class IdFromAtomicInt {

    private static final AtomicInteger idSequence = new AtomicInteger();

    private static int nextId() {
        return idSequence.incrementAndGet();
    }

    private final int id;

    public IdFromAtomicInt() {
        this.id = nextId();
    }


    @Override
    public String toString() {
        return Integer.toString(id);
    }
}
