package ru.compscicenter.java2012.multithreading2.demo1;

import java.util.ArrayList;
import java.util.List;

public class IdSequenceDemo {

    public static void main(String[] args) throws Exception {
        List<Thread> threads = new ArrayList<Thread>();

        System.out.println("-- Ids generated with AtomicInteger");
        for (int i = 0; i < 10; ++i) {
            ThreadWithAtomicInt thread = new ThreadWithAtomicInt();
            threads.add(thread);
            thread.start();
        }

        joinAllThreads(threads);

        System.out.println();

        System.out.println("-- Ids generated with synchronized block");
        for (int i = 0; i < 10; ++i) {
            ThreadWithSyncBlock thread = new ThreadWithSyncBlock();
            threads.add(thread);
            thread.start();
        }

        joinAllThreads(threads);
    }


    private static void joinAllThreads(List<Thread> threads) throws Exception {
        for (Thread thread : threads) {
            thread.join();
        }
        threads.clear();
    }


    private static class ThreadWithAtomicInt extends Thread {

        @Override
        public void run() {
            for (int i = 0; i < 10; ++i) {
                System.out.println(new IdFromAtomicInt());
            }
        }
    }


    private static class ThreadWithSyncBlock extends Thread {

        @Override
        public void run() {
            for (int i = 0; i < 10; ++i) {
                System.out.println(new IdFromSyncBlock());
            }
        }
    }
}
