package ru.compscicenter.java2012.multithreading.demo3;

import java.util.ArrayList;
import java.util.List;

public class Demo3 {

    public static void main(String[] args) throws Exception {
        Account account = new Account(100000);
        System.out.println("Begin balance = " + account.getBalance());

        List<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 2; ++i) {
            Thread withdrawThread = new WithdrawThread(account);
            Thread depositThread = new DepositThread(account);
            threads.add(withdrawThread);
            threads.add(depositThread);
            withdrawThread.start();
            depositThread.start();
        }

        for (Thread thread : threads) {
            thread.join();
        }

        System.out.println("End balance = " + account.getBalance());
    }


    private static class WithdrawThread extends Thread {

        private final Account account;

        private WithdrawThread(Account account) {
            this.account = account;
        }

        @Override
        public void run() {
            for (int i = 0; i < 10000; ++i) {
                try {
                    account.withdraw(1);
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }


    private static class DepositThread extends Thread {

        private final Account account;

        private DepositThread(Account account) {
            this.account = account;
        }

        @Override
        public void run() {
            for (int i = 0; i < 10000; ++i) {
                account.deposit(1);
            }
        }
    }
}
