package ru.compscicenter.java2012.multithreading.demo5;

public class Demo5 {

    public static void main(String[] args) throws Exception {
        WorkerThread thread = new WorkerThread();
        thread.start();

        Thread.sleep(5000L);
        thread.setWork(false);

        thread.join();

        System.out.println("Finished");
    }


    private static class WorkerThread extends Thread {

        private boolean work = true;

        synchronized void setWork(boolean work) {
            this.work = work;
        }

        synchronized boolean getWork() {
            return work;
        }

        @Override
        public void run() {
            while (getWork()) {
                long sum = 0;
                for (int i = 0; i < 1000; ++i) {
                    sum += i;
                }
            }
        }
    }
}
