package ru.compscicenter.java2012.multithreading.demo3;

public class Account {

    private long balance;

    private final Object lock1 = new Object();
    private final Object lock2 = new Object();

    public Account() {
        this(0L);
    }

    public Account(long balance) {
        this.balance = balance;
    }

    public long getBalance() {
        return balance;
    }

    public void deposit(long amount) {
        checkAmountNonNegative(amount);
        synchronized (lock1) {
            balance += amount;
        }
    }

    public void withdraw(long amount) {
        checkAmountNonNegative(amount);
        synchronized (lock2) {
            if (balance < amount) {
                throw new IllegalArgumentException("not enough money");
            }
            balance -= amount;
        }
    }

    private static void checkAmountNonNegative(long amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("negative amount");
        }
    }
}
