package ru.compscicenter.java2012.networking.demo3;

import java.io.InputStream;
import java.net.URL;

public class UrlDemo {

    public static void main(String[] args) throws Exception {
        URL url = UrlDemo.class.getResource("UrlDemo.class");
        System.out.println(url);

        try (InputStream is = url.openStream()) {
            byte buf[] = new byte[2048];
            int bytesRead = is.read(buf);
            for (int i = 0; i < bytesRead; ++i) {
                if (i % 32 == 0) {
                    System.out.println();
                }
                System.out.printf("%02X ", buf[i]);
            }
        }
    }
}
