package ru.compscicenter.java2012.networking.demo4;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.*;

import java.util.logging.Level;
import java.util.logging.Logger;


public class EchoClientHandler extends SimpleChannelHandler {

    private static final Logger LOG = Logger.getLogger(EchoClientHandler.class.getName());

    @Override
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        String message = (String) e.getMessage();
        Channels.write(ctx, e.getFuture(),
                ChannelBuffers.wrappedBuffer(message.getBytes("UTF-8")),
                e.getRemoteAddress());
    }


    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        String message = getStringFromBuffer((ChannelBuffer) e.getMessage());
        LOG.info("Got response from " + e.getRemoteAddress() + ": " + message);
    }


    private static String getStringFromBuffer(ChannelBuffer channelBuffer) throws Exception {
        int bufSize = channelBuffer.readableBytes();
        byte[] byteBuffer = new byte[bufSize];
        channelBuffer.readBytes(byteBuffer);
        return new String(byteBuffer, "UTF-8");
    }


    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        LOG.log(Level.SEVERE, null, e.getCause());
        e.getChannel().close();
    }
}
