package ru.compscicenter.java2012.networking.demo4;

import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

import java.util.logging.Level;
import java.util.logging.Logger;


public class EchoServerHandler extends SimpleChannelUpstreamHandler {

    private static final Logger LOG = Logger.getLogger(EchoServerHandler.class.getName());

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        LOG.info("Got message from " + e.getRemoteAddress());
        e.getChannel().write(e.getMessage());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        LOG.log(Level.SEVERE, null, e.getCause());
        e.getChannel().close();
    }
}
