package ru.compscicenter.java2012.networking.demo4;

import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.*;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;

import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class NettyEchoClient {

    public static void main(String[] args) throws Exception {
        ChannelFactory factory = new NioClientSocketChannelFactory(
                Executors.newFixedThreadPool(1),
                Executors.newFixedThreadPool(4));

        ClientBootstrap bootstrap = new ClientBootstrap(factory);
        bootstrap.setPipelineFactory(new ChannelPipelineFactory() {
            public ChannelPipeline getPipeline() {
                return Channels.pipeline(new EchoClientHandler());
            }
        });

        ChannelFuture future = bootstrap.connect(new InetSocketAddress(11111));
        Channel channel = future.sync().getChannel();
        channel.write("Hello!");

        Thread.sleep(1000L);

        channel.close().await();
        factory.releaseExternalResources();
    }
}
