package ru.compscicenter.java2012.testing.demo3;

import org.junit.Test;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

import static org.mockito.Mockito.*;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class TreeSetTest {

    @Test
    public void treeset_should_call_comparator() {
        Comparator<Integer> comparator = mock(Comparator.class);
        when(comparator.compare(1, 1)).thenReturn(0);
        when(comparator.compare(2, 2)).thenReturn(0);
        when(comparator.compare(1, 2)).thenReturn(-1);
        when(comparator.compare(2, 1)).thenReturn(1);

        Set<Integer> treeSet = new TreeSet<Integer>(comparator);
        treeSet.add(1);
        treeSet.add(2);

        verify(comparator, times(1)).compare(isA(Integer.class), isA(Integer.class));
        verify(comparator, never()).equals(any());
    }


    @Test
    public void treeset_should_call_comparator_2() {
        Comparator<Integer> comparator = mock(Comparator.class);

        when(comparator.compare(2, 1)).thenAnswer(new Answer<Integer>() {
            public Integer answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ((Integer) invocationOnMock.getArguments()[0])
                        .compareTo((Integer) invocationOnMock.getArguments()[1]);
            }
        });


        Set<Integer> treeSet = new TreeSet<Integer>(comparator);
        treeSet.add(1);
        treeSet.add(2);

        verify(comparator, times(1)).compare(isA(Integer.class), isA(Integer.class));
        verify(comparator, never()).equals(any());
    }
}
