#!/usr/bin/env python 
import mincemeat
import sys

def mapfn(k, v):
    counter = {}
    for w in v.split():
        if w in counter:
            counter[w] = counter[w] + 1
        else:
            counter[w] = 0

    for w,c in counter.items():
        yield w + ":" + k, c
        yield w, 1

def reducefn(k, vs):
    result = 0
    for v in vs:
        result += v
    return result

s = mincemeat.Server() 

s.map_input = mincemeat.FileMapInput(sys.argv[1]) 
s.mapfn = mapfn
s.reducefn = reducefn

results = s.run_server(password="changeme") 
print results
