/*
 * Decompiled with CFR 0.152.
 */
package search.plugins.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.elasticsearch.common.settings.Settings;

public class Common {
    public static final int logLevel = 1;

    public static boolean canLog(int level) {
        return level > 1;
    }

    public static final void log0(Object o) {
        System.out.println(o.toString());
    }

    public static void log(int level, Object o) {
        if (Common.canLog(level)) {
            Common.log0(o);
        }
    }

    public static String getPathResources(Settings settings) {
        String sep = "/";
        String path = settings.get("path.home");
        String pluginPath = settings.get("sp.tools.path.name", "sp-tools");
        path = String.valueOf(path) + sep + "plugins";
        path = String.valueOf(path) + sep + pluginPath;
        path = String.valueOf(path) + sep + "resources";
        path = String.valueOf(path) + sep;
        return path;
    }

    public static String getPath(Settings settings) {
        String sep = "/";
        String path = settings.get("path.home");
        String pluginPath = settings.get("sp.tools.path.name", "sp-tools");
        path = String.valueOf(path) + sep + "plugins";
        path = String.valueOf(path) + sep + pluginPath;
        path = String.valueOf(path) + sep;
        return path;
    }

    public static byte[] readFile(File f) {
        if (!f.exists()) {
            return null;
        }
        int filelength = (int)f.length();
        Common.log(1, filelength);
        byte[] r = new byte[filelength];
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
                in.read(r);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return r;
    }

    public static Properties loadPropertiesfile(String filePath) {
        Properties properties = new Properties();
        try {
            FileReader fr = new FileReader(new File(filePath));
            properties.load(fr);
        }
        catch (IOException e) {
            Common.log(10, "The properties file is not loaded.\r\n" + e);
            throw new IllegalArgumentException("The properties file is not loaded.\r\n" + e);
        }
        return properties;
    }

    public static void main(String[] args) {
    }
}

