/*
 * Decompiled with CFR 0.152.
 */
package search.plugins.action;

import java.io.File;
import java.io.IOException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import search.plugins.common.Common;

public class RestConsoleAction
extends BaseRestHandler {
    String getPath = null;

    public void log(int level, Object o) {
        if (level > 1) {
            Common.log0(o);
        }
    }

    public RestConsoleAction(Settings settings, RestController controller, ClusterSettings clusterSettings, SettingsFilter settingsFilter) {
        super(settings);
        String path;
        controller.registerHandler(RestRequest.Method.GET, "/_console", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_console/{action}", (RestHandler)this);
        this.getPath = path = Common.getPathResources(settings);
        this.log(9, path);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String action = request.hasParam("action") ? request.param("action") : "show";
        BaseRestHandler.RestChannelConsumer rr = null;
        if ("show".equals(action)) {
            rr = this.returnConsloe(request, client);
        } else if (action.endsWith("js") || action.endsWith("css")) {
            rr = this.returnRs(request, client, action);
        }
        return rr;
    }

    private BaseRestHandler.RestChannelConsumer returnRs(RestRequest request, NodeClient client, String funcAction) {
        String htmlType = "text/css";
        if (funcAction.endsWith(".js")) {
            htmlType = "application/x-javascript";
            funcAction = funcAction.replace(".js", ".comp.js");
        }
        String path = String.valueOf(this.getPath) + "_console/" + funcAction;
        String type = htmlType;
        byte[] rs = Common.readFile(new File(path));
        if (rs == null) {
            this.log(10, "returnRs not found ! " + path);
        }
        BaseRestHandler.RestChannelConsumer rr = channel -> {
            if (rs == null) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NOT_FOUND, type, String.valueOf(path) + " not found!"));
            } else {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, type, rs));
            }
        };
        return rr;
    }

    private BaseRestHandler.RestChannelConsumer returnConsloe(RestRequest request, NodeClient client) {
        BaseRestHandler.RestChannelConsumer rr = channel -> {
            byte[] rs = Common.readFile(new File(String.valueOf(this.getPath) + "console.pub.html"));
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "text/html; charset=UTF-8", rs));
        };
        return rr;
    }
}

