/*
 * Decompiled with CFR 0.152.
 */
package search.plugins.filter;

import java.util.regex.Pattern;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import search.plugins.common.Common;
import search.plugins.filter.SpActionFilterUtil;
import search.plugins.functions.Functions;
import search.plugins.functions.auth.Auther;
import search.plugins.functions.logger.ActionLogger;
import search.plugins.functions.utils.SpInterface;

public class SpActionFilter
extends AbstractComponent
implements ActionFilter,
SpInterface {
    Auther auther;
    ActionLogger actionLogger;
    Pattern systemAction = Pattern.compile("(inter.+?)|((cluster:monitor/nodes/stats)|(indices:monitor/stats))");

    public void log(int level, Object o) {
        if (level > 1) {
            Common.log0(o);
        }
    }

    @Inject
    public SpActionFilter(Settings settings) {
        super(settings);
        Functions fc = Functions.getFunctions(settings);
        this.auther = fc.getAuther();
        this.actionLogger = fc.getActionLogger();
        this.log(3, "---> SpActionFilter init");
    }

    public int order() {
        return -1;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        this.log(1, "apply... " + action);
        boolean usingAuth = this.auther.isUsing();
        boolean usinglog = this.actionLogger.isUsing();
        if (usingAuth || usinglog) {
            boolean isJavaClient = this.isJavaClient(task, request);
            boolean isSystemAction = this.checkSystemAction(task, action);
            boolean isAuthed = false;
            if (!isSystemAction) {
                SpActionFilterUtil.checkRemoteAddress(request, listener);
                isAuthed = usingAuth ? this.auther.auth(task, action, request, listener, isJavaClient) : true;
                this.log(1, "remoteAddress:" + request.remoteAddress());
                if (usinglog) {
                    this.actionLogger.log(task, action, request, isAuthed, isJavaClient);
                }
            }
            if (!isAuthed && !isSystemAction) {
                if (!isJavaClient) {
                    listener.onFailure(new Exception("the auth is must please do the auth, this message is from sp tools"));
                }
            } else {
                chain.proceed(task, action, request, listener);
            }
        } else {
            chain.proceed(task, action, request, listener);
        }
    }

    private <Request extends ActionRequest> boolean isJavaClient(Task task, Request request) {
        boolean isJavaClient = false;
        isJavaClient = !task.getType().equals("transport");
        return isJavaClient;
    }

    private boolean checkSystemAction(Task task, String action) {
        boolean isSystemAction = this.systemAction.matcher(action).find();
        return isSystemAction;
    }
}

