/*
 * Decompiled with CFR 0.152.
 */
package search.plugins.functions.auth;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;
import search.plugins.common.Common;
import search.plugins.functions.auth.AuthInfo;
import search.plugins.functions.auth.Auther;
import search.plugins.functions.auth.Permissions;
import search.plugins.functions.auth.SimpleAutherUtil;

public class SimpleAuther
implements Auther {
    public boolean using = true;
    public boolean restUsing = true;
    public boolean clienttUsing = false;
    int seed = 33024;
    public Map<String, Permissions> ipListClient = new HashMap<String, Permissions>();
    public Map<String, Permissions> ipListRest;

    public void log(int level, Object o) {
        if (level > 1) {
            Common.log0(o);
        }
    }

    @Inject
    public SimpleAuther(Settings settings) {
        this.ipListClient.put("10", new Permissions(true));
        this.ipListClient.put("127", new Permissions(true));
        this.ipListClient.put("0", new Permissions(true));
        this.ipListClient.put("127.0.0.1", new Permissions(true));
        this.ipListClient.put("0.0.0.0", new Permissions(true));
        this.ipListRest = new HashMap<String, Permissions>();
        this.ipListRest.put("0.0.0.0", new Permissions(true));
    }

    @Override
    public void updateSettings(Properties pp) {
        String seed = pp.getProperty("auth.seed");
        if (seed != null) {
            this.seed = Integer.parseInt(seed);
        }
        String usingAuth = pp.getProperty("auther.using", "true");
        this.using = Boolean.parseBoolean(usingAuth);
    }

    @Override
    public <Response extends ActionResponse> boolean auth(Task task, String action, ActionRequest request, ActionListener<Response> listener, boolean isJavaClient) {
        if (!this.restUsing && !isJavaClient) {
            return true;
        }
        if (!this.clienttUsing && isJavaClient) {
            return true;
        }
        if (isJavaClient) {
            return this.dealClientAuth(request);
        }
        return this.dealRestAuth(task, action, request, listener);
    }

    private <Response extends ActionResponse> boolean dealRestAuth(Task task, String action, ActionRequest request, ActionListener<Response> listener) {
        if (request.remoteAddress() != null) {
            String addr = request.remoteAddress().getAddress();
            Permissions permission = this.ipListRest.get(addr);
            if (permission != null) {
                return permission.allowed;
            }
        } else {
            this.log(10, "dealRestAuth: remoteAddress is null!");
            return true;
        }
        AuthInfo info = SimpleAutherUtil.getAuthInfo(task, action, request, listener);
        if (info.key == null) {
            return false;
        }
        return this.valKey(null, info.user, info.key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dealClientAuth(ActionRequest request) {
        try {
            String addr = request.remoteAddress().getAddress();
            String[] ips = addr.split(".");
            String ipCheck = "";
            String[] stringArray = ips;
            int n = ips.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String ip = stringArray[n2];
                ipCheck = String.valueOf(ipCheck) + ip;
                Permissions permission = this.ipListClient.get(ipCheck);
                if (permission.allowed) {
                    return true;
                }
                ipCheck = String.valueOf(ipCheck) + ".";
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    @Override
    public boolean doRestAuth(RestRequest request, NodeClient client, String user, String pwd) {
        return user != null && pwd != null && user.equals(pwd);
    }

    @Override
    public String genKey(Calendar cal, String user) {
        long time = cal.getTimeInMillis();
        int v1 = (int)(time & 0xFEA0067L);
        int v2 = v1 | 0x10000 | this.seed;
        return Integer.toHexString(v2);
    }

    @Override
    public boolean valKey(Calendar cal, String user, String key) {
        int v1 = Integer.parseInt(key, 16);
        int v2 = v1 & this.seed;
        return v2 == this.seed;
    }

    @Override
    public void start() {
        this.restUsing = true;
    }

    @Override
    public void end() {
        this.restUsing = false;
    }

    @Override
    public boolean isRunning() {
        return this.using;
    }

    @Override
    public boolean isUsing() {
        return this.using;
    }

    public static void main(String[] args) {
        SimpleAuther sa = new SimpleAuther(null);
        System.out.println("seed:" + sa.seed);
        Calendar cal = Calendar.getInstance();
        String key = sa.genKey(cal, null);
        System.out.println("key:" + key);
        System.out.println(sa.valKey(cal, null, key));
    }

    @Override
    public Map<String, Permissions> getIpListRest() {
        return this.ipListRest;
    }

    @Override
    public Map<String, Permissions> getIpListClient() {
        return this.ipListClient;
    }
}

