/*
 * Decompiled with CFR 0.152.
 */
package search.plugins.functions.logger;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import search.plugins.functions.logger.ESLogThread;
import search.plugins.functions.logger.ESRecord;
import search.plugins.functions.logger.ESRecordList;
import search.plugins.functions.logger.LogConfiguration;

public class CacheLoggerWriter {
    private static ThreadLocal<ESRecordList> tlr = new ThreadLocal();
    protected static BlockingQueue<ESRecordList> bqr = new LinkedBlockingQueue<ESRecordList>();
    protected static Map<Long, ESRecordList> llr = new ConcurrentHashMap<Long, ESRecordList>();
    public static int poolSize = 200;

    public static void addRecordHighSpeed(ESRecord r) {
        ESRecordList lr = tlr.get();
        if (lr == null) {
            lr = new ESRecordList(poolSize);
            tlr.set(lr);
        }
        lr.lr.add(r);
        if (lr.lr.size() == poolSize) {
            bqr.add(lr);
            tlr.set(null);
        }
    }

    public static void addRecordMixed(ESRecord r) {
        ESRecordList lr = tlr.get();
        if (lr == null) {
            lr = new ESRecordList(poolSize);
            tlr.set(lr);
            llr.put(Thread.currentThread().getId(), lr);
        }
        lr.lr.add(r);
        if (lr.lr.size() == poolSize) {
            bqr.add(lr);
            tlr.set(null);
            llr.remove(Thread.currentThread().getId());
        }
    }

    public static void addRecordInTime(ESRecord r) {
        long tid = Thread.currentThread().getId();
        ESRecordList lr = llr.get(tid);
        if (lr == null) {
            lr = new ESRecordList(poolSize);
            llr.put(tid, lr);
        }
        lr.lr.add(r);
        if (lr.lr.size() == poolSize) {
            bqr.add(lr);
            llr.remove(Thread.currentThread().getId());
        }
    }

    static void init(LogConfiguration conf) {
        ESLogThread slt = new ESLogThread(conf);
        Thread t = new Thread(slt);
        t.start();
    }
}

