/*
 * Decompiled with CFR 0.152.
 */
package search.plugins.functions.logger;

import java.util.Properties;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import search.plugins.functions.logger.ActionLogger;
import search.plugins.functions.logger.CacheLoggerWriter;
import search.plugins.functions.logger.ESRecord;
import search.plugins.functions.logger.LogConfiguration;

public class CachedFileLogger
implements ActionLogger {
    public boolean using = true;
    public boolean useFastLog = false;
    LogConfiguration conf;

    public CachedFileLogger(Settings settings, LogConfiguration conf) {
        this.conf = conf;
        CacheLoggerWriter.init(conf);
    }

    @Override
    public void updateSettings(Properties pp) {
        String usingLog = pp.getProperty("logger.using", "true");
        this.using = Boolean.parseBoolean(usingLog);
    }

    @Override
    public void log(Task task, String action, ActionRequest request, boolean isAuthed, boolean isJavaClient) {
        if (this.using) {
            ESRecord r = this.parseRecord(task, action, request, isAuthed, isJavaClient);
            this.writeCache(r);
        }
    }

    private void writeCache(ESRecord r) {
        if (this.using) {
            if (this.useFastLog) {
                CacheLoggerWriter.addRecordMixed(r);
            } else {
                CacheLoggerWriter.addRecordInTime(r);
            }
        }
    }

    private ESRecord parseRecord(Task task, String action, ActionRequest request, boolean isAuthed, boolean isJavaClient) {
        ESRecord r = new ESRecord();
        r.statement = !action.endsWith("bulk") ? request.toString() : "bulk..:";
        if (request.remoteAddress() != null) {
            r.remoteIp = request.remoteAddress().toString();
        }
        r.action = action;
        r.isAuthed = isAuthed;
        r.isJavaClient = isJavaClient;
        r.startTime = System.currentTimeMillis();
        return r;
    }

    @Override
    public void start() {
        this.using = true;
    }

    @Override
    public void end() {
        this.using = false;
    }

    @Override
    public boolean isRunning() {
        return this.using;
    }

    @Override
    public boolean isUsing() {
        return this.using;
    }
}

