/*
 * Decompiled with CFR 0.152.
 */
package search.plugins.functions.logger;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import search.plugins.common.Common;
import search.plugins.functions.logger.CacheLoggerWriter;
import search.plugins.functions.logger.ESRecord;
import search.plugins.functions.logger.ESRecordList;
import search.plugins.functions.logger.LogConfiguration;

class ESLogThread
implements Runnable {
    LogConfiguration conf;
    final String filePath;
    final String path;
    static final int chunk = 0x400000;
    static final int chunk2 = 0x100000;
    static final int fileInterval = 3600000;
    static final int checkInterval = 2000;
    static final SimpleDateFormat dformat1 = new SimpleDateFormat("yyyyMMdd-HHmmss");
    static final SimpleDateFormat dformat2 = new SimpleDateFormat("yyyyMMdd-HH");
    Long t00 = null;
    Long t01 = null;
    private File f;
    private FileOutputStream fos;
    private FileChannel fc;

    public ESLogThread(LogConfiguration conf) {
        this.conf = conf;
        this.filePath = String.valueOf(conf.pathLogs) + "/eslog_";
        this.path = conf.pathLogs;
        this.log(1, this.path);
        this.log(1, this.filePath);
        this.f = this.getFile();
    }

    public void log(int level, Object o) {
        if (level > 2) {
            Common.log0(o);
        }
    }

    @Override
    public void run() {
        this.log(10, "---->log init....");
        Buffer bb = new Buffer();
        this.fc = this.getChannel(this.f, this.fc);
        this.t00 = System.currentTimeMillis();
        try {
            try {
                while (true) {
                    this.writeLog(bb);
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                try {
                    this.write0(bb, this.fc);
                    this.fc.close();
                    this.fos.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                this.write0(bb, this.fc);
                this.fc.close();
                this.fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    public void writeLog(Buffer bb) throws InterruptedException, IOException {
        this.execute(bb, this.fc);
    }

    public FileChannel getChannel(File f, FileChannel fc) {
        try {
            if (fc != null && fc.isOpen()) {
                fc.close();
            }
            if (this.fos != null) {
                this.fos.close();
            }
            this.fos = new FileOutputStream(f);
            this.fc = this.fos.getChannel();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.fc;
    }

    public File getFile() {
        Long t0 = System.currentTimeMillis();
        String t01 = dformat1.format(new Date(t0));
        File f = new File(String.valueOf(this.filePath) + t01 + ".log");
        File fileDir = new File(this.path);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        this.log(2, "f-->" + (System.currentTimeMillis() - t0));
        this.log(10, f.getAbsolutePath());
        return f;
    }

    public void execute(Buffer bb, FileChannel fc) throws InterruptedException, IOException {
        ESRecordList lr = CacheLoggerWriter.bqr.poll(2200L, TimeUnit.MILLISECONDS);
        try {
            if (lr != null) {
                this.dealRecordList(bb, fc, lr, false);
            } else {
                Set<Long> ks = CacheLoggerWriter.llr.keySet();
                for (long k : ks) {
                    lr = CacheLoggerWriter.llr.get(k);
                    this.dealRecordList(bb, fc, lr, true);
                }
            }
            this.dealLogInterval(bb, fc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void dealRecordList(Buffer bb, FileChannel fc, ESRecordList lr, boolean isInTime) throws IOException {
        int i = lr.position;
        lr.setCurrentPosition();
        while (i < lr.lr.size()) {
            ESRecord r = lr.lr.get(i);
            if (bb.capacity() < 0x100000) {
                this.log(3, "full write....");
                this.write0(bb, fc);
            }
            if (isInTime) {
                r.isInTime = true;
            }
            r.write(bb);
            ++i;
        }
    }

    public void dealLogInterval(Buffer bb, FileChannel fc) throws IOException {
        Long t001;
        if (this.t01 == null) {
            this.t01 = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.t01 > 2000L && bb.position() > 0) {
            this.write0(bb, fc);
            this.log(2, "interval write....");
            this.t01 = System.currentTimeMillis();
        }
        if ((t001 = Long.valueOf(System.currentTimeMillis())) - this.t00 > 3600000L) {
            this.dealOldFile();
            this.f = this.getFile();
            fc = this.getChannel(this.f, fc);
            this.t00 = t001;
            this.log(1, "file....");
        }
    }

    private void dealOldFile() {
        if (this.f.length() <= 0L) {
            try {
                this.fc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.f.delete();
        }
    }

    public void write0old(ByteBuffer bb, FileChannel fc) throws IOException {
        long t = System.currentTimeMillis();
        bb.flip();
        fc.write(bb);
        bb.clear();
        this.log(1, "-->" + (System.currentTimeMillis() - t));
    }

    public void write0(Buffer bb, FileChannel fc) throws IOException {
        long t = System.currentTimeMillis();
        ByteBuffer bbb = bb.getByteBuffer();
        fc.write(bbb);
        bb.clear();
        this.log(1, "-->" + (System.currentTimeMillis() - t));
    }

    class Buffer {
        private StringBuilder sb = new StringBuilder(0x400000);

        public ByteBuffer getByteBuffer() {
            String r = this.sb.toString();
            ByteBuffer bb = ByteBuffer.wrap(r.getBytes());
            return bb;
        }

        public StringBuilder getStringBuilder() {
            return this.sb;
        }

        public int capacity() {
            return this.sb.capacity();
        }

        public int position() {
            return this.sb.length();
        }

        public void clear() {
            this.sb = new StringBuilder(0x400000);
        }
    }
}

