/*
 * Decompiled with CFR 0.152.
 */
package search.plugins.functions.logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import search.plugins.functions.logger.ESLogThread;

public class ESRecord
implements Comparable<ESRecord> {
    public String statement;
    public String action;
    public String remoteIp;
    public long startTime;
    public int executeTime;
    boolean isAuthed;
    boolean isJavaClient;
    public boolean isInTime;
    DateFormat dateFormat = new SimpleDateFormat("yyyy-mm-dd HH:mm:ss", Locale.US);

    @Override
    public int compareTo(ESRecord o) {
        return this.executeTime - o.executeTime;
    }

    public void write(ESLogThread.Buffer bb) {
        this.write(bb.getStringBuilder());
    }

    public void write(StringBuilder sb) {
        if (this.isInTime) {
            sb.append("->");
        } else {
            sb.append("");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.startTime);
        sb.append(this.dateFormat.format(cal.getTime()));
        sb.append(" ");
        sb.append(this.executeTime);
        sb.append("ms ");
        sb.append(this.action);
        sb.append(" ");
        sb.append(this.remoteIp);
        sb.append(" ");
        sb.append(this.isAuthed ? "authed" : "notAuthed");
        sb.append(" ");
        sb.append(this.isJavaClient ? "java" : "http");
        sb.append("\r\n");
        sb.append(this.statement);
        sb.append("\r\n");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.write(sb);
        return sb.toString();
    }
}

