/*
 * Decompiled with CFR 0.152.
 */
package search.plugins.action;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import search.plugins.common.Common;
import search.plugins.functions.Functions;
import search.plugins.functions.auth.Auther;
import search.plugins.functions.logger.ActionLogger;

public class RestSpToolsAction
extends BaseRestHandler {
    String helpString = "please input: \r\n /_sp/help \r\n /_sp/auther \r\n /_sp/logger \r\n";
    String helpAutherString = "please input: \r\n /_sp/auther/start \r\n /_sp/auther/end \r\n /_sp/auther/stat\r\n /_sp/auther/auth\r\n /_sp/auther/settings\r\n";
    String helpLoggerString = "please input: \r\n /_sp/logger/start \r\n /_sp/logger/end \r\n /_sp/logger/stat\r\n  and with param:\r\n remoteInfo=true/false\r\n";
    String withPermission = "you do not have the permission to do this, please with the key. \r\n";
    Auther auther;
    ActionLogger actionLogger;
    String adminKey;
    String userKey;
    DateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    String pluginPath;

    public void log(int level, Object o) {
        if (level > 1) {
            Common.log0(o);
        }
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String func = request.hasParam("func") ? request.param("func") : "help";
        String funcAction = request.hasParam("action") ? request.param("action") : "help";
        this.log(1, "auther:" + this.auther);
        BaseRestHandler.RestChannelConsumer rr = null;
        switch (func) {
            case "auther": {
                rr = this.dealAuth(request, client, funcAction);
                break;
            }
            case "logger": {
                rr = this.dealLogger(request, client, funcAction);
                break;
            }
            case "help": {
                rr = this.dealHelp(request, client);
                break;
            }
            default: {
                rr = this.dealHelp(request, client);
            }
        }
        return rr;
    }

    BaseRestHandler.RestChannelConsumer dealAuth(RestRequest request, NodeClient client, String action) {
        String key = request.param("key");
        String user = request.param("user");
        String pwd = request.param("pwd");
        String remoteInfo = request.param("remoteInfo");
        String restIpMap = request.param("restIpMap");
        String clientIpMap = request.param("clientIpMap");
        BaseRestHandler.RestChannelConsumer rr = channel -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[10] lbl47 : CaseStatement: default:\u000a, @NONE, blocks:[10] lbl47 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.binarySort(TimSort.java:296)
             *     at java.base/java.util.TimSort.sort(TimSort.java:221)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
        return rr;
    }

    BaseRestHandler.RestChannelConsumer dealLogger(RestRequest request, NodeClient client, String action) {
        String key = request.param("key");
        BaseRestHandler.RestChannelConsumer rr = channel -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl35 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl35 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.binarySort(TimSort.java:296)
             *     at java.base/java.util.TimSort.sort(TimSort.java:221)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
        return rr;
    }

    BaseRestHandler.RestChannelConsumer dealHelp(RestRequest request, NodeClient client) {
        BaseRestHandler.RestChannelConsumer rr = channel -> {
            this.log(1, "--->@accept channel");
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, this.helpString));
        };
        return rr;
    }

    public RestSpToolsAction(Settings settings, RestController controller) {
        super(settings);
        this.log(1, "--->@Inject RestSpToolsAction");
        Functions fc = Functions.getFunctions(settings);
        this.auther = fc.getAuther();
        this.actionLogger = fc.getActionLogger();
        controller.registerHandler(RestRequest.Method.GET, "/_sp", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_sp/{func}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_sp/{func}/{action}", (RestHandler)this);
        this.loadConfig(settings);
    }

    private void loadConfig(Settings settings) {
        this.pluginPath = Common.getPath(settings);
        Properties pp = Common.loadPropertiesfile(String.valueOf(this.pluginPath) + "config.properties");
        this.adminKey = pp.getProperty("admin.adminKey", "admin");
        this.userKey = pp.getProperty("admin.userKey", "go");
        this.auther.updateSettings(pp);
        this.actionLogger.updateSettings(pp);
    }
}

