import sys, urllib, urllib2, cookielib, json, os
from string import digits
import xbmcaddon, xbmc, xbmcgui, xbmcplugin

sysarg=str(sys.argv[1])
ADDON_ID='plugin.video.soggysandwich'
addon=xbmcaddon.Addon(id=ADDON_ID)
home=xbmc.translatePath(addon.getAddonInfo('path').decode('utf-8'))

def parseParameters(inputString=sys.argv[2]):
    parameters = {}
    p1 = inputString.find('?')
    if p1 >= 0:
        splitParameters = inputString[p1 + 1:].split('&')
        for nameValuePair in splitParameters:
            try:
                if (len(nameValuePair) > 0):
                    pair = nameValuePair.split('=')
                    key = pair[0]
                    value = urllib.unquote(urllib.unquote_plus(pair[1])).decode('utf-8')
                    parameters[key] = value
                    #logError(value)
            except:
                pass
    return parameters

def logError(error):
    try:
        xbmc.log(ADDON_ID+" - "+str(error.encode("utf-8")), xbmc.LOGERROR)
    except:
        xbmc.log(ADDON_ID+" - "+str(error), xbmc.LOGERROR)

def addMenuItems(details, isFolder=True):
    changed=False
    for detail in details:
        try:
            u=sys.argv[0]+"?url="+detail['url']+"&mode="+str(detail['mode'])+"&name="+urllib.quote_plus(detail['title'].encode("utf-8"))+"&icon="+detail['icon']
            liz=xbmcgui.ListItem(detail['title'].encode("utf-8"), iconImage=detail['icon'], thumbnailImage=detail['icon'])
            liz.setInfo(type=detail['type'], infoLabels={ "Title": detail['title'].encode("utf-8"),"Plot": detail['plot']} )
        except:
            u=sys.argv[0]+"?url="+detail['url']+"&mode="+str(detail['mode'])+"&name="+urllib.quote_plus(detail['title']).decode("utf-8")+"&icon="+detail['icon']
            liz=xbmcgui.ListItem(detail['title'].encode("utf-8"), iconImage=detail['icon'], thumbnailImage=detail['icon'])
            liz.setInfo(type=detail['type'], infoLabels={ "Title": detail['title'].decode("utf-8"),"Plot": detail['plot']} )
            
        try:
            liz.setProperty("Fanart_Image", detail['fanart'])
            u=u+"&fanart="+detail['fanart']
        except:
            pass
        try:
            liz.setProperty("Landscape_Image", detail['landscape'])
            u=u+"&landscape="+detail['landscape']
        except:
            pass
        try:
            liz.setProperty("Poster_Image", detail['poster'])
            u=u+"&poster="+detail['poster']
        except:
            pass
        try:
            u=u+"&extras="+str(detail["extras"])
        except:
            pass
        if isFolder:
            ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=True)
        else:
            liz.setProperty('IsPlayable', 'true')
            ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=False)
    xbmcplugin.endOfDirectory(int(sysarg))

def notify(message, reportError=False, timeShown=5000):
    """Displays a notification to the user
    
    Parameters:
    addonId: the current addon id
    message: the message to be shown
    timeShown: the length of time for which the notification will be shown, in milliseconds, 5 seconds by default
    """
    xbmc.executebuiltin('Notification(%s, %s, %d, %s)' % (addon.getAddonInfo('name'), message, timeShown, addon.getAddonInfo('icon')))
    if reportError:
        logError(message)
    
def buildSeriesMenu(items, filter, media_type, limit=20, offset=0):
    menu=[]

    for item in items:
        menu.append({
            "title": item['name'],
            "url": "list_media",
            "extras": {"series_id": item['series_id'], "limit": 10000},
            "mode":2, 
            "poster":item['portrait_image']['large_url'],
            "icon":item['portrait_image']['large_url'], 
            "fanart":item['landscape_image']['full_url'],
            "type":"video", 
            "plot":item['description']
        })
    if len(menu)==20:
        menu.append({
            "title": "Next >",
            "url": "list_series",
            "extras": {"media_type": media_type, "filter": filter, "limit": str(limit), "offset": int(offset)+int(limit)},
            "mode":1, 
            "poster":"none",
            "icon":"none", 
            "fanart":"none",
            "type":"video", 
            "plot":""
        })
    addMenuItems(menu, isFolder=True)

def buildEpisodesMenu(items):
    menu=[]
    for item in items:
        if item['free_available']==False and int(item['free_available_time'][:4])<9000:
            title="[COLOR lightcoral]Episode "+item['episode_number']+" - "+item['name']+" (Available "+item['free_available_time'][8:][:2]+"/"+item['free_available_time'][5:][:2]+"/"+item['free_available_time'][:4]+")[/COLOR]"
        else:
            title="Episode "+item['episode_number']+" - "+item['name']
        menu.append({
            "title": title,
            "url": "info",
            "extras": {"media_id": item['media_id'], "fields": "media.stream_data"},
            "mode":10, 
            "poster":item['screenshot_image']['large_url'],
            "icon":item['screenshot_image']['large_url'], 
            "fanart":item['screenshot_image']['full_url'],
            "type":"video", 
            "plot":item['description']
        })
    addMenuItems(menu, isFolder=False)
    
def buildCategoryMenu(items, media_type):
    menu=[]
    for item in items:
        path=filter(lambda x: x.isalpha(), item['label'])
        menu.append({
            "title": item['label'],
            "url": "list_series",
            "extras": {"media_type" : media_type, "filter" : "tag:"+item['tag'], "limit": 20, "offset": 0},
            "mode":1, 
            "poster":os.path.join(home, 'resources/media/genre', path.lower()+'.jpg'),
            "icon":os.path.join(home, 'resources/media/genre', path.lower()+'.jpg'), 
            "fanart":os.path.join(home, 'resources/media', 'fanart.jpg'),
            "type":"video", 
            "plot":""
        })
    addMenuItems(menu, isFolder=True)

def buildAlphabetMenu(media_type):
    menu=[]
    letters=['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z']
    for letter in letters:
        menu.append({
            "title": letter.upper(),
            "url": "list_series",
            "extras": {"media_type" : media_type, "filter" : "prefix:"+letter, "limit": 20, "offset": 0},
            "mode":1, 
            "poster":os.path.join(home, 'resources/media/letters', letter+'.jpg'),
            "icon":os.path.join(home, 'resources/media/letters', letter+'.jpg'), 
            "fanart":os.path.join(home, 'resources/media', 'fanart.jpg'),
            "type":"video", 
            "plot":""
        })
    addMenuItems(menu, isFolder=True)
    
def search(items):
    find=searchDialog()
    if find!=False:
        #items['media_types']="anime|drama"
        items['q']=find
        return items
    else:
        return False

def searchDialog(searchText="Please enter search text") :    
    keyb=xbmc.Keyboard('', searchText)
    keyb.doModal()
    searchText=''
    
    if (keyb.isConfirmed()) :
        searchText = keyb.getText()
    if searchText!='':
        return searchText
    return False
        
def playMedia(title, thumbnail, items) :
    for item in items:
        if item['quality']=='adaptive':
            li = xbmcgui.ListItem(label=title, iconImage=thumbnail, thumbnailImage=thumbnail, path=item['url'])
            li.setInfo( "video", { "Title" : title } )
            xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, li)
            break
            
def crunchyroll_login():
    cj = cookielib.CookieJar()
    opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cj))
    session = {}
    
    login_url = 'https://www.crunchyroll.com/'
    data = urllib.urlencode({'a' : 'formhandler', 'name' : xbmcaddon.Addon().getSetting('username'), 'password' : xbmcaddon.Addon().getSetting('password'), 'formname' : 'RpcApiUser'})
    
    resp=opener.open(login_url, data)
    
    for cookie in cj:
       session[cookie.name]=cookie.value
    
    xbmcaddon.Addon().setSetting('session_id', session['sess_id'])
    
def crunchyroll_api(func, args):
    run=0
    while True:
        args['session_id'] = xbmcaddon.Addon().getSetting('session_id')
        if not args['session_id']:
            crunchyroll_login()
            args['session_id'] = xbmcaddon.Addon().getSetting('session_id')
            
        api_url = 'http://api.crunchyroll.com/'+func+'.0.json'
        
        opener = urllib2.build_opener(urllib2.HTTPCookieProcessor())
        
        data = urllib.urlencode(args)
        
        if xbmcaddon.Addon().getSetting('debug')=="true":
            logError("API Call = "+api_url+"?"+data)
        
        resp=opener.open(api_url, data)

        content = resp.read()
        results=json.loads(content)
        
        if results['error']==True:
            # try refreshing the login and try again
            crunchyroll_login()
        else:
            break
        run+=1
        if run==2:
            notify(results['message'])
            logError("API Error = "+results['message'])
            return False
            
    return content