import util, menu
import ast, json
import xbmcaddon
#import xbmcplugin, xbmcaddon, xbmcgui

sysarg=str(sys.argv[1])

if xbmcaddon.Addon().getSetting('debug')=="true":
    util.logError("Session ID = "+xbmcaddon.Addon().getSetting('session_id'))

parameters=util.parseParameters()

try:
    mode=int(parameters["mode"])
except:
    mode=None

if mode==0:
    # load in menus
    util.addMenuItems(getattr(menu, parameters['url']))
elif mode==1:
    # get series folders
    extras=ast.literal_eval(parameters['extras'])
    series=util.crunchyroll_api(parameters['url'], extras)
    results=json.loads(series)
    if not results['data']:
        util.notify("No results found.")
    else:
        util.buildSeriesMenu(results['data'], extras['filter'], extras['media_type'], extras['limit'], extras['offset'])
elif mode==2:
    # get episode list
    episodes=util.crunchyroll_api(parameters['url'], ast.literal_eval(parameters['extras']))
    results=json.loads(episodes)
    if not results['data']:
        util.notify("No results found.")
    else:
        util.buildEpisodesMenu(results['data'])
elif mode==3:
    # run a search
    search=util.search(ast.literal_eval(parameters['extras'].replace("<or>", "|")))
    results=util.crunchyroll_api(parameters['url'], search)
    results=json.loads(results)
    if not results['data']:
        util.notify("No results found.")
    else:
        util.buildSeriesMenu(results['data'], '', 'anime|drama', 20, 0)
elif mode==4:
    # get category list
    extras=ast.literal_eval(parameters['extras'])
    categories=util.crunchyroll_api(parameters['url'], extras)
    results=json.loads(categories)
    if not results['data']:
        util.notify("No results found.")
    else:
        util.buildCategoryMenu(results['data'][parameters['name'][:-1].lower()], extras['media_type'])
elif mode==5:
    # show an alphabetical list
    extras=ast.literal_eval(parameters['extras'])
    util.buildAlphabetMenu(extras['media_type'])        
elif mode==10:
    # play episode
    episode=util.crunchyroll_api(parameters['url'], ast.literal_eval(parameters['extras']))
    if episode!=False:
        results=json.loads(episode)
        util.playMedia(parameters['name'], parameters['fanart'], results['data']['stream_data']['streams'])
else:
    util.addMenuItems(menu.mainMenu)