# -*- coding: utf-8 -*-
import xbmc, xbmcaddon, xbmcgui
import sys, io, os, json, time

try:
	# For Python 3.0 and later
	import urllib.parse as urlparse
	import xbmcvfs
	translatePath = xbmcvfs.translatePath
	uni_code = str
	from urllib.request import urlopen
	from urllib.request import Request
	py2 = False
except ImportError:
	# Fall back to Python 2
	py2 = True
	import urlparse
	translatePath = xbmc.translatePath
	uni_code = unicode
	from urllib2 import urlopen
	from urllib2 import Request

def decode(text, dec, force=False):
	if py2:
		text = text.decode(dec)
	elif force:
		text= bytearray(text, 'utf-8').decode(dec)
	return text

def encode(text, dec):
	if py2:
		text = text.encode(dec)
	return text

def ReadList(fileName):
	try:
		with io.open(fileName, 'r', encoding='utf-8') as handle:
			content = json.load(handle)
	except Exception as ex:
		xbmc.log(str(ex), 3)
		content=[]
	return content

def WriteList(filename, list):
	try:
		with io.open(filename, 'w', encoding='utf-8') as handle:
			handle.write(uni_code(json.dumps(list, indent=4, ensure_ascii=False)))
		success = True
	except Exception as ex:
		xbmc.log(str(ex), 3)
		success = False
	return success

AddonID = 'plugin.program.redalert'
Addon = xbmcaddon.Addon(AddonID)
AddonName = Addon.getAddonInfo("name")
icon = Addon.getAddonInfo('icon')
profileDir = decode(translatePath(Addon.getAddonInfo("profile")), "utf-8")
addonDir = decode(Addon.getAddonInfo('path'), 'utf-8')
audioDir = '{0}/resources/audio'.format(addonDir)
if not os.path.exists(profileDir):
	os.makedirs(profileDir)
districtsFile =  os.path.join(addonDir, 'resources', 'lists', 'districts.json')
selectedDistrictsFile =  os.path.join(profileDir, 'selectedDistricts.json')
if not os.path.isfile(selectedDistrictsFile):
	WriteList(selectedDistrictsFile, [])

def GetRedAlerts():
	newAlerts = []
	try:
		req = Request('http://redalert.me/alerts', headers={'Connection': 'Keep-Alive', 'User-Agent': 'Apache-HttpClient/UNAVAILABLE (java 1.4)'})
		text = urlopen(req).read()
		alerts = json.loads(text)
		if len(alerts) < 1:
			return newAlerts
	except:
		xbmc.log('Cannot get alerts from server', 5)
		return newAlerts
	lastAlert = 0
	lastAlertFile = os.path.join(profileDir, 'lastalert.txt')
	if os.path.isfile(lastAlertFile):
		try:
			with open(lastAlertFile, 'r') as handle:
				lastAlert = int(handle.read())
		except:
			pass
	newestAlert = alerts[0]['date']
	if newestAlert > lastAlert:
		with open(lastAlertFile, 'w') as handle:
			handle.write(str(newestAlert))
	else:
		return newAlerts
	now = int(time.time())
	for alert in alerts:
		if now <= (alert['date'] + 180):
			newAlerts.append(alert['area'])
	return newAlerts

def GetIntSetting(key, defValue):
	valS = Addon.getSetting(key).strip()
	try:
		val = int(valS)
	except:
		xbmc.log('Bad {0}.  -{1}-'.format(key, valS), 5)
		val = defValue
	return val

def GetLocaleString(id):
	return encode(Addon.getLocalizedString(id), 'utf-8')

def GetMultiChoiceSelected(title, list):
	import resources.lib.multiChoiceDialog as multiChoiceDialog
	dialog = multiChoiceDialog.MultiChoiceDialog(title, list)
	dialog.doModal()
	selected = dialog.selected[:]
	del dialog #You need to delete your instance when it is no longer needed because underlying xbmcgui classes are not grabage-collected. 
	return selected

def GetUnSelectedList(fullList, selectedList):
	unSelectedList = []
	for index, item in enumerate(fullList):
		if not any(selectedItem["id"] == item.get("id", "") for selectedItem in selectedList):
			unSelectedList.append(item)
	return unSelectedList

def AddDistricts():
	allDistrictsList = ReadList(districtsFile)
	selectedistrictsList = ReadList(selectedDistrictsFile)
	districts = GetUnSelectedList(allDistrictsList, selectedistrictsList)
	districtsNames = [item["label"] for item in districts]
	selected = GetMultiChoiceSelected(GetLocaleString(31999), districtsNames)
	if len(selected) < 1:
		return
	selectedList = [districts[item] for item in selected]
	WriteList(selectedDistrictsFile, selectedistrictsList + selectedList)

def AddAllDistricts():
	allDistrictsList = ReadList(districtsFile)
	WriteList(selectedDistrictsFile, allDistrictsList)

def RemoveDistricts():
	selectedistrictsList = ReadList(selectedDistrictsFile)
	districts = [item["label"] for item in selectedistrictsList]
	selected = GetMultiChoiceSelected(GetLocaleString(31999), districts)
	if len(selected) < 1:
		return
	for ind in range(len(selected)-1, -1, -1):
		selectedistrictsList.remove(selectedistrictsList[selected[ind]])		
	WriteList(selectedDistrictsFile, selectedistrictsList)

def RemoveAllDistricts():
	WriteList(selectedDistrictsFile, [])

def RedAlert(test=False):
	notification = ''
	newAlerts = GetTestAlerts() if test else GetRedAlerts()
	if len(newAlerts) < 1:
		return
	filterDistricts = Addon.getSetting('filterDistricts') == 'true'
	districtsList = ReadList(selectedDistrictsFile)
	districts = [item["label"] for item in districtsList]
	xbmc.log(str(districts))
	for newAlert in newAlerts:
		if test or not filterDistricts or newAlert in districts:
			notification = '{0} | {1}'.format(notification, newAlert)
	if notification == '':
		return
	xbmc.log(notification, 5)
	notificationDuration = GetIntSetting('notificationDuration', 30)
	playSound = Addon.getSetting('playSound') == 'true'
	xbmcgui.Dialog().notification(AddonName, notification[2:], icon, notificationDuration*1000, False)
	if playSound:
		alertWav = '{0}/alert.wav'.format(audioDir)
		xbmc.playSFX(alertWav)

def Loop():
	if Addon.getSetting('isServiceActive') != 'true':
		Addon.setSetting('isServiceActive', 'true')
	seconds = GetIntSetting('interval', 10)
	redAlertCommand = 'RunPlugin(plugin://plugin.program.redalert/?mode=0)'
	xbmc.executebuiltin('AlarmClock(redalert,{0},{1:02d}:{2:02d},silent)'.format(redAlertCommand, seconds//60, seconds%60))

def Mute():
	xbmc.executebuiltin('CancelAlarm(redalert,silent)')
	if Addon.getSetting('isServiceActive') != 'false':
		Addon.setSetting('isServiceActive', 'false')
 
def GetTestAlerts():
	newAlerts = ['בדיקה 1', 'בדיקה 2', 'בדיקה 3', 'בדיקה 4', 'בדיקה 5', 'בדיקה 6', 'בדיקה 7', 'בדיקה 8', 'בדיקה 9', 'בדיקה 10']
	return newAlerts
 
params = dict(urlparse.parse_qsl(sys.argv[2].replace('?','')))
mode = int(params.get('mode','-1'))

if mode == -1:
	Addon.openSettings()
elif mode == 0:
	RedAlert()
	Loop()
elif mode == 1:
	RedAlert()
elif mode == 2:
	Mute()
elif mode == 3:
	RedAlert(test=True)
elif mode == 4:
	AddDistricts()
elif mode == 5:
	RemoveDistricts()
elif mode == 6:
	AddAllDistricts()
elif mode == 7:
	RemoveAllDistricts()
