# -*- coding: utf-8 -*-
from requests import get
from resources.lib.modules import control
import sys,re,json,urllib,urlparse
from datetime import datetime

class seasons:
	def __init__(self):
		self.list = []
		self.headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'X-API-VERSION': 'V2', 'Authorization': 'Bearer '+control.addon().getSetting('token')}

	def seasonsCategory(self, imdb):
		try:
			response = get(control.myaddon_link+'info/tvshows/%s'%imdb, headers=self.headers)
			data = json.loads(response.text)
			if "data" not in data:
				print "### ERROR Load TV Shows Info JSON: {0}".format(imdb)
				return
			
			tvshow = data["data"][0]
			meta = tvshow["meta"]

			userLang = control.apiLanguage(control.lang)["id"]

						
			if 'poster' in meta:
				poster = meta['poster']
			else:
				poster = 0

			if 'fanart' in meta:
				fanart = meta['fanart']
			else:
				fanart = 0
			seasons = []
			for season in tvshow["meta"]["seasons"]:
				self.list.append({'season': season,"imdb":imdb,"poster":poster,"fanart":fanart})
			
			self.tvshowSeasonDirectory(self.list)
			return self.list
		except:
			pass

	def tvshowSeasonDirectory(self, items):
		if items == None or len(items) == 0: control.idle() ; sys.exit()

		sysaddon = sys.argv[0]
		syshandle = int(sys.argv[1])

		for i in items:
			try:
				label = "Season %s"%i['season']
				systitle = sysname = urllib.quote_plus(label)
				imdb = i['imdb']

				url = '%s?action=tvshowsEpisods&season=%s&imdb=%s&title=%s' % (sysaddon,i['season'], imdb, systitle)

				cm = []

				item = control.item(label=label)

				art = {}

				if 'poster' in i and not i['poster'] == '0':
					art.update({'icon': i['poster'], 'thumb': i['poster'], 'poster': i['poster']})

				if 'banner' in i and not i['banner'] == '0':
					art.update({'banner': i['banner']})
				elif 'fanart' in i and not i['fanart'] == '0':
					art.update({'banner': i['fanart']})

				if 'clearlogo' in i and not i['clearlogo'] == '0':
					art.update({'clearlogo': i['clearlogo']})

				if 'clearart' in i and not i['clearart'] == '0':
					art.update({'clearart': i['clearart']})

				if 'fanart' in i and not i['fanart'] == '0':
					item.setProperty('Fanart_Image', i['fanart'])
				

				item.setArt(art)

				control.addItem(handle=syshandle, url=url, listitem=item, isFolder=True)
			except:
				pass

		control.content(syshandle, 'tvshows')
		control.directory(syshandle, cacheToDisc=True)

class episodes:
	def __init__(self):
		self.list = []
		self.headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'X-API-VERSION': 'V2', 'Authorization': 'Bearer '+control.addon().getSetting('token')}
		
	def episodesCategory(self, imdb, season):
		try:
			response = get(control.myaddon_link+'info/tvshows/%s'%imdb, headers=self.headers)
			data = json.loads(response.text)
			if "data" not in data:
				print "### ERROR Load TV Shows Info JSON: {0}".format(imdb)
				return
			
			tvshow = data["data"][0]
			meta = tvshow["meta"]
			meta_episodes = tvshow["meta_episodes"]
			
			if 'fanart' in meta:
				fanart = meta['fanart']
			else:
				fanart = 0
			
			for seasonData in meta_episodes:
				if int(seasonData["seasonNumber"]) == int(season):
					break
			
			episodes = seasonData["episodes"]
			episodes.sort(key=lambda x: [x['episode']])
			for episode in episodes:
				try:
					if 'episode' in episode:
						title = "%d. "%episode["episode"]

					if 'title' in episode:
						title = title+episode['title']
					else:
						title = 0
					
					if 'plot' in episode and episode['plot']:
						plot = episode['plot']
					else:
						plot = ''

					if 'screenshot' in episode:
						poster = episode['screenshot']
					else:
						poster = meta['poster']

					if 'duration' in episode:
						duration = int(episode['duration'])
					else:
						duration = '0'

					if 'released' in episode:
						ts = int(episode['released'])
						premiered = datetime.utcfromtimestamp(ts).strftime('%Y-%m-%d')
					else:
						premiered = '0'
					
					title = title.encode('utf-8')
					plot = plot.encode('utf-8')					

					self.list.append({'title': title,"imdb":imdb,"poster":poster,"fanart":fanart,"premiered":premiered,"plot":plot,"duration":duration,"season":int(season),"episode":int(episode["episode"])})
				except: 
					print "####### ERROR JSON Rec: {0}".format(episode)
					pass
					
			self.tvshowSeasonDirectory(self.list)
			return self.list
		except:
			pass			

	def tvshowSeasonDirectory(self, items):
		if items == None or len(items) == 0: control.idle() ; sys.exit()
		
		sysaddon = sys.argv[0]
		syshandle = int(sys.argv[1])
		
		historyArray = {}
		imdbs = []
		for i in items:
			if i['imdb'] not in imdbs:
				imdbs.append(i['imdb'])
		
		seperator = ', '
		response = get(control.myaddon_link+'history/%s'%(seperator.join(imdbs)), headers=self.headers)
		hisotryJson = json.loads(response.text)
		if "data" in hisotryJson:
			for h2 in hisotryJson["data"]:
				imdbH = h2["imdb_id"]
				for seIndex in h2["data"]:
					historyIndex = "%s-%s"%(imdbH,seIndex)
					h = h2["data"][seIndex]
					if "seconds" in h and h["seconds"]>0:
						historyArray[historyIndex] = h["seconds"]
					if "watched" in h and h["watched"]==True:
						historyArray[historyIndex] = 999999
		
		#control.dialog.ok("zzz","%s"%historyArray)
		for i in items:
			try:
				imdb = i['imdb']
				season = int(i['season'])
				episode = int(i['episode'])
				historyIndex = "%s-%s-%s"%(imdb,season,episode)

				label = i['title']
				item = control.item(label=label)
				systitle = sysname = urllib.quote_plus(i['title'])
				
				meta = {}
				meta.update({'mediatype': 'episode'})
				meta.update({'plot': i['plot']})
				meta.update({'title': i['title']})
				meta.update({'premiered': i['premiered']})
				
				item.setProperty("TotalTime", '')
				
				poster = 0
				if 'poster' in i and not i['poster'] == '0':
					poster = i['poster']
				
				ResumeTime = 0
				if historyIndex in historyArray:
					ResumeTime = str(historyArray[historyIndex])
					
				url = '%s?action=episodePlay&imdb=%s&season=%s&episode=%s&resumeTime=%s&title=%s&poster=%s&plot=%s' % (sysaddon, imdb, season, episode, ResumeTime, systitle, poster, urllib.quote_plus(i['plot']))

				cm = []

				
				item.setProperty("TotalTime", "")
				
				if historyIndex in historyArray:
					if historyArray[historyIndex]==999999:
						meta.update({'playcount': 1})
					else:
						item.setProperty("ResumeTime", str(historyArray[historyIndex]))
						item.setProperty("StartOffset", str(historyArray[historyIndex]))
			
				art = {}

				if poster != '0':
					art.update({'icon': i['poster'], 'thumb': i['poster'], 'poster': i['poster']})

				if 'banner' in i and not i['banner'] == '0':
					art.update({'banner': i['banner']})
				elif 'fanart' in i and not i['fanart'] == '0':
					art.update({'banner': i['fanart']})

				if 'fanart' in i and not i['fanart'] == '0':
					item.setProperty('Fanart_Image', i['fanart'])

				#del (meta["fanart"]);del (meta["imdb"]);del (meta["poster"]);
				item.setArt(art)
				item.addContextMenuItems(cm)
				item.setInfo(type='Video', infoLabels = meta)
				

				control.addItem(handle=syshandle, url=url, listitem=item, isFolder=False)
			except:
				pass

		control.content(syshandle, 'tvshows')
		control.directory(syshandle, cacheToDisc=True)

	def episodesMyList(self):
		response = get(control.myaddon_link+'favorite/episodes', headers=self.headers)
		Json = json.loads(response.text)
		
		if "data" in Json:
			return self.episodesItems(Json["data"])
	
	def episodesList(self):
		response = get(control.myaddon_link+'info/tvshow/episodes/newest/0/200', headers=self.headers)
		Json = json.loads(response.text)
		
		if "data" in Json:
			return self.episodesItems(Json["data"])

	def episodesDateList(self,param):
		response = get(control.myaddon_link+'info/tvshow/episodes/%s'%param, headers=self.headers)
		Json = json.loads(response.text)
		
		if "data" in Json:
			return self.episodesItems(Json["data"])

	def episodesItems(self,data):
		for episodeData in data:
			try:
				imdb = episodeData['imdb_id']
				episode = episodeData['episode']
				season = episodeData['season']
				plot = ''
				poster = 0
				fanart = 0
				
				meta = episodeData["meta"]
				
				if "title" not in meta:
					continue
				title = meta['title']+" S%s:E%s "%(season,episode)
				if "poster" in meta:
					poster = meta['poster']
				if "fanart" in meta:
					fanart = meta['fanart']
				
				if "meta_episode" in meta:
					meta_episode = meta["meta_episode"]
					
					if "title" in meta_episode:
						title = title + "%s"%meta_episode["title"]

					if 'plot' in meta_episode:
						plot = meta_episode['plot']
						try:
							plot = plot.encode('utf-8')		
						except:
							pass						
					if 'duration' in meta_episode:
						duration = int(meta_episode['duration'])
					else:
						duration = '0'

				if 'released' in meta:
					premiered = meta_episode['released'][0:10]
				else:
					premiered = '0'
					
				title = title.encode('utf-8')
							
				
				info = {'title': title,"imdb":imdb,"poster":poster,"fanart":fanart,"premiered":premiered,"plot":plot,"duration":duration,"season":int(season),"episode":int(episode)}
				self.list.append(info)
			except: 
				print "####### ERROR JSON Rec: {0}".format(episodeData)
				pass
				
		self.tvshowSeasonDirectory(self.list)
		return self.list

