package br.com.devfestsul.planetas.fragments.adapter;


import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.List;

import br.com.devfestsul.planetas.R;
import br.com.devfestsul.planetas.domain.Planeta;


// Herda de RecyclerView.Adapter e declara o tipo genérico <PlanetaAdapter.PlanetasViewHolder>
public class PlanetaAdapter extends RecyclerView.Adapter<PlanetaAdapter.PlanetasViewHolder> {
    protected static final String TAG = "livroandroid";
    private final List<Planeta> planetas;
    private final Context context;
    private final PlanetaOnClickListener onClickListener;

    public interface PlanetaOnClickListener {
        void onClickPlaneta(PlanetasViewHolder holder, int idx);
    }

    public PlanetaAdapter(Context context, List<Planeta> planetas, PlanetaOnClickListener onClickListener) {
        this.context = context;
        this.planetas = planetas;
        this.onClickListener = onClickListener;
    }

    @Override
    public PlanetasViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        View view = LayoutInflater.from(context).inflate(R.layout.adapter_planeta, viewGroup, false);
        PlanetasViewHolder holder = new PlanetasViewHolder(view);
		// (1) Chave da animação
        //ViewCompat.setTransitionName(holder.img, context.getString(R.string.transition_key));
        return holder;
    }

    @Override
    public void onBindViewHolder(final PlanetasViewHolder holder, final int position) {
        // Atualizada a view
        Planeta c = planetas.get(position);

        holder.tNome.setText(c.nome);
        holder.img.setImageResource(c.img);


        if (onClickListener != null) {
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    // Chama o listener para informar que clicou no Planeta
                    onClickListener.onClickPlaneta(holder, position);
                }
            });
        }
    }

    @Override
    public int getItemCount() {
        return this.planetas != null ? this.planetas.size() : 0;
    }

    public static class PlanetasViewHolder extends RecyclerView.ViewHolder {
        public TextView tNome;
        public ImageView img;
        public View view;

        public PlanetasViewHolder(View view) {
            super(view);
            this.view = view;
            // Cria as views para salvar no ViewHolder
            tNome = (TextView) view.findViewById(R.id.tNome);
            img = (ImageView) view.findViewById(R.id.img);


        }
    }


}